/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.busi.api.UccSkuRecordSameSkuCountBusiService;
import com.tydic.commodity.busibase.busi.bo.UccSkuBatchShopIdListBO;
import com.tydic.commodity.busibase.busi.bo.UccSkuRecordSameSkuCountBO;
import com.tydic.commodity.busibase.busi.bo.UccSkuRecordSameSkuCountReqBO;
import com.tydic.commodity.busibase.busi.bo.UccSkuRecordSameSkuCountRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.dyc.base.utils.JUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccSkuRecordSameSkuCountBusiServiceImpl
implements UccSkuRecordSameSkuCountBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuRecordSameSkuCountBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @Override
    public UccSkuRecordSameSkuCountRspBO getSameSkuCountByStandardCommodityId(UccSkuRecordSameSkuCountReqBO reqBO) {
        UccSkuRecordSameSkuCountRspBO rspBO = new UccSkuRecordSameSkuCountRspBO();
        List<UccSkuPo> sameSkuCount = this.uccSkuMapper.getSameSkuCount();
        rspBO.setUccSkuRecordSameSkuCountBOList(JUtil.jsl(sameSkuCount, UccSkuRecordSameSkuCountBO.class));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public UccSkuRecordSameSkuCountRspBO getSkuIdList(UccSkuRecordSameSkuCountReqBO reqBO) {
        UccSkuRecordSameSkuCountRspBO rspBO = new UccSkuRecordSameSkuCountRspBO();
        List<UccSkuPo> skuIdList = this.uccSkuMapper.getSkuIdList(reqBO.getStandardCommodityId());
        rspBO.setBatchShopIdList(JUtil.jsl(skuIdList, UccSkuBatchShopIdListBO.class));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public UccSkuRecordSameSkuCountRspBO modifySameSkuCountByStandardCommodityId(UccSkuRecordSameSkuCountReqBO reqBO) {
        UccSkuRecordSameSkuCountRspBO rspBO = new UccSkuRecordSameSkuCountRspBO();
        int count = 0;
        try {
            count = this.uccSkuMapper.modifySameSkuCount(reqBO.getStandardCommodityId(), reqBO.getSameSkuCount());
        }
        catch (Exception e) {
            log.error("\u540c\u6b3e\u5546\u54c1\u6570\u636e\u91cf\u4fee\u6539\u5931\u8d25\uff1a" + e.getMessage());
            throw new BusinessException(RspConstantEnums.SYSTEM_EXCEPTION.code(), e.getMessage());
        }
        if (count < 1) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u540c\u6b3e\u5546\u54c1\u6570\u636e\u91cf\u4fee\u6539\u5931\u8d25");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

