/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.commodity.busibase.atom.api.SyncNormSpuToEsAtomService;
import com.tydic.commodity.busibase.atom.bo.EsNormSpuInfoBO;
import com.tydic.commodity.busibase.atom.bo.SyncNormSpuToEsAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.SyncNormSpuToEsAtomRspBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.UccNormSpuControlMapper;
import com.tydic.commodity.dao.UccNormSpuMapper;
import com.tydic.commodity.po.UccNormSpuControlPO;
import com.tydic.commodity.po.UccNormSpuPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SyncNormSpuToEsAtomServiceImpl
implements SyncNormSpuToEsAtomService {
    private static final Logger log = LoggerFactory.getLogger(SyncNormSpuToEsAtomServiceImpl.class);
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private UccNormSpuMapper uccNormSpuMapper;
    @Autowired
    private UccNormSpuControlMapper uccNormSpuControlMapper;

    @Override
    public SyncNormSpuToEsAtomRspBO syncNormSpuToEs(SyncNormSpuToEsAtomReqBO reqBO) {
        SyncNormSpuToEsAtomRspBO atomRspBO = new SyncNormSpuToEsAtomRspBO();
        atomRspBO.setRespCode("0000");
        if (CollectionUtils.isEmpty(reqBO.getVCommodityIdList())) {
            return atomRspBO;
        }
        UccNormSpuPO uccNormSpuPO = new UccNormSpuPO();
        uccNormSpuPO.setVCommodityIdList(reqBO.getVCommodityIdList());
        List<UccNormSpuPO> uccNormSpuPOList = this.uccNormSpuMapper.getList(uccNormSpuPO);
        if (CollectionUtils.isEmpty(uccNormSpuPOList)) {
            return atomRspBO;
        }
        UccNormSpuControlPO controlPO = new UccNormSpuControlPO();
        controlPO.setVCommodityIds(uccNormSpuPOList.stream().map(UccNormSpuPO::getVCommodityId).collect(Collectors.toList()));
        List<UccNormSpuControlPO> spuControlPOList = this.uccNormSpuControlMapper.getList(controlPO);
        Map controlMap = spuControlPOList.stream().collect(Collectors.toMap(UccNormSpuControlPO::getVCommodityId, Function.identity()));
        if (reqBO.getOperType() == null || "1".equals(reqBO.getOperType().toString())) {
            ArrayList<EsNormSpuInfoBO> normSpuInfoBOS = new ArrayList<EsNormSpuInfoBO>();
            uccNormSpuPOList.stream().forEach(a -> {
                EsNormSpuInfoBO each = new EsNormSpuInfoBO();
                each.setV_commodity_id(a.getVCommodityId());
                each.setV_commodity_name(a.getVCommodityName());
                each.setMarking_remark(a.getMarkingRemark());
                each.setCategory_id(a.getCategoryId());
                each.setCategory_name(a.getCategoryName());
                each.setCommodity_num(a.getCommodityNum());
                each.setCreate_time(a.getCreateTime());
                each.setUpdate_time(a.getUpdateTime());
                each.setSync_date(a.getSyncDate());
                each.setSync_time(a.getSyncTime());
                each.setProp_arry(a.getPropArry());
                if (controlMap.containsKey(a.getVCommodityId())) {
                    each.setControl(1);
                    each.setCommodity_num(((UccNormSpuControlPO)controlMap.get(a.getVCommodityId())).getCommodityNum());
                } else {
                    each.setControl(0);
                    each.setCommodity_num(0);
                }
                normSpuInfoBOS.add(each);
            });
            this.syncNormSpuInfoToEs(normSpuInfoBOS);
        } else {
            this.deleteSpuInfoFromEs(reqBO);
        }
        return atomRspBO;
    }

    private void syncNormSpuInfoToEs(List<EsNormSpuInfoBO> esNormSpuInfoBOS) {
        if (CollectionUtils.isEmpty(esNormSpuInfoBOS)) {
            return;
        }
        for (EsNormSpuInfoBO esEach : esNormSpuInfoBOS) {
            String jsonStr = JSONObject.toJSONString((Object)esEach, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            String esId = String.valueOf(esEach.getV_commodity_id());
            String id = this.elasticsearchUtil.addData(this.esConfig.getNormSpuIndex(), this.esConfig.getNormSpuType(), esId, jsonObject);
            if (!StringUtils.isBlank((CharSequence)id)) continue;
            log.error("\u5546\u54c1\u4fe1\u606f[" + esEach.getV_commodity_id() + "]\u540c\u6b65\u5931\u8d25!");
        }
    }

    private void deleteSpuInfoFromEs(SyncNormSpuToEsAtomReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getVCommodityIdList())) {
            return;
        }
        JSONObject delConditionOrderJson = new JSONObject();
        delConditionOrderJson.put("v_commodity_id", reqBO.getVCommodityIdList());
        JSONObject termOrderJson = new JSONObject();
        termOrderJson.put("terms", (Object)delConditionOrderJson);
        JSONObject termAfsJson = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)termOrderJson);
        JSONObject mustJson = new JSONObject();
        mustJson.put("must", (Object)jsonArray);
        JSONObject boolJson = new JSONObject();
        boolJson.put("bool", (Object)mustJson);
        JSONObject qryJson = new JSONObject();
        qryJson.put("query", (Object)boolJson);
        String endPoint = "/" + this.esConfig.getNormSpuIndex() + "/" + this.esConfig.getNormSpuType() + "/_delete_by_query";
        Boolean deleteResult = this.elasticsearchUtil.deleteDataByCondition(endPoint, qryJson);
        if (!deleteResult.booleanValue()) {
            log.error("\u5220\u9664\u6807\u51c6\u5546\u54c1\u4fe1\u606f\u5931\u8d25!");
        }
    }
}

