/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl.mq.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.commodity.base.bo.SelfRunSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.busibase.busi.api.UccSkuRecordSameSkuCountBusiService;
import com.tydic.commodity.busibase.busi.bo.UccSkuBatchShopIdListBO;
import com.tydic.commodity.busibase.busi.bo.UccSkuRecordSameSkuCountBO;
import com.tydic.commodity.busibase.busi.bo.UccSkuRecordSameSkuCountReqBO;
import com.tydic.commodity.busibase.busi.bo.UccSkuRecordSameSkuCountRspBO;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class UccRecordSameSkuCountMqServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(UccRecordSameSkuCountMqServiceConsumer.class);
    @Autowired
    private UccSkuRecordSameSkuCountBusiService uccSkuRecordSameSkuCountBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        String content = proxyMessage.getContent();
        log.info("\u540c\u6b65\u5e76\u4fee\u6539\u6807\u51c6\u5546\u54c1\u7f16\u7801\u5bf9\u5e94\u7684\u540c\u6b3e\u5546\u54c1\u6570\u91cf\u6d88\u8d39\u8005\u6536\u5230\uff0c\u6570\u636e\u5185\u5bb9\u5982\u4e0b:{}" + content);
        try {
            List list = JSONArray.parseArray((String)content, UccSkuRecordSameSkuCountBO.class);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                for (UccSkuRecordSameSkuCountBO skuCountBO : list) {
                    try {
                        UccSkuRecordSameSkuCountRspBO skuIdList;
                        Map<Long, List<UccSkuBatchShopIdListBO>> collect;
                        Integer sameSkuCount = skuCountBO.getSameSkuCount();
                        String standardCommodityId = skuCountBO.getStandardCommodityId();
                        if (ObjectUtils.isEmpty((Object)sameSkuCount) || ObjectUtils.isEmpty((Object)standardCommodityId)) continue;
                        UccSkuRecordSameSkuCountReqBO recordSameSkuCountReqBO = new UccSkuRecordSameSkuCountReqBO();
                        recordSameSkuCountReqBO.setSameSkuCount(sameSkuCount);
                        recordSameSkuCountReqBO.setStandardCommodityId(standardCommodityId);
                        UccSkuRecordSameSkuCountRspBO recordSameSkuCountRspBO = this.uccSkuRecordSameSkuCountBusiService.modifySameSkuCountByStandardCommodityId(recordSameSkuCountReqBO);
                        if (!"0000".equals(recordSameSkuCountRspBO.getRespCode()) || CollectionUtils.isEmpty(collect = (skuIdList = this.uccSkuRecordSameSkuCountBusiService.getSkuIdList(recordSameSkuCountReqBO)).getBatchShopIdList().stream().collect(Collectors.groupingBy(UccSkuBatchShopIdListBO::getSupplierShopId)))) continue;
                        for (Long supplierShopId : collect.keySet()) {
                            List skuIds = collect.get(supplierShopId).stream().map(UccSkuBatchShopIdListBO::getSkuId).distinct().collect(Collectors.toList());
                            SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
                            syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skuIds));
                            syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
                            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                            try {
                                log.info("\u4fee\u6539\u6807\u51c6\u5546\u54c1\u7f16\u7801\u5bf9\u5e94\u7684\u540c\u6b3e\u5546\u54c1\u6570\u91cf\u901a\u8fc7\u6d88\u8d39\u8005es\u540c\u6b65\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
                                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty("LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty("LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                            }
                            catch (Exception e) {
                                log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.error("\u4fee\u6539\u6807\u51c6\u5546\u54c1\u7f16\u7801\u5bf9\u5e94\u7684\u540c\u6b3e\u5546\u54c1\u6570\u91cf\uff1a" + e);
                    }
                }
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            log.error("\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
            return ProxyConsumerStatus.RECONSUME_LATER;
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u5e76\u4fee\u6539\u6807\u51c6\u5546\u54c1\u7f16\u7801\u5bf9\u5e94\u7684\u540c\u6b3e\u5546\u54c1\u6570\u91cf\u6d88\u8d39\u8005\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return ProxyConsumerStatus.RECONSUME_LATER;
        }
    }
}

