/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.busibase.comb.api.UccSkuManagementListQryCombService;
import com.tydic.commodity.busibase.comb.bo.UccSkuManagementListCombQryBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuManagementListQryCombReqBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuManagementListQryCombRspBO;
import com.tydic.commodity.common.ability.api.UccSkuManagementListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuManagementListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuManagementListQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSkuManagementListQryBO;
import com.tydic.umc.general.ability.api.CrcQryCorporationListAbilityService;
import com.tydic.umc.general.ability.bo.CorPorationBO;
import com.tydic.umc.general.ability.bo.CrcQryCorporationListAbilityReqBO;
import com.tydic.umc.general.ability.bo.CrcQryCorporationListAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuManagementListQryAbilityService"})
public class UccSkuManagementListQryAbilityServiceImpl
implements UccSkuManagementListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuManagementListQryAbilityServiceImpl.class);
    private static final long serialVersionUID = 1956659951572577168L;
    @Autowired
    private UccSkuManagementListQryCombService uccSkuManagementListQryCombService;
    @Autowired
    private CrcQryCorporationListAbilityService crcQryCorporationListAbilityService;
    @Autowired
    private UccBaseDictionaryAtomService uccDictionaryAtomService;

    @PostMapping(value={"getSkuManagementListQry"})
    public UccSkuManagementListQryAbilityRspBO getSkuManagementListQry(@RequestBody UccSkuManagementListQryAbilityReqBO reqBO) {
        if (reqBO.isPpcQry()) {
            this.dealWhitList(reqBO);
        }
        UccSkuManagementListQryAbilityRspBO rspBO = new UccSkuManagementListQryAbilityRspBO();
        String json = JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
        UccSkuManagementListQryCombRspBO searchCommodityManageCombRspBo = this.uccSkuManagementListQryCombService.getSkuManagementListQry((UccSkuManagementListQryCombReqBO)JSON.parseObject((String)json, UccSkuManagementListQryCombReqBO.class));
        BeanUtils.copyProperties((Object)searchCommodityManageCombRspBo, (Object)rspBO);
        if (!CollectionUtils.isEmpty((Collection)searchCommodityManageCombRspBo.getRows())) {
            Map commodityStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap("commodity_status");
            ArrayList<UccSkuManagementListQryBO> rows = new ArrayList<UccSkuManagementListQryBO>();
            for (UccSkuManagementListCombQryBO each : searchCommodityManageCombRspBo.getRows()) {
                UccSkuManagementListQryBO temp = new UccSkuManagementListQryBO();
                BeanUtils.copyProperties((Object)each, (Object)temp);
                if (each.getCommodityStatus() != null && commodityStatusMap.containsKey(each.getCommodityStatus().toString())) {
                    temp.setCommodityStatusDesc((String)commodityStatusMap.get(each.getCommodityStatus().toString()));
                }
                rows.add(temp);
            }
            rspBO.setRows(rows);
        }
        return rspBO;
    }

    void dealWhitList(UccSkuManagementListQryAbilityReqBO reqBO) {
        if (reqBO.getOrgId() != null) {
            CrcQryCorporationListAbilityReqBO crcQryCorporationListAbilityReqBO = new CrcQryCorporationListAbilityReqBO();
            crcQryCorporationListAbilityReqBO.setLocalOrgId(reqBO.getOrgId());
            log.info("\u4f1a\u5458\u67e5\u8be2\u6cd5\u4eba\u5355\u4f4d\u5165\u53c2crcQryCorporationListAbilityReqBO\uff1a" + JSONObject.toJSONString((Object)crcQryCorporationListAbilityReqBO));
            CrcQryCorporationListAbilityRspBO crcQryCorporationListAbilityRspBO = this.crcQryCorporationListAbilityService.qryCorporationList(crcQryCorporationListAbilityReqBO);
            log.info("\u4f1a\u5458\u67e5\u8be2\u6cd5\u4eba\u5355\u4f4d\u51fa\u53c2crcQryCorporationListAbilityRspBO\uff1a" + JSONObject.toJSONString((Object)crcQryCorporationListAbilityRspBO));
            List whitelist = crcQryCorporationListAbilityRspBO.getCorPorationBOList().stream().map(CorPorationBO::getCorporationId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(whitelist)) {
                reqBO.setWhitelist(whitelist);
            }
        } else {
            throw new BusinessException("8888", "\u5165\u53c2\u673a\u6784id\u4e3a\u7a7a");
        }
    }
}

