/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.busibase.atom.api.UccBussiCatalogOperationAddAtomService;
import com.tydic.commodity.busibase.atom.bo.UccBussiCatalogOperationAddAtomBO;
import com.tydic.commodity.busibase.atom.bo.UccBussiCatalogOperationAddAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccBussiCatalogOperationAddAtomRspBO;
import com.tydic.commodity.common.ability.bo.UccBussiCatalogRelSaveAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccBussiCatalogRelSaveAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccBussiCatalogRelSaveBO;
import com.tydic.commodity.common.busi.api.UccBussiCatalogRelSaveBusiService;
import com.tydic.commodity.dao.UccCatalogBussiCatalogRelMapper;
import com.tydic.commodity.po.UccCatalogBussiCatalogRelPO;
import com.tydic.uac.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccBussiCatalogRelSaveBusiServiceImpl
implements UccBussiCatalogRelSaveBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccBussiCatalogRelSaveBusiServiceImpl.class);
    private final Sequence sequence = Sequence.getInstance();
    @Autowired
    private UccCatalogBussiCatalogRelMapper uccCatalogBussiCatalogRelMapper;
    @Autowired
    private UccBussiCatalogOperationAddAtomService uccBussiCatalogOperationAddAtomService;

    @Override
    public UccBussiCatalogRelSaveAbilityRspBO saveBussiCatalogRel(UccBussiCatalogRelSaveAbilityReqBO reqBO) {
        UccBussiCatalogRelSaveAbilityRspBO rspBO = new UccBussiCatalogRelSaveAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Date time = new Date(System.currentTimeMillis());
        List insertList = reqBO.getList().stream().filter(e -> e.getId() == null).collect(Collectors.toList());
        List updateList = reqBO.getList().stream().filter(e -> e.getId() != null).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(insertList)) {
            log.info("\u4e3a\u65b0\u589e\u7684insertList:" + JSON.toJSONString(insertList));
            ArrayList<UccCatalogBussiCatalogRelPO> insertPOs = new ArrayList<UccCatalogBussiCatalogRelPO>();
            for (UccBussiCatalogRelSaveBO each : insertList) {
                UccCatalogBussiCatalogRelPO uccCatalogBussiCatalogRelPO = new UccCatalogBussiCatalogRelPO();
                uccCatalogBussiCatalogRelPO.setCatalogId(each.getCatalogId());
                uccCatalogBussiCatalogRelPO.setBussiCatalogId(each.getBussiCatalogId());
                List list = this.uccCatalogBussiCatalogRelMapper.getList(uccCatalogBussiCatalogRelPO);
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    throw new BusinessException("8888", each.getCatalogId() + "\u548c" + each.getBussiCatalogId() + "\u5df2\u6709\u5173\u8054\u5173\u7cfb\uff0c\u4e0d\u80fd\u518d\u65b0\u589e");
                }
                UccCatalogBussiCatalogRelPO insertPO = new UccCatalogBussiCatalogRelPO();
                BeanUtils.copyProperties((Object)each, (Object)insertPO);
                insertPO.setId(Long.valueOf(this.sequence.nextId()));
                insertPO.setUpdateUserId(reqBO.getUserId());
                insertPO.setUpdateUserName(reqBO.getUsername());
                insertPO.setUpdateName(reqBO.getName());
                insertPO.setUpdateTime(time);
                insertPOs.add(insertPO);
            }
            this.uccCatalogBussiCatalogRelMapper.insertBatch(insertPOs);
            this.addLog(insertPOs, 1, reqBO);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            log.info("\u4e3a\u4fee\u6539\u7684updateList:" + JSON.toJSONString(updateList));
            List ids = updateList.stream().map(UccBussiCatalogRelSaveBO::getId).collect(Collectors.toList());
            UccCatalogBussiCatalogRelPO qryPO = new UccCatalogBussiCatalogRelPO();
            qryPO.setIds(ids);
            List list = this.uccCatalogBussiCatalogRelMapper.getList(qryPO);
            if (CollectionUtils.isEmpty((Collection)list) || list.size() != ids.size()) {
                throw new BusinessException("8888", "\u7528\u5165\u53c2id\u672a\u67e5\u8be2\u5230\u5173\u8054\u5173\u7cfb");
            }
            ArrayList<UccCatalogBussiCatalogRelPO> updatePOs = new ArrayList<UccCatalogBussiCatalogRelPO>();
            Map poMap = list.stream().collect(Collectors.toMap(UccCatalogBussiCatalogRelPO::getId, Function.identity()));
            Map boMap = updateList.stream().collect(Collectors.toMap(UccBussiCatalogRelSaveBO::getId, Function.identity()));
            for (Long id : boMap.keySet()) {
                if (!poMap.containsKey(id)) {
                    throw new BusinessException("8888", "\u5165\u53c2id\uff1a" + id + "\u4e0d\u5b58\u5728\uff01\uff01\uff01");
                }
                UccBussiCatalogRelSaveBO bo = (UccBussiCatalogRelSaveBO)boMap.get(id);
                UccCatalogBussiCatalogRelPO po = (UccCatalogBussiCatalogRelPO)poMap.get(id);
                if (bo.getBussiCatalogId().equals(po.getBussiCatalogId())) continue;
                UccCatalogBussiCatalogRelPO set = new UccCatalogBussiCatalogRelPO();
                set.setBussiCatalogId(bo.getBussiCatalogId());
                set.setBussiCatalogName(bo.getBussiCatalogName());
                set.setUpdateUserId(reqBO.getUserId());
                set.setUpdateUserName(reqBO.getUsername());
                set.setUpdateName(reqBO.getName());
                set.setUpdateTime(time);
                UccCatalogBussiCatalogRelPO where = new UccCatalogBussiCatalogRelPO();
                where.setId(id);
                this.uccCatalogBussiCatalogRelMapper.updateBy(set, where);
                po.setColumn3(set.getBussiCatalogName());
                updatePOs.add(po);
            }
            this.addLog(updatePOs, 2, reqBO);
        }
        return rspBO;
    }

    private void addLog(List<UccCatalogBussiCatalogRelPO> uccBussiCatalogPOs, Integer operationType, UccBussiCatalogRelSaveAbilityReqBO reqBO) {
        UccBussiCatalogOperationAddAtomReqBO addAtomReqBO = new UccBussiCatalogOperationAddAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)addAtomReqBO);
        addAtomReqBO.setLogType(ModelRuleConstant.LOG_TYPE.BUSSI_CATALOG_REL);
        ArrayList<UccBussiCatalogOperationAddAtomBO> list = new ArrayList<UccBussiCatalogOperationAddAtomBO>();
        for (UccCatalogBussiCatalogRelPO each : uccBussiCatalogPOs) {
            UccBussiCatalogOperationAddAtomBO logBO = new UccBussiCatalogOperationAddAtomBO();
            BeanUtils.copyProperties((Object)each, (Object)logBO);
            logBO.setCatalogName(null);
            logBO.setBussiCatalogName(null);
            logBO.setOperationType(operationType);
            if (operationType == 2) {
                logBO.setOperationContent("\u4fee\u6539\uff1a\u5173\u8054\u4e1a\u52a1\u5c0f\u7c7b\u201c" + each.getBussiCatalogName() + "\u201d\u6539\u4e3a\u201c" + each.getColumn3() + "\u201d");
            } else if (operationType == 1) {
                logBO.setOperationContent("\u65b0\u589e\uff1a\u65b0\u589e\u5173\u8054\u201c" + each.getBussiCatalogName() + "\u201d");
            }
            list.add(logBO);
        }
        addAtomReqBO.setList(list);
        UccBussiCatalogOperationAddAtomRspBO rspBO = null;
        try {
            rspBO = this.uccBussiCatalogOperationAddAtomService.addBussiCatalogOperation(addAtomReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u65e5\u5fd7\u63d2\u5165\u51fa\u9519\uff1a" + e.getMessage());
        }
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new BusinessException("8888", "\u65e5\u5fd7\u63d2\u5165\u62a5\u9519\uff1a" + rspBO.getRespDesc());
        }
    }
}

