/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.DicDictionaryBo;
import com.tydic.commodity.common.ability.bo.UccDictionaryAddReqBO;
import com.tydic.commodity.common.ability.bo.UccDictionaryAddRspBO;
import com.tydic.commodity.common.ability.bo.UccDictionaryDeleteReqBO;
import com.tydic.commodity.common.ability.bo.UccDictionaryDeleteRspBO;
import com.tydic.commodity.common.ability.bo.UccDictionaryPageReqBO;
import com.tydic.commodity.common.ability.bo.UccDictionaryPageRspBO;
import com.tydic.commodity.common.ability.bo.UccDictionaryReqBO;
import com.tydic.commodity.common.ability.bo.UccDictionaryRspBO;
import com.tydic.commodity.common.ability.bo.UccDictionaryUpdateReqBO;
import com.tydic.commodity.common.ability.bo.UccDictionaryUpdateRspBO;
import com.tydic.commodity.common.busi.api.UccDicDictionaryService;
import com.tydic.commodity.dao.UccDicDictionaryMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.commodity.utils.ListCloneUtils;
import com.tydic.commodity.utils.ValidatorUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccDicDictionaryServiceImpl
implements UccDicDictionaryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccDicDictionaryServiceImpl.class);
    @Autowired
    private UccDicDictionaryMapper uccDicDictionaryMapper;

    @Override
    public UccDictionaryRspBO queryDictionary(UccDictionaryReqBO reqBO) {
        UccDictionaryRspBO rspBO = new UccDictionaryRspBO();
        if (StringUtils.isEmpty((CharSequence)reqBO.getPCode()) && StringUtils.isEmpty((CharSequence)reqBO.getPtypeCode())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("pCode \u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        String pcode = "";
        if (!StringUtils.isEmpty((CharSequence)reqBO.getPtypeCode())) {
            pcode = reqBO.getPtypeCode();
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getPCode())) {
            pcode = reqBO.getPCode();
        }
        List listPo = this.uccDicDictionaryMapper.selectByPCode(pcode);
        ArrayList<DicDictionaryBo> listBo = new ArrayList<DicDictionaryBo>();
        DicDictionaryBo bo = null;
        if (listPo != null && listPo.size() != 0) {
            for (DicDictionaryPo po : listPo) {
                bo = new DicDictionaryBo();
                BeanUtils.copyProperties((Object)po, (Object)bo);
                if (bo.getCreateTm() != null) {
                    bo.setCreateTm(DateUtils.dateToStr((Date)po.getCreateTm()));
                }
                if (bo.getUpdateTm() != null) {
                    bo.setUpdateTm(DateUtils.dateToStr((Date)po.getUpdateTm()));
                }
                listBo.add(bo);
            }
            rspBO.setRows(listBo);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u5b57\u5178\u6210\u529f");
        return rspBO;
    }

    @Override
    public UccDictionaryPageRspBO queryDictionaryPage(UccDictionaryPageReqBO reqBO) {
        List dicDictionaryBos;
        UccDictionaryPageRspBO uccDictionaryPageRspBO = new UccDictionaryPageRspBO();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        DicDictionaryPo dicDictionaryPo = new DicDictionaryPo();
        dicDictionaryPo.setPCode(reqBO.getPCode());
        List dicDictionaryPos = this.uccDicDictionaryMapper.selectDictionaryPage(page, dicDictionaryPo);
        try {
            dicDictionaryBos = ListCloneUtils.clonePOListToBOListNotDate((List)dicDictionaryPos, DicDictionaryBo.class);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u6570\u636e\u5b57\u6bb5\u5931\u8d25,\u8f6c\u6362\u9519\u8bef");
            uccDictionaryPageRspBO.setRespCode("8888");
            uccDictionaryPageRspBO.setRespDesc("\u5931\u8d25");
            return uccDictionaryPageRspBO;
        }
        uccDictionaryPageRspBO.setRespCode("0000");
        uccDictionaryPageRspBO.setRespDesc("\u6210\u529f");
        uccDictionaryPageRspBO.setPageNo(page.getPageNo());
        uccDictionaryPageRspBO.setTotal(page.getTotalPages());
        uccDictionaryPageRspBO.setRecordsTotal(page.getTotalCount());
        uccDictionaryPageRspBO.setRows(dicDictionaryBos);
        return uccDictionaryPageRspBO;
    }

    @Override
    public UccDictionaryAddRspBO insertDictionary(UccDictionaryAddReqBO reqBO) {
        UccDictionaryAddRspBO uccDictionaryAddRspBO = new UccDictionaryAddRspBO();
        try {
            ValidatorUtil.validator((Object)reqBO);
        }
        catch (BusinessException e) {
            uccDictionaryAddRspBO.setRespCode("8888");
            uccDictionaryAddRspBO.setRespDesc(e.getMsgInfo());
            return uccDictionaryAddRspBO;
        }
        int count = this.uccDicDictionaryMapper.selectcount(reqBO.getCode(), reqBO.getPtypeCode());
        if (count != 0) {
            uccDictionaryAddRspBO.setRespCode("8888");
            uccDictionaryAddRspBO.setRespDesc("\u8be5\u5b57\u5178\u5df2\u7ecf\u5b58\u5728!");
            return uccDictionaryAddRspBO;
        }
        List dicDictionaryPos = this.uccDicDictionaryMapper.selectByPCode(reqBO.getPtypeCode());
        DicDictionaryPo dicDictionaryPo = new DicDictionaryPo();
        dicDictionaryPo.setPCode(reqBO.getPtypeCode());
        dicDictionaryPo.setCode(reqBO.getCode());
        dicDictionaryPo.setCreateTm(new Date());
        dicDictionaryPo.setDelflag(Integer.valueOf(0));
        dicDictionaryPo.setDescrip(reqBO.getDescrip());
        dicDictionaryPo.setTitle(reqBO.getTitle());
        dicDictionaryPo.setOrderId(Integer.valueOf(dicDictionaryPos.size() == 0 ? 0 : dicDictionaryPos.size() + 1));
        this.uccDicDictionaryMapper.insertdicty(dicDictionaryPo);
        uccDictionaryAddRspBO.setRespCode("0000");
        uccDictionaryAddRspBO.setRespDesc("\u65b0\u589e\u5b57\u5178\u6210\u529f");
        return uccDictionaryAddRspBO;
    }

    @Override
    public UccDictionaryUpdateRspBO updateDictionary(UccDictionaryUpdateReqBO reqBO) {
        UccDictionaryUpdateRspBO uccDictionaryUpdateRspBO = new UccDictionaryUpdateRspBO();
        try {
            ValidatorUtil.validator((Object)reqBO);
        }
        catch (BusinessException e) {
            uccDictionaryUpdateRspBO.setRespCode("8888");
            uccDictionaryUpdateRspBO.setRespDesc(e.getMsgInfo());
            return uccDictionaryUpdateRspBO;
        }
        DicDictionaryPo dicDictionaryPo = new DicDictionaryPo();
        dicDictionaryPo.setPCode(reqBO.getPtypeCode());
        dicDictionaryPo.setCode(reqBO.getCode());
        dicDictionaryPo.setDelflag(reqBO.getDelflag());
        dicDictionaryPo.setDescrip(reqBO.getDescrip());
        dicDictionaryPo.setTitle(reqBO.getTitle());
        dicDictionaryPo.setOrderId(reqBO.getOrderId());
        dicDictionaryPo.setUpdateTm(new Date());
        dicDictionaryPo.setUpdateUid(reqBO.getUpdateUid());
        this.uccDicDictionaryMapper.updateByCodeAndPcode(dicDictionaryPo);
        uccDictionaryUpdateRspBO.setRespCode("0000");
        uccDictionaryUpdateRspBO.setRespDesc("\u4fee\u6539\u5b57\u5178\u6210\u529f");
        return uccDictionaryUpdateRspBO;
    }

    @Override
    public UccDictionaryDeleteRspBO deleteDictionary(UccDictionaryDeleteReqBO reqBO) {
        UccDictionaryDeleteRspBO uccDictionaryDeleteRspBO = new UccDictionaryDeleteRspBO();
        try {
            ValidatorUtil.validator((Object)reqBO);
        }
        catch (BusinessException e) {
            uccDictionaryDeleteRspBO.setRespCode("8888");
            uccDictionaryDeleteRspBO.setRespDesc(e.getMsgInfo());
            return uccDictionaryDeleteRspBO;
        }
        int count = this.uccDicDictionaryMapper.selectcount(reqBO.getCode(), reqBO.getPtypeCode());
        if (count == 0) {
            uccDictionaryDeleteRspBO.setRespCode("8888");
            uccDictionaryDeleteRspBO.setRespDesc("\u8be5\u5b57\u5178\u4e0d\u5b58\u5728!");
            return uccDictionaryDeleteRspBO;
        }
        this.uccDicDictionaryMapper.deleteDictionaryByCodeAndCode(reqBO.getCode(), reqBO.getPtypeCode());
        uccDictionaryDeleteRspBO.setRespCode("0000");
        uccDictionaryDeleteRspBO.setRespDesc("\u5220\u9664\u5b57\u5178\u6210\u529f");
        return uccDictionaryDeleteRspBO;
    }

    @Override
    public Map<String, String> queryBypCodeBackMap(String pCode) {
        List listPo = this.uccDicDictionaryMapper.selectByPCode(pCode);
        if (listPo == null || listPo.size() == 0) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (DicDictionaryPo po : listPo) {
            map.put(po.getCode(), po.getTitle());
        }
        return map;
    }
}

