/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.enumType.EbsMaterialSpecsEnum;
import com.tydic.commodity.base.enumType.MaterialSpecsEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccEbsMaterialOperLogAddAtomService;
import com.tydic.commodity.busibase.atom.api.UccEbsMaterialRelCallBackAtomService;
import com.tydic.commodity.busibase.atom.bo.UccEbsMaterialOperLogAddAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccEbsMaterialOperLogAddAtomRspBO;
import com.tydic.commodity.busibase.atom.bo.UccEbsMaterialRelCallBackAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccEbsMaterialRelCallBackAtomRspBO;
import com.tydic.commodity.common.ability.bo.EbsMaterialPropBO;
import com.tydic.commodity.common.ability.bo.UccMaterialEbsRelationStandardMaterialBO;
import com.tydic.commodity.common.ability.bo.UccMaterialEbsRelationSyncFromGovernAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccMaterialEbsRelationSyncFromGovernAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccMaterialEbsRelationSyncFromGovernDataBO;
import com.tydic.commodity.common.busi.api.UccMaterialEbsRelationSyncFromGovernBusiService;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccEbsMaterialMapper;
import com.tydic.commodity.dao.UccSyncMaterialToEbsFailMapper;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccEbsMaterialPO;
import com.tydic.commodity.po.UccSyncMaterialToEbsFailPO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class UccMaterialEbsRelationSyncFromGovernBusiServiceImpl
implements UccMaterialEbsRelationSyncFromGovernBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccMaterialEbsRelationSyncFromGovernBusiServiceImpl.class);
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccEbsMaterialMapper uccEbsMaterialMapper;
    @Autowired
    private UccEbsMaterialOperLogAddAtomService uccEbsMaterialOperLogAddAtomService;
    @Autowired
    private UccEbsMaterialRelCallBackAtomService uccEbsMaterialRelCallBackAtomService;
    @Autowired
    private UccSyncMaterialToEbsFailMapper uccSyncMaterialToEbsFailMapper;

    @Override
    public UccMaterialEbsRelationSyncFromGovernAbilityRspBO dealUccMaterialAddFromDataGovernance(UccMaterialEbsRelationSyncFromGovernAbilityReqBO reqBO) {
        UccMaterialEbsRelationSyncFromGovernAbilityRspBO rspBO = new UccMaterialEbsRelationSyncFromGovernAbilityRspBO();
        UccMaterialEbsRelationSyncFromGovernDataBO data = reqBO.getData();
        Long ebsMaterialId = null;
        UccEMdmMaterialPO mainMaterialPo = this.checkParam(reqBO);
        ebsMaterialId = Long.valueOf(data.getMaterialId());
        UccEbsMaterialPO ebsMaterialPO = this.uccEbsMaterialMapper.selectByPrimaryKey(ebsMaterialId);
        if (!ObjectUtils.isEmpty((Object)ebsMaterialPO)) {
            if (ebsMaterialPO.getMaterialId() == null) {
                UccEbsMaterialPO uccEbsMaterialPO = new UccEbsMaterialPO();
                uccEbsMaterialPO.setEbsMaterialId(ebsMaterialId);
                uccEbsMaterialPO.setMaterialId(mainMaterialPo.getMaterialId());
                this.uccEbsMaterialMapper.updateByPrimaryKeySelective(uccEbsMaterialPO);
                ebsMaterialPO.setMaterialId(mainMaterialPo.getMaterialId());
                ebsMaterialPO.setMaterialCode(mainMaterialPo.getMaterialCode());
                this.addRelLog(ebsMaterialPO);
                rspBO.setSource(ebsMaterialPO.getEbsMaterialId());
            }
        } else {
            UccEbsMaterialPO uccEbsMaterialPO = new UccEbsMaterialPO();
            this.buildEbsMaterialInfo(data, uccEbsMaterialPO);
            uccEbsMaterialPO.setEbsMaterialId(ebsMaterialId);
            uccEbsMaterialPO.setMaterialId(mainMaterialPo.getMaterialId());
            this.uccEbsMaterialMapper.insertSelective(uccEbsMaterialPO);
            uccEbsMaterialPO.setMaterialCode(mainMaterialPo.getMaterialCode());
            this.addRelLog(uccEbsMaterialPO);
            rspBO.setSource(uccEbsMaterialPO.getEbsMaterialId());
        }
        rspBO.setSerialNo(reqBO.getSerialNo());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void buildEbsMaterialInfo(UccMaterialEbsRelationSyncFromGovernDataBO dataBO, UccEbsMaterialPO uccEbsMaterialPO) {
        JSONObject materialJsonObj = new JSONObject();
        if (!CollectionUtils.isEmpty((Collection)dataBO.getMaterialSpecs())) {
            for (EbsMaterialPropBO propBO : dataBO.getMaterialSpecs()) {
                if (MaterialSpecsEnum.getByPropName((String)propBO.getMaterialPropName()) == null) continue;
                materialJsonObj.put(EbsMaterialSpecsEnum.getByPropName((String)propBO.getMaterialPropName()).getPropCode(), (Object)propBO.getMaterialPropValue());
            }
            UccEbsMaterialPO tempEbsMaterialPo = (UccEbsMaterialPO)JSONObject.parseObject((String)JSON.toJSONString((Object)materialJsonObj), UccEbsMaterialPO.class);
            BeanUtils.copyProperties((Object)tempEbsMaterialPo, (Object)uccEbsMaterialPO);
        }
        Date now = new Date();
        uccEbsMaterialPO.setEbsLongDesc(dataBO.getMaterialLongDesc());
        uccEbsMaterialPO.setEbsMaterialCode(dataBO.getMaterialCode());
        uccEbsMaterialPO.setSysCode(dataBO.getSubsidiaryCode());
        uccEbsMaterialPO.setEbsMaterialName(dataBO.getMaterialName());
        uccEbsMaterialPO.setEbsInvalid("N");
        uccEbsMaterialPO.setCreateTime(now);
        uccEbsMaterialPO.setUpdateTime(now);
        uccEbsMaterialPO.setSource(Integer.valueOf(3));
    }

    private UccEMdmMaterialPO checkParam(UccMaterialEbsRelationSyncFromGovernAbilityReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getData())) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e1a\u52a1\u6570\u636e\u3010data\u3011\u4e3a\u7a7a!");
        }
        UccMaterialEbsRelationSyncFromGovernDataBO dataBO = reqBO.getData();
        if (StringUtils.isEmpty((Object)dataBO.getSubsidiaryCode())) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e1a\u52a1\u6570\u636e\u4e1a\u52a1\u5355\u5143\u7f16\u7801\u3010subsidiaryCode\u3011\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((Object)dataBO.getMaterialCode())) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e1a\u52a1\u6570\u636e\u7269\u6599\u7f16\u7801\u3010materialCode\u3011\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((Object)dataBO.getMaterialName())) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e1a\u52a1\u6570\u636e\u7269\u6599\u540d\u79f0\u3010materialName\u3011\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((Object)dataBO.getMaterialId())) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e1a\u52a1\u6570\u636e\u7269\u6599ID\u3010materialId\u3011\u4e3a\u7a7a!");
        }
        if (CollectionUtils.isEmpty((Collection)dataBO.getStandardMaterials())) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e1a\u52a1\u6570\u636e\u7269\u6599\u6807\u51c6\u7269\u6599\u5217\u8868\u3010standardMaterials\u3011\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((Object)dataBO.getMaterialLongDesc())) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e1a\u52a1\u6570\u636e\u7269\u6599\u957f\u63cf\u8ff0\u3010materialLongDesc\u3011\u4e3a\u7a7a!");
        }
        if (dataBO.getStandardMaterials().size() > 1) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e1a\u52a1\u6570\u636e\u7269\u6599\u6807\u51c6\u7269\u6599\u5217\u8868\u3010standardMaterials\u3011\u6570\u636e\uff0c\u53ea\u80fd\u662f\u4e00\u6761\u6570\u636e!");
        }
        UccMaterialEbsRelationStandardMaterialBO standardMaterialBO = (UccMaterialEbsRelationStandardMaterialBO)dataBO.getStandardMaterials().get(0);
        if (StringUtils.isEmpty((Object)standardMaterialBO.getStandardMaterialCode())) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e1a\u52a1\u6570\u636e\u6807\u51c6\u7269\u6599\u7f16\u7801\u3010standardMaterialCode\u3011\u4e3a\u7a7a!");
        }
        UccEMdmMaterialPO materialPO = new UccEMdmMaterialPO();
        materialPO.setMaterialCode(standardMaterialBO.getStandardMaterialCode());
        List materialPOList = this.uccEMdmMaterialMapper.selectMaterialPrecisely(materialPO);
        if (CollectionUtils.isEmpty((Collection)materialPOList)) {
            throw new BusinessException("8888", "\u5173\u8054\u7684\u6807\u51c6\u7269\u6599\u5728\u5546\u57ce\u4e0d\u5b58\u5728\uff01");
        }
        return (UccEMdmMaterialPO)materialPOList.get(0);
    }

    private void addRelLog(UccEbsMaterialPO addlogPO) {
        String type = "";
        UccEbsMaterialOperLogAddAtomReqBO uccEbsMaterialOperLogAddAtomReqBO = (UccEbsMaterialOperLogAddAtomReqBO)JSONObject.parseObject((String)JSON.toJSONString((Object)addlogPO), UccEbsMaterialOperLogAddAtomReqBO.class);
        uccEbsMaterialOperLogAddAtomReqBO.setOperationContent("\u65b0\u589e\uff1a\u65b0\u589eEBS\u7269\u6599\u7f16\u7801" + addlogPO.getEbsMaterialCode() + "\u5173\u8054\u7269\u6599\u7f16\u7801" + addlogPO.getMaterialCode());
        type = "NEW";
        uccEbsMaterialOperLogAddAtomReqBO.setOperationType(Integer.valueOf(1));
        uccEbsMaterialOperLogAddAtomReqBO.setUserId(Long.valueOf(0L));
        uccEbsMaterialOperLogAddAtomReqBO.setUsername("\u540c\u6b65\u66f4\u65b0");
        UccEbsMaterialOperLogAddAtomRspBO uccEbsMaterialOperLogAddAtomRspBO = this.uccEbsMaterialOperLogAddAtomService.ebsMaterialOperLogAdd(uccEbsMaterialOperLogAddAtomReqBO);
        if (!"0000".equals(uccEbsMaterialOperLogAddAtomRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u7269\u6599\u5173\u8054\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25\uff1a" + uccEbsMaterialOperLogAddAtomRspBO.getRespDesc());
        }
        if ("CRC_XH".equals(addlogPO.getSysCode())) {
            return;
        }
        UccEbsMaterialRelCallBackAtomReqBO reqBO = new UccEbsMaterialRelCallBackAtomReqBO();
        reqBO.setEbsMaterialId(addlogPO.getEbsMaterialId());
        reqBO.setType(type);
        try {
            UccEbsMaterialRelCallBackAtomRspBO rspBO = this.uccEbsMaterialRelCallBackAtomService.ebsMaterialRelCallBack(reqBO);
            if (!"0000".equals(rspBO.getRespCode())) {
                UccSyncMaterialToEbsFailPO materialToEbsFailPO = new UccSyncMaterialToEbsFailPO();
                materialToEbsFailPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                materialToEbsFailPO.setEbsMaterialId(addlogPO.getEbsMaterialId());
                materialToEbsFailPO.setRelationType(type);
                materialToEbsFailPO.setUpdateTime(new Date());
                materialToEbsFailPO.setRemark(rspBO.getRespDesc());
                this.uccSyncMaterialToEbsFailMapper.insert(materialToEbsFailPO);
            }
        }
        catch (Exception e) {
            UccSyncMaterialToEbsFailPO materialToEbsFailPO = new UccSyncMaterialToEbsFailPO();
            materialToEbsFailPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            materialToEbsFailPO.setEbsMaterialId(addlogPO.getEbsMaterialId());
            materialToEbsFailPO.setRelationType(type);
            materialToEbsFailPO.setUpdateTime(new Date());
            materialToEbsFailPO.setRemark(e.getMessage());
            this.uccSyncMaterialToEbsFailMapper.insert(materialToEbsFailPO);
        }
    }
}

