/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.busi.api.UccCodegenerationBusiService;
import com.tydic.commodity.common.ability.bo.UccQueryCatalogByMaterialAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccQueryCatalogByMaterialAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccQueryCatalogByMaterialBO;
import com.tydic.commodity.common.busi.api.UccQueryCatalogByMaterialBusiService;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccCommodityMeasureMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.commodity.po.UccCommodityMeasurePo;
import com.tydic.commodity.po.UccQueryCatalogByMaterialPO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccQueryCatalogByMaterialBusiServiceImpl
implements UccQueryCatalogByMaterialBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccQueryCatalogByMaterialBusiServiceImpl.class);
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Autowired
    private UccCommodityMeasureMapper uccCommodityMeasureMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccCodegenerationBusiService uccCodegenerationBusiService;
    private Sequence sequence = Sequence.getInstance();

    @Override
    public UccQueryCatalogByMaterialAbilityRspBO qryCatalog(UccQueryCatalogByMaterialAbilityReqBO reqBO) {
        UccQueryCatalogByMaterialAbilityRspBO rspBO = new UccQueryCatalogByMaterialAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Map<String, List<UccQueryCatalogByMaterialBO>> materialCodeMap = reqBO.getMaterials().stream().collect(Collectors.groupingBy(UccQueryCatalogByMaterialBO::getMaterialCode));
        if (CollectionUtils.isEmpty(materialCodeMap.keySet())) {
            return rspBO;
        }
        rspBO.setMaterials(reqBO.getMaterials());
        List catalogByMaterialPOS = this.uccEMdmMaterialMapper.queryCatalogByMaterial(new ArrayList<String>(materialCodeMap.keySet()));
        if (!CollectionUtils.isEmpty((Collection)catalogByMaterialPOS)) {
            Map<String, List<UccQueryCatalogByMaterialPO>> poMap = catalogByMaterialPOS.stream().collect(Collectors.groupingBy(UccQueryCatalogByMaterialPO::getMaterialCode));
            for (UccQueryCatalogByMaterialBO each : rspBO.getMaterials()) {
                UccCommodityMeasurePo insertPO;
                UccCommodityMeasurePo qryPO;
                if (!poMap.containsKey(each.getMaterialCode())) continue;
                Long agreementDetailsId = new Long(each.getAgreementDetailsId());
                String measureName = new String(each.getMeasureName());
                String brandName = new String(each.getBrandName());
                BeanUtils.copyProperties((Object)poMap.get(each.getMaterialCode()).get(0), (Object)each);
                each.setAgreementDetailsId(agreementDetailsId);
                if (!StringUtils.isEmpty((Object)measureName) && !measureName.equals(each.getMeasureName())) {
                    qryPO = new UccCommodityMeasurePo();
                    qryPO.setMeasureNameExactly(measureName);
                    List uccCommodityMeasurePos = this.uccCommodityMeasureMapper.queryMeasureByPO(qryPO);
                    if (!CollectionUtils.isEmpty((Collection)uccCommodityMeasurePos)) {
                        each.setMeasureId(((UccCommodityMeasurePo)uccCommodityMeasurePos.get(0)).getMeasureId());
                        each.setMeasureName(((UccCommodityMeasurePo)uccCommodityMeasurePos.get(0)).getMeasureName());
                    } else {
                        insertPO = new UccCommodityMeasurePo();
                        insertPO.setMeasureId(Long.valueOf(this.sequence.nextId()));
                        insertPO.setMeasureName(measureName);
                        insertPO.setBriefName(measureName);
                        insertPO.setMeasureType(Integer.valueOf(0));
                        insertPO.setIsDelete(Integer.valueOf(0));
                        insertPO.setStatus(Integer.valueOf(1));
                        insertPO.setCreateLoginId("admin");
                        insertPO.setCreateTime(new Date(System.currentTimeMillis()));
                        insertPO.setRemark("\u5916\u90e8\u534f\u8bae\u5165\u5e93\u65b0\u589e\u8ba1\u91cf\u5355\u4f4d");
                        insertPO.setDecimalLimit(Integer.valueOf(0));
                        this.uccCommodityMeasureMapper.addMeasure(insertPO);
                        each.setMeasureId(insertPO.getMeasureId());
                        each.setMeasureName(insertPO.getMeasureName());
                    }
                }
                if (StringUtils.isEmpty((Object)brandName) || brandName.equals(each.getBrandName())) continue;
                qryPO = new UccBrandDealPO();
                qryPO.setBrandName(brandName);
                List uccBrandDealPOS = this.uccBrandDealMapper.selectBy((UccBrandDealPO)qryPO);
                if (!CollectionUtils.isEmpty((Collection)uccBrandDealPOS)) {
                    each.setBrandId(((UccBrandDealPO)uccBrandDealPOS.get(0)).getBrandId());
                    each.setBrandName(((UccBrandDealPO)uccBrandDealPOS.get(0)).getBrandName());
                    continue;
                }
                insertPO = new UccBrandDealPO();
                insertPO.setBrandId(Long.valueOf(this.sequence.nextId()));
                insertPO.setBrandName(brandName);
                insertPO.setBrandCode("brand_code");
                insertPO.setEffTime(new Date(System.currentTimeMillis()));
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    insertPO.setExpTime(format.parse("2223-01-01 00:00:00"));
                }
                catch (ParseException e) {
                    throw new BusinessException("8888", "\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage());
                }
                insertPO.setBrandStatus(Integer.valueOf(1));
                insertPO.setCreateOperId("sys");
                insertPO.setCreateTime(format.format(new Date(System.currentTimeMillis())));
                insertPO.setRemark("\u5916\u90e8\u534f\u8bae\u5165\u5e93\u65b0\u589e\u54c1\u724c");
                insertPO.setBrandType(Integer.valueOf(0));
                this.uccBrandDealMapper.addBrand((UccBrandDealPO)insertPO);
                each.setBrandId(insertPO.getBrandId());
                each.setBrandName(insertPO.getBrandName());
            }
        }
        return rspBO;
    }
}

