/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.comb.api.UccSkuManagementListQryCombService;
import com.tydic.commodity.busibase.comb.bo.UccSkuManagementListCombQryBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuManagementListQryCombReqBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuManagementListQryCombRspBO;
import com.tydic.commodity.common.ability.bo.UccSyncSameCountSpuPoolAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSyncSameCountSpuPoolAbilityRspBO;
import com.tydic.commodity.common.busi.api.SyncSceneCommodityToEsBusiService;
import com.tydic.commodity.common.busi.api.UccSyncSameCountSpuPoolBusiService;
import com.tydic.commodity.common.busi.impl.Wrapper;
import com.tydic.commodity.dao.UccPoolScopeMapper;
import com.tydic.commodity.dao.UccRelPoolCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccPoolScopePO;
import com.tydic.commodity.po.UccRelPoolCommodityPo;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccSyncSameCountSpuPoolBusiServiceImpl
implements UccSyncSameCountSpuPoolBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSyncSameCountSpuPoolBusiServiceImpl.class);
    @Autowired
    private UccRelPoolCommodityMapper uccRelPoolCommodityMapper;
    @Autowired
    private SyncSceneCommodityToEsBusiService syncSceneCommodityToEsBusiService;
    @Resource(name="lmBatchSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmBatchSyncCommodityMqServiceProvider;
    @Value(value="${LM_UCC_BATCH_SYNC_TOPIC:LM_UCC_BATCH_SYNC_TOPIC}")
    private String lmUccSyncTopic;
    @Value(value="${LM_UCC_SYNC_TAG}")
    private String lmUccSyncTag;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccPoolScopeMapper uccPoolScopeMapper;
    @Autowired
    private UccSkuManagementListQryCombService uccSkuManagementListQryCombService;
    private Sequence sequence = Sequence.getInstance();

    @Override
    public UccSyncSameCountSpuPoolAbilityRspBO syncSameCount(UccSyncSameCountSpuPoolAbilityReqBO reqBO) {
        UccSyncSameCountSpuPoolAbilityRspBO rspBO = new UccSyncSameCountSpuPoolAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ArrayList skuIdss = new ArrayList();
        UccRelPoolCommodityPo poolCommodityPo = new UccRelPoolCommodityPo();
        poolCommodityPo.setPoolId(reqBO.getPoolId());
        List poolCommodityPos = this.uccRelPoolCommodityMapper.queryAll(poolCommodityPo);
        UccPoolScopePO uccPoolScopePo = new UccPoolScopePO();
        uccPoolScopePo.setPoolId(reqBO.getPoolId());
        List uccPoolScopePOS = this.uccPoolScopeMapper.getList(uccPoolScopePo);
        UccSkuManagementListQryCombReqBO uccSkuManagementListQryCombReqBO = new UccSkuManagementListQryCombReqBO();
        ArrayList<Long> agreementIds = new ArrayList<Long>();
        ArrayList<Long> commodityIds = new ArrayList<Long>();
        ArrayList<Long> vendorIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)uccPoolScopePOS)) {
            for (UccPoolScopePO uccPoolScopePO : uccPoolScopePOS) {
                switch (uccPoolScopePO.getSourceType()) {
                    case 1: {
                        commodityIds.add(uccPoolScopePO.getSource());
                        break;
                    }
                    case 2: {
                        agreementIds.add(uccPoolScopePO.getSource());
                        break;
                    }
                    case 3: {
                        vendorIds.add(uccPoolScopePO.getSource());
                    }
                }
            }
        }
        HashMap<Long, List> groupedBySupplierShopId = new HashMap<Long, List>();
        uccSkuManagementListQryCombReqBO.setSameSkuCount(reqBO.getSameSkuCount());
        uccSkuManagementListQryCombReqBO.setAgreementIds(agreementIds);
        uccSkuManagementListQryCombReqBO.setCommodityIds(commodityIds);
        uccSkuManagementListQryCombReqBO.setVendorIds(vendorIds);
        uccSkuManagementListQryCombReqBO.setPageSize(2000);
        int pageNo = 1;
        while (true) {
            uccSkuManagementListQryCombReqBO.setPageNo(pageNo);
            UccSkuManagementListQryCombRspBO uccSkuManagementListQryCombRspBO = this.uccSkuManagementListQryCombService.getSkuManagementListQry(uccSkuManagementListQryCombReqBO);
            List rows = uccSkuManagementListQryCombRspBO.getRows();
            if (rows.isEmpty()) break;
            Map currentPageGroupedBySupplierShopId = rows.stream().filter(uccSku -> uccSku.getSupplierShopId() != null).collect(Collectors.groupingBy(UccSkuManagementListCombQryBO::getSupplierShopId, Collectors.mapping(UccSkuManagementListCombQryBO::getSkuId, Collectors.toList())));
            Wrapper wrapper = new Wrapper(groupedBySupplierShopId);
            currentPageGroupedBySupplierShopId.forEach((supplierShopId, skuIds) -> ((Map)wrapper.getValue()).computeIfAbsent(supplierShopId, k -> new ArrayList()).addAll(skuIds));
            ++pageNo;
        }
        if (!groupedBySupplierShopId.isEmpty()) {
            if (CollectionUtils.isEmpty((Collection)poolCommodityPos)) {
                log.info("\u5168\u8d70\u65b0\u589e");
                try {
                    groupedBySupplierShopId.forEach((supplierShopId, skuIds) -> {
                        log.info("Supplier Shop ID: " + supplierShopId);
                        ArrayList<UccRelPoolCommodityPo> list = new ArrayList<UccRelPoolCommodityPo>();
                        for (Long skuId : skuIds) {
                            UccRelPoolCommodityPo po = new UccRelPoolCommodityPo();
                            po.setId(Long.valueOf(this.sequence.nextId()));
                            po.setPoolId(reqBO.getPoolId());
                            po.setPoolRelated(Integer.valueOf(4));
                            po.setSource(skuId);
                            po.setCreateOper("admin");
                            po.setCreateTime((Date)new Timestamp(System.currentTimeMillis()));
                            list.add(po);
                        }
                        this.uccRelPoolCommodityMapper.batchInsert(list);
                        skuIdss.addAll(skuIds);
                    });
                }
                catch (Exception e) {
                    throw new ZTBusinessException("\u5904\u7406\u5546\u54c1\u6c60\u5f02\u5e38\uff1a " + e.getMessage());
                }
            }
            log.info("\u5148\u5220\u9664\uff0c\u518d\u65b0\u589e");
            Map<Integer, List<UccRelPoolCommodityPo>> relPoolCommodityPoMap = poolCommodityPos.stream().collect(Collectors.groupingBy(UccRelPoolCommodityPo::getPoolRelated));
            relPoolCommodityPoMap.forEach((poolRelated, uccRelPoolCommodityPos) -> {
                switch (poolRelated) {
                    case 1: {
                        for (UccRelPoolCommodityPo uccRelPoolCommodityPo : uccRelPoolCommodityPos) {
                            Long commodityTypeId = uccRelPoolCommodityPo.getSource();
                            this.uccRelPoolCommodityMapper.batchDelete(Arrays.asList(commodityTypeId), reqBO.getPoolId());
                            skuIdss.addAll(this.dealList(null, null, Arrays.asList(commodityTypeId), null, null, 1));
                        }
                        break;
                    }
                    case 2: {
                        for (UccRelPoolCommodityPo uccRelPoolCommodityPo : uccRelPoolCommodityPos) {
                            Long agrId = uccRelPoolCommodityPo.getSource();
                            this.uccRelPoolCommodityMapper.batchDelete(Arrays.asList(agrId), reqBO.getPoolId());
                            skuIdss.addAll(this.dealList(null, Arrays.asList(agrId), null, null, null, 2));
                        }
                        break;
                    }
                    case 3: {
                        for (UccRelPoolCommodityPo uccRelPoolCommodityPo : uccRelPoolCommodityPos) {
                            Long supplierId = uccRelPoolCommodityPo.getSource();
                            this.uccRelPoolCommodityMapper.batchDelete(Arrays.asList(supplierId), reqBO.getPoolId());
                            skuIdss.addAll(this.dealList(Arrays.asList(supplierId), null, null, null, null, 3));
                        }
                        break;
                    }
                    case 4: {
                        List<Long> skus = uccRelPoolCommodityPos.stream().map(UccRelPoolCommodityPo::getSource).collect(Collectors.toList());
                        this.uccRelPoolCommodityMapper.batchDelete(skus, reqBO.getPoolId());
                        skuIdss.addAll(this.dealList(null, null, null, null, skus, 4));
                        break;
                    }
                    case 5: {
                        List<Long> spus = uccRelPoolCommodityPos.stream().map(UccRelPoolCommodityPo::getSource).collect(Collectors.toList());
                        this.uccRelPoolCommodityMapper.batchDelete(spus, reqBO.getPoolId());
                        skuIdss.addAll(this.dealList(null, null, null, spus, null, 5));
                    }
                }
            });
            log.info("\u5220\u9664\u540e\u65b0\u589e");
            try {
                groupedBySupplierShopId.forEach((supplierShopId, skuIds) -> {
                    log.info("Supplier Shop ID: " + supplierShopId);
                    ArrayList<UccRelPoolCommodityPo> list = new ArrayList<UccRelPoolCommodityPo>();
                    for (Long skuId : skuIds) {
                        UccRelPoolCommodityPo po = new UccRelPoolCommodityPo();
                        po.setId(Long.valueOf(this.sequence.nextId()));
                        po.setPoolId(reqBO.getPoolId());
                        po.setPoolRelated(Integer.valueOf(4));
                        po.setSource(skuId);
                        po.setCreateOper("admin");
                        po.setCreateTime((Date)new Timestamp(System.currentTimeMillis()));
                        list.add(po);
                    }
                    this.uccRelPoolCommodityMapper.batchInsert(list);
                    skuIdss.addAll(skuIds);
                });
            }
            catch (Exception e) {
                throw new ZTBusinessException("\u5904\u7406\u5546\u54c1\u6c60\u5f02\u5e38\uff1a " + e.getMessage());
            }
        }
        rspBO.setSkuIds(skuIdss);
        return rspBO;
    }

    private List<Long> dealList(List<Long> vendorIds, List<Long> argIds, List<Long> typeIds, List<Long> spus, List<Long> skuss, Integer type) {
        List<Object> skuList = new ArrayList();
        skuList = type == 4 ? skuss : this.uccSkuMapper.batchQrySkuList(vendorIds, argIds, typeIds, spus, 0, 0, new Page(-1, 999999));
        return skuList;
    }

    private void syncList(List<Long> skuList) {
        int groupSize = 2000;
        List skus = IntStream.range(0, skuList.size()).boxed().collect(Collectors.groupingBy(index -> index / groupSize)).values().stream().map(indices -> indices.stream().map(skuList::get).collect(Collectors.toList())).collect(Collectors.toList());
        for (List skuIds : skus) {
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds(skuIds);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            try {
                this.lmBatchSyncCommodityMqServiceProvider.send(new ProxyMessage(this.lmUccSyncTopic, this.lmUccSyncTag, JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u5546\u54c1\u6570\u636e\u5931\u8d25 \uff1a" + e);
                throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
            }
        }
    }
}

