/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl.mq.consumer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.commodity.common.ability.bo.MaterialPropBO;
import com.tydic.commodity.common.busi.api.UccCallMaterialDataGovernBusiService;
import com.tydic.commodity.common.busi.bo.UccCallMaterialDataGovernBusiReqBO;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccEMdmMaterialPropValueMapper;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccEMdmMaterialPropValuePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class MaterialDataSyncConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(MaterialDataSyncConsumer.class);
    @Autowired
    private UccCallMaterialDataGovernBusiService uccCallMaterialDataGovernBusiService;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccEMdmMaterialPropValueMapper uccEMdmMaterialPropValueMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        String content = message.getContent();
        log.info("\u6807\u51c6\u7269\u6599\u540c\u6b65\u81f3\u6570\u636e\u6cbb\u7406\u5e73\u53f0\uff0c\u6d88\u8d39\u8005\u5165\u53c2:{}" + JSONObject.toJSONString((Object)content));
        try {
            List materialIdList = JSONArray.parseArray((String)content, Long.class);
            if (!CollectionUtils.isEmpty((Collection)materialIdList)) {
                for (Long materialId : materialIdList) {
                    UccCallMaterialDataGovernBusiReqBO busiReqBO = this.buildSyncParam(materialId);
                    if (ObjectUtils.isEmpty((Object)busiReqBO)) continue;
                    this.uccCallMaterialDataGovernBusiService.callMaterialDataGovern(busiReqBO);
                }
            }
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        catch (Exception e) {
            log.error("\u5546\u54c1\u4e2d\u5fc3\u7269\u6599\u6cbb\u7406\u6d88\u8d39\u8005\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return ProxyConsumerStatus.RECONSUME_LATER;
        }
    }

    private UccCallMaterialDataGovernBusiReqBO buildSyncParam(Long materialId) {
        UccEMdmMaterialPO uccEMdmMaterialPO = this.uccEMdmMaterialMapper.selectByPrimaryKey(materialId);
        if (ObjectUtils.isEmpty((Object)uccEMdmMaterialPO)) {
            return null;
        }
        UccEMdmCatalogPO eMdmCatalogPO = new UccEMdmCatalogPO();
        eMdmCatalogPO.setIsDelete(Integer.valueOf(0));
        eMdmCatalogPO.setCatalogId(uccEMdmMaterialPO.getCatalogId());
        List catalogPOS = this.uccEMdmCatalogMapper.qryUccEMdmCatalog(eMdmCatalogPO);
        List uccEMdmMaterialPropValuePOList = this.uccEMdmMaterialPropValueMapper.selectByMaterialId(materialId);
        UccCallMaterialDataGovernBusiReqBO busiReqBO = new UccCallMaterialDataGovernBusiReqBO();
        busiReqBO.setMaterialId(uccEMdmMaterialPO.getMaterialId());
        busiReqBO.setMaterialName(uccEMdmMaterialPO.getMaterialName());
        busiReqBO.setMaterialCode(uccEMdmMaterialPO.getMaterialCode());
        busiReqBO.setCategoryCode(((UccEMdmCatalogPO)catalogPOS.get(0)).getCatalogCode());
        busiReqBO.setCategoryName(uccEMdmMaterialPO.getCatalogName());
        busiReqBO.setLongDesc(uccEMdmMaterialPO.getLongDesc());
        ArrayList<MaterialPropBO> specs = new ArrayList<MaterialPropBO>();
        if (StringUtils.isNotBlank((CharSequence)uccEMdmMaterialPO.getBrandName())) {
            specs.add(this.getMaterialPropBO("\u54c1\u724c", uccEMdmMaterialPO.getBrandName()));
        }
        if (StringUtils.isNotBlank((CharSequence)uccEMdmMaterialPO.getModel())) {
            specs.add(this.getMaterialPropBO("\u578b\u53f7", uccEMdmMaterialPO.getModel()));
        }
        if (StringUtils.isNotBlank((CharSequence)uccEMdmMaterialPO.getSpec())) {
            specs.add(this.getMaterialPropBO("\u89c4\u683c", uccEMdmMaterialPO.getSpec()));
        }
        if (StringUtils.isNotBlank((CharSequence)uccEMdmMaterialPO.getTexture())) {
            specs.add(this.getMaterialPropBO("\u6750\u8d28", uccEMdmMaterialPO.getTexture()));
        }
        if (StringUtils.isNotBlank((CharSequence)uccEMdmMaterialPO.getFigure())) {
            specs.add(this.getMaterialPropBO("\u56fe\u53f7", uccEMdmMaterialPO.getFigure()));
        }
        if (StringUtils.isNotBlank((CharSequence)uccEMdmMaterialPO.getMainModel())) {
            specs.add(this.getMaterialPropBO("\u4e3b\u8bbe\u5907\u578b\u53f7", uccEMdmMaterialPO.getMainModel()));
        }
        if (StringUtils.isNotBlank((CharSequence)uccEMdmMaterialPO.getManufacturer())) {
            specs.add(this.getMaterialPropBO("\u4e3b\u673a\u751f\u4ea7\u5546", uccEMdmMaterialPO.getManufacturer()));
        }
        if (StringUtils.isNotBlank((CharSequence)uccEMdmMaterialPO.getMeasure())) {
            specs.add(this.getMaterialPropBO("\u8ba1\u91cf\u5355\u4f4d", uccEMdmMaterialPO.getMeasure()));
        }
        if (!CollectionUtils.isEmpty((Collection)uccEMdmMaterialPropValuePOList)) {
            for (UccEMdmMaterialPropValuePO propValuePO : uccEMdmMaterialPropValuePOList) {
                specs.add(this.getMaterialPropBO(propValuePO.getPropName(), propValuePO.getPropValue()));
            }
        }
        busiReqBO.setSpecs(specs);
        return busiReqBO;
    }

    public MaterialPropBO getMaterialPropBO(String propName, String propValue) {
        MaterialPropBO materialPropBO = new MaterialPropBO();
        materialPropBO.setPropName(propName);
        materialPropBO.setPropValue(propValue);
        return materialPropBO;
    }
}

