/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.busibase.comb.bo.DycDemandCheckMqCombReqBO;
import com.tydic.commodity.common.ability.api.UccAutoPutOnShelfAbilityService;
import com.tydic.commodity.common.ability.bo.UccAutoPutOnShelfAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccAutoPutOnShelfAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccAutoPutOnShelfBusiService;
import com.tydic.commodity.common.busi.bo.UccAutoPutOnShelfBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccAutoPutOnShelfBusiRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccAutoPutOnShelfAbilityService"})
public class UccAutoPutOnShelfAbilityServiceImpl
implements UccAutoPutOnShelfAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAutoPutOnShelfAbilityServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccAutoPutOnShelfBusiService uccAutoPutOnShelfBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Resource(name="dycDemandCheckMqProvide")
    private ProxyMessageProducer dycDemandCheckMqProvide;
    @Value(value="${UCC_DEMAND_CHECK_TOPIC:UCC_DEMAND_CHECK_TOPIC}")
    private String demandCheckTopic;

    @PostMapping(value={"dealAutoPutOnShelf"})
    public UccAutoPutOnShelfAbilityRspBO dealAutoPutOnShelf(@RequestBody UccAutoPutOnShelfAbilityReqBO reqBO) {
        UccAutoPutOnShelfAbilityRspBO rspBO = new UccAutoPutOnShelfAbilityRspBO();
        List uccSkuPos = this.uccSkuMapper.selectSkuPutCir();
        if (CollectionUtils.isNotEmpty((Collection)uccSkuPos)) {
            UccAutoPutOnShelfBusiReqBO uccAutoPutOnShelfBusiReqBO = new UccAutoPutOnShelfBusiReqBO();
            uccAutoPutOnShelfBusiReqBO.setUccSkuPos(uccSkuPos);
            UccAutoPutOnShelfBusiRspBO uccAutoPutOnShelfBusiRspBO = this.uccAutoPutOnShelfBusiService.dealAutoPutOnShelf(uccAutoPutOnShelfBusiReqBO);
            Map<Long, List<UccSkuPo>> mapSku = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
            for (Long supplierShopId : mapSku.keySet()) {
                List skus = mapSku.get(supplierShopId).stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skus));
                syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                }
            }
            DycDemandCheckMqCombReqBO basecombReqBO = new DycDemandCheckMqCombReqBO();
            basecombReqBO.setSkus(uccSkuPos.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList()));
            this.dycDemandCheckMqProvide.send(new ProxyMessage(this.demandCheckTopic, "*", JSON.toJSONString((Object)basecombReqBO)));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

