/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SelfRunSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccBatchSkuRelmaterialAbilityService;
import com.tydic.commodity.common.ability.bo.UccBatchSkuRelmaterialAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccBatchSkuRelmaterialAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccBatchSkuRelmaterialBusiService;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccBatchSkuRelmaterialAbilityService"})
public class UccBatchSkuRelmaterialAbilityServiceImpl
implements UccBatchSkuRelmaterialAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccBatchSkuRelmaterialAbilityServiceImpl.class);
    @Autowired
    private UccBatchSkuRelmaterialBusiService uccBatchSkuRelmaterialBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"dealSkuRelMaterial"})
    public UccBatchSkuRelmaterialAbilityRspBO dealSkuRelMaterial(@RequestBody UccBatchSkuRelmaterialAbilityReqBO reqBO) {
        UccBatchSkuRelmaterialAbilityRspBO rspBO = new UccBatchSkuRelmaterialAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getBatchSkuList())) {
            throw new BusinessException("8888", "\u5165\u53c2batchSkuList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UccBatchSkuBO each : reqBO.getBatchSkuList()) {
            if (each.getSkuId() == null) {
                throw new BusinessException("8888", "\u5165\u53c2skuId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (each.getSupplierShopId() == null) {
                throw new BusinessException("8888", "\u5165\u53c2supplierShopId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (each.getMaterialId() != null) continue;
            throw new BusinessException("8888", "\u5165\u53c2materialId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        rspBO = this.uccBatchSkuRelmaterialBusiService.dealSkuRelMaterial(reqBO);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getBatchSkuList())) {
            Map<Long, List<UccBatchSkuBO>> skuMap = reqBO.getBatchSkuList().stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
            for (Long supplierShopId : skuMap.keySet()) {
                List skus = skuMap.get(supplierShopId).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
                SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skus));
                syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                try {
                    log.info("es\u540c\u6b65\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                }
            }
        }
        return rspBO;
    }
}

