/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.constant.FileUpLoad;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccPicZipUploadAnalyzeAbilityService;
import com.tydic.commodity.common.ability.bo.UccPicZipUploadAnalyzeAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccPicZipUploadAnalyzeAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccPicZipUploadAnalyzeBO;
import com.tydic.commodity.utils.FileUtil;
import com.tydic.commodity.utils.ZipUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccPicZipUploadAnalyzeAbilityService"})
public class UccPicZipUploadAnalyzeAbilityServiceImpl
implements UccPicZipUploadAnalyzeAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccPicZipUploadAnalyzeAbilityServiceImpl.class);
    @Autowired
    private FileUpLoad fileUpLoad;

    @PostMapping(value={"getPicUrl"})
    public UccPicZipUploadAnalyzeAbilityRspBO getPicUrl(@RequestBody UccPicZipUploadAnalyzeAbilityReqBO reqBO) {
        UccPicZipUploadAnalyzeAbilityRspBO rspBO = new UccPicZipUploadAnalyzeAbilityRspBO();
        if (reqBO.getFile() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isEmpty((Object)reqBO.getUploadFolder())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5b58\u653e\u6240\u5c5e\u76ee\u5f55\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        FileUtil.createFolder((String)reqBO.getUploadFolder());
        String filename = null;
        try {
            filename = ZipUtil.unZipFiles((File)reqBO.getFile(), (String)reqBO.getUploadFolder());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u89e3\u538b\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
        }
        filename = filename.split("/")[0];
        File templateDir = new File(reqBO.getUploadFolder() + File.separator + filename);
        ArrayList<UccPicZipUploadAnalyzeBO> upPicUrlList = new ArrayList<UccPicZipUploadAnalyzeBO>();
        this.getPicZipFile(templateDir, upPicUrlList);
        log.info("\u89e3\u6790\u540e\u7684\u6570\u636e\uff1a{}", upPicUrlList);
        FileUtil.delFolders((String)reqBO.getUploadFolder());
        rspBO.setRows(upPicUrlList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void getPicZipFile(File file, List<UccPicZipUploadAnalyzeBO> upPicUrlList) {
        block6: {
            String fileName;
            block5: {
                fileName = file.getName();
                File[] fil = file.listFiles();
                if (fil == null || fil.length <= 0) break block5;
                if (fileName.contains(".")) break block6;
                for (File fi : fil) {
                    this.getPicZipFile(fi, upPicUrlList);
                }
                break block6;
            }
            if (fileName.contains(".") && fileName.lastIndexOf(".") < fileName.length() - 1) {
                String fileSuffix = fileName.substring(fileName.lastIndexOf(46) + 1);
                if (!"jpg".equals(fileSuffix) && !"png".equals(fileSuffix)) {
                    throw new BusinessException("8888", "\u6587\u4ef6\u201c" + fileName + "\u201d\u4e0d\u4e3ajpg\u6216png\u7c7b\u578b");
                }
                UccPicZipUploadAnalyzeBO temp = new UccPicZipUploadAnalyzeBO();
                String name = fileName.substring(0, fileName.lastIndexOf(46));
                temp.setName(name);
                upPicUrlList.add(temp);
                try {
                    FileInputStream inputStream = new FileInputStream(file);
                    temp.setUrl(this.upLoad(inputStream, fileName));
                    ((InputStream)inputStream).close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BusinessException("8888", "\u4e0a\u4f20\u56fe\u7247\u5f02\u5e38");
                }
            }
        }
    }

    private String upLoad(InputStream inputStream, String fileName) throws IOException {
        int num;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((num = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, num);
        }
        outputStream.flush();
        byte[] b = outputStream.toByteArray();
        String url = this.fileUpLoad.upload(fileName, b, null);
        outputStream.close();
        return url;
    }
}

