/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.bo.UccExcelImportBO;
import com.tydic.commodity.base.constant.FileUpLoad;
import com.tydic.commodity.common.ability.api.UccSkuStockDetailsTemplateImportAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuItemsStockListBO;
import com.tydic.commodity.common.ability.bo.UccSkuStockDetailsTemplateImportAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuStockDetailsTemplateImportAbilityRspBO;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuStockDetailsTemplateImportAbilityService"})
public class UccSkuStockDetailsTemplateImportAbilityServiceImpl
implements UccSkuStockDetailsTemplateImportAbilityService {
    private static final Logger log = LogManager.getLogger(UccSkuStockDetailsTemplateImportAbilityServiceImpl.class);
    @Autowired
    private FileUpLoad fileUpLoad;
    private static final String DATE_FORMAT = "yyyy/MM/dd";

    @PostMapping(value={"importSkuDetailsTemplate"})
    public UccSkuStockDetailsTemplateImportAbilityRspBO importSkuDetailsTemplate(@RequestBody UccSkuStockDetailsTemplateImportAbilityReqBO reqBO) {
        UccSkuStockDetailsTemplateImportAbilityRspBO rspBO = this.validateParams(reqBO);
        if (rspBO != null && !rspBO.getRespCode().equals("0000")) {
            return rspBO;
        }
        rspBO = new UccSkuStockDetailsTemplateImportAbilityRspBO();
        ArrayList<UccExcelImportBO> skuStockTemplateList = new ArrayList<UccExcelImportBO>();
        UccExcelImportBO commoditySkuTemp = new UccExcelImportBO();
        commoditySkuTemp.setSheet("\u5546\u54c1\u660e\u7ec6(\u5355\u54c1)\u5e93\u5b58\u5bfc\u5165\u6a21\u677f");
        ArrayList<String> skuTitle = new ArrayList<String>();
        skuTitle.add("\u5e8f\u53f7");
        skuTitle.add("\u5355\u54c1\u540d\u79f0");
        skuTitle.add("\u5355\u54c1\u7f16\u7801");
        skuTitle.add("\u671f\u521d\u5e93\u5b58");
        skuTitle.add("\u8c03\u6574\u7c7b\u578b");
        skuTitle.add("\u8c03\u6574\u5e45\u5ea6");
        skuTitle.add("\u5df2\u552e\u5e93\u5b58");
        skuTitle.add("\u9000\u8d27\u548c\u53d6\u6d88\u6570\u91cf");
        skuTitle.add("\u5145\u8db3\u5e93\u5b58");
        commoditySkuTemp.setTitle(skuTitle);
        skuStockTemplateList.add(commoditySkuTemp);
        UccExcelImportBO adjustTypeTemp = new UccExcelImportBO();
        adjustTypeTemp.setSheet("\u8c03\u6574\u7c7b\u578b");
        ArrayList<String> adjustTypeTitle = new ArrayList<String>();
        adjustTypeTitle.add("\u589e\u52a0");
        adjustTypeTitle.add("\u51cf\u5c11");
        adjustTypeTemp.setTitle(adjustTypeTitle);
        skuStockTemplateList.add(adjustTypeTemp);
        String url = this.dealImportTempToXmls(skuStockTemplateList, reqBO.getRows());
        rspBO.setUrl(url);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private UccSkuStockDetailsTemplateImportAbilityRspBO validateParams(UccSkuStockDetailsTemplateImportAbilityReqBO reqBO) {
        UccSkuStockDetailsTemplateImportAbilityRspBO rspBO = new UccSkuStockDetailsTemplateImportAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getRows())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5165\u53c2\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        for (UccSkuItemsStockListBO uccSkuItemsStockListBO : reqBO.getRows()) {
            if (uccSkuItemsStockListBO.getSkuName() == null) {
                rspBO.setRespCode("0001");
                rspBO.setRespDesc("\u5bfc\u51fa\u5355\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (uccSkuItemsStockListBO.getSkuCode() == null) {
                rspBO.setRespCode("0001");
                rspBO.setRespDesc("\u5bfc\u51fa\u5355\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (uccSkuItemsStockListBO.getStoreGetType() != null) continue;
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("storeGetType\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String dealImportTempToXmls(List<UccExcelImportBO> importBOs, List<UccSkuItemsStockListBO> data) {
        log.info("\u5bfc\u5165\u6570\u636e\uff1a" + JSONObject.toJSONString(importBOs));
        String fileUrl = "";
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFCellStyle headlineStyle = workbook.createCellStyle();
        XSSFFont headFontStyle = workbook.createFont();
        headlineStyle.setFont((Font)headFontStyle);
        XSSFCellStyle commonStyle = workbook.createCellStyle();
        XSSFFont commonFontStyle = workbook.createFont();
        XSSFCellStyle titleStyle = workbook.createCellStyle();
        XSSFFont titleFontStyle = workbook.createFont();
        block6: for (int i = 0; i < importBOs.size(); ++i) {
            XSSFSheet sheet = workbook.createSheet(importBOs.get(i).getSheet());
            switch (i) {
                case 0: {
                    XSSFRow skuDetailsRow = sheet.createRow(0);
                    skuDetailsRow.setHeightInPoints(135.0f);
                    XSSFCell cell = skuDetailsRow.createCell(0);
                    cell.setCellStyle((CellStyle)headlineStyle);
                    sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 7));
                    cell.setCellValue("\u6a21\u677f\u4f7f\u7528\u6ce8\u610f\u4e8b\u9879\uff1a\n1\uff09\u6570\u636e\u5f55\u5165\u6ce8\u610f\u4e8b\u9879\uff1b\n       \uff081\uff09\u7ea2\u8272\u5b57\u4f53\u8868\u5934\u4e3a\u5fc5\u586b\u9879\uff1b\n       \uff082\uff09\u6700\u591a\u652f\u63011000\u6761\u5355\u54c1\u5e93\u5b58\u4fe1\u606f\u5bfc\u5165\uff1b\n       \uff083\uff09\u5355\u54c1\u540d\u79f0\u3001\u5355\u54c1\u7f16\u7801\u3001\u539f\u59cb\u5e93\u5b58\u3001\u5df2\u552e\u5e93\u5b58\u3001\u9000\u8d27\u548c\u53d6\u6d88\u5e93\u5b58\u81ea\u52a8\u5e26\u51fa\uff0c\u4e0d\u53ef\u4fee\u6539\uff1b\n       \uff084\uff09\u8c03\u6574\u7c7b\u578b\u8f93\u5165\u201d\u589e\u52a0\u5e93\u5b58\u201c\u6216\u201d\u51cf\u5c11\u5e93\u5b58\u201c\uff1b\u5373\u4ec5\u80fd\u9009\u62e9\u8c03\u6574\u7c7b\u578bsheet\u679a\u4e3e\u8f93\u5165\uff1b\n       \uff085\uff09\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9\uff0c\u4ee5\u9632\u65e0\u6cd5\u6b63\u786e\u5bfc\u5165\uff1b\n2)\u6a21\u677f\u8868\u5934\u4f1a\u56fa\u5b9a\u5728\u7b2c2\u884c\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9,\u4ee5\u9632\u65e0\u6cd5\u6b63\u786e\u5bfc\u5165\u3002");
                    skuDetailsRow = sheet.createRow(1);
                    for (int j = 0; j < importBOs.get(i).getTitle().size(); ++j) {
                        titleStyle = workbook.createCellStyle();
                        titleFontStyle.setFontName("\u9ed1\u4f53");
                        titleFontStyle.setFontHeightInPoints((short)12);
                        titleFontStyle.setBold(true);
                        titleStyle.setFont((Font)titleFontStyle);
                        titleStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
                        titleStyle.setAlignment(HorizontalAlignment.CENTER);
                        titleStyle.setWrapText(true);
                        titleStyle.setLocked(true);
                        titleStyle.setBorderTop(BorderStyle.THIN);
                        titleStyle.setBorderBottom(BorderStyle.THIN);
                        titleStyle.setBorderLeft(BorderStyle.THIN);
                        titleStyle.setBorderRight(BorderStyle.THIN);
                        titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                        titleStyle.setFillForegroundColor(new XSSFColor(new Color(-16057, true)));
                        if (j == 4 || j == 5) {
                            titleStyle.setFillForegroundColor(new XSSFColor(new Color(1959184070, true)));
                            XSSFFont inStyle = workbook.createFont();
                            inStyle.setColor(new XSSFColor(new Color(-2686976, true)));
                            inStyle.setFontName("\u9ed1\u4f53");
                            inStyle.setFontHeightInPoints((short)12);
                            inStyle.setBold(true);
                            titleStyle.setFont((Font)inStyle);
                        }
                        cell = skuDetailsRow.createCell(j);
                        cell.setCellStyle((CellStyle)titleStyle);
                        cell.setCellValue((String)importBOs.get(i).getTitle().get(j));
                    }
                    int rowIndex = 0;
                    int lastCellIndex = 0;
                    for (UccSkuItemsStockListBO uccSkuItemsStockListBO2 : data) {
                        commonStyle = workbook.createCellStyle();
                        commonFontStyle = workbook.createFont();
                        commonFontStyle.setFontName("\u5b8b\u4f53");
                        commonStyle.setFont((Font)commonFontStyle);
                        commonStyle.setLocked(true);
                        commonStyle.setBorderTop(BorderStyle.THIN);
                        commonStyle.setBorderBottom(BorderStyle.THIN);
                        commonStyle.setBorderLeft(BorderStyle.THIN);
                        commonStyle.setBorderRight(BorderStyle.THIN);
                        commonStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
                        commonStyle.setAlignment(HorizontalAlignment.CENTER);
                        commonStyle.setFillBackgroundColor(IndexedColors.WHITE.getIndex());
                        int cellIndex = 0;
                        skuDetailsRow = sheet.createRow(2 + rowIndex++);
                        cell = skuDetailsRow.createCell(cellIndex++);
                        cell.setCellStyle((CellStyle)commonStyle);
                        cell.setCellValue(uccSkuItemsStockListBO2.getSerialNumber().toString());
                        cell = skuDetailsRow.createCell(cellIndex++);
                        cell.setCellStyle((CellStyle)commonStyle);
                        cell.setCellValue(uccSkuItemsStockListBO2.getSkuName());
                        cell = skuDetailsRow.createCell(cellIndex++);
                        cell.setCellStyle((CellStyle)commonStyle);
                        cell.setCellValue(uccSkuItemsStockListBO2.getSkuCode());
                        cell = skuDetailsRow.createCell(cellIndex++);
                        cell.setCellStyle((CellStyle)commonStyle);
                        if (uccSkuItemsStockListBO2.getStoreGetType() == 1) {
                            cell.setCellValue(uccSkuItemsStockListBO2.getOrgStock() == null ? String.valueOf(0) : uccSkuItemsStockListBO2.getOrgStock().toString());
                        } else {
                            cell.setCellValue("");
                        }
                        cell = skuDetailsRow.createCell(cellIndex++);
                        cell.setCellStyle((CellStyle)commonStyle);
                        cell.setCellValue(uccSkuItemsStockListBO2.getAdjustType());
                        cell = skuDetailsRow.createCell(cellIndex++);
                        cell.setCellStyle((CellStyle)commonStyle);
                        cell.setCellValue(uccSkuItemsStockListBO2.getAdjustRange());
                        cell = skuDetailsRow.createCell(cellIndex++);
                        cell.setCellStyle((CellStyle)commonStyle);
                        cell.setCellValue(uccSkuItemsStockListBO2.getSaleStock() == null ? String.valueOf(0) : uccSkuItemsStockListBO2.getSaleStock().toString());
                        cell = skuDetailsRow.createCell(cellIndex++);
                        cell.setCellStyle((CellStyle)commonStyle);
                        cell.setCellValue(uccSkuItemsStockListBO2.getCancelStock() == null ? String.valueOf(0) : uccSkuItemsStockListBO2.getCancelStock().toString());
                        cell = skuDetailsRow.createCell(cellIndex++);
                        cell.setCellStyle((CellStyle)commonStyle);
                        cell.setCellValue(uccSkuItemsStockListBO2.getStoreGetType() == 3 ? "\u662f" : "\u5426");
                        lastCellIndex = cellIndex;
                    }
                    for (int begin = 0; begin < lastCellIndex; ++begin) {
                        sheet.setColumnWidth(begin, (int)((double)skuDetailsRow.getCell(begin).getStringCellValue().getBytes().length * 1.2 * 256.0 > 3072.0 ? (double)skuDetailsRow.getCell(begin).getStringCellValue().getBytes().length * 1.2 * 256.0 : 3072.0));
                    }
                    continue block6;
                }
                case 1: {
                    int n;
                    XSSFCell cell;
                    XSSFRow adjustTypeRow = sheet.createRow(0);
                    adjustTypeRow.setHeightInPoints(13.5f);
                    boolean bl = false;
                    while (n < importBOs.get(i).getTitle().size()) {
                        titleStyle = workbook.createCellStyle();
                        titleFontStyle = workbook.createFont();
                        titleFontStyle.setBold(true);
                        titleFontStyle.setFontHeightInPoints((short)13);
                        titleFontStyle.setFontName("\u9ed1\u4f53");
                        titleStyle.setFont((Font)titleFontStyle);
                        titleStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
                        titleStyle.setAlignment(HorizontalAlignment.CENTER);
                        titleStyle.setWrapText(true);
                        titleStyle.setBorderTop(BorderStyle.THIN);
                        titleStyle.setBorderBottom(BorderStyle.THIN);
                        titleStyle.setBorderLeft(BorderStyle.THIN);
                        titleStyle.setBorderRight(BorderStyle.THIN);
                        titleStyle.setLocked(false);
                        titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                        titleStyle.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.getIndex());
                        cell = adjustTypeRow.createCell(n);
                        cell.setCellStyle((CellStyle)titleStyle);
                        cell.setCellValue((String)importBOs.get(i).getTitle().get(n));
                        ++n;
                    }
                    n = 0;
                    for (UccSkuItemsStockListBO uccSkuItemsStockListBO3 : data) {
                        void var18_26;
                        commonStyle = workbook.createCellStyle();
                        commonFontStyle = workbook.createFont();
                        commonFontStyle.setFontName("\u5b8b\u4f53");
                        commonStyle.setFont((Font)commonFontStyle);
                        commonStyle.setLocked(true);
                        commonStyle.setBorderTop(BorderStyle.THIN);
                        commonStyle.setBorderBottom(BorderStyle.THIN);
                        commonStyle.setBorderLeft(BorderStyle.THIN);
                        commonStyle.setBorderRight(BorderStyle.THIN);
                        commonStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
                        commonStyle.setAlignment(HorizontalAlignment.CENTER);
                        commonStyle.setFillBackgroundColor(IndexedColors.WHITE.getIndex());
                        adjustTypeRow = sheet.createRow(1 + ++var18_26);
                        cell = adjustTypeRow.createCell(0);
                        cell.setCellStyle((CellStyle)commonStyle);
                        cell.setCellValue(uccSkuItemsStockListBO3.getAdjustType());
                        cell = adjustTypeRow.createCell(1);
                        cell.setCellStyle((CellStyle)commonStyle);
                        cell.setCellValue(uccSkuItemsStockListBO3.getAdjustRange());
                    }
                    for (int begin = 0; begin < 2; ++begin) {
                        sheet.setColumnWidth(begin, (int)((double)adjustTypeRow.getCell(begin).getStringCellValue().getBytes().length * 1.2 * 256.0 > 3072.0 ? (double)adjustTypeRow.getCell(begin).getStringCellValue().getBytes().length * 1.2 * 256.0 : 3072.0));
                    }
                    continue block6;
                }
            }
        }
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)outputStream);
            byte[] bytes = outputStream.toByteArray();
            data = data.stream().filter(uccSkuItemsStockListBO -> Objects.equals(uccSkuItemsStockListBO.getMenuCode(), "agrStockList")).collect(Collectors.toList());
            String fileNamePre = "\u5546\u54c1-\u5e93\u5b58\u7ba1\u7406-\u5546\u54c1\u5e93\u5b58\u901a\u7528\u5bfc\u51fa";
            if (data != null && data.size() > 0) {
                fileNamePre = fileNamePre.replace("\u65e0", "");
            }
            fileUrl = this.fileUpLoad.upload(fileNamePre + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()).trim().replace("-", "").replace(":", "").replace(" ", ""), bytes, ".xlsx");
            workbook.close();
            outputStream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error("\u5bfc\u51faExcel\u51fa\u73b0\u4e25\u91cd\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + ex.getMessage());
        }
        return fileUrl;
    }
}

