/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.common.ability.api.UccSyncNormSkuFromAbilityService;
import com.tydic.commodity.common.ability.bo.UccSyncNormSkuFromAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSyncNormSkuFromAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccSyncNormSkuFromBusiService;
import com.tydic.commodity.common.comb.bo.UccNormSkuSyncCombReqBO;
import com.tydic.commodity.dao.UccSyncNormRecordMapper;
import com.tydic.commodity.po.UccSyncNormRecordPO;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSyncNormSkuFromAbilityService"})
public class UccSyncNormSkuFromAbilityServiceImpl
implements UccSyncNormSkuFromAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSyncNormSkuFromAbilityServiceImpl.class);
    @Autowired
    private UccSyncNormRecordMapper uccSyncNormRecordMapper;
    @Autowired
    private UccSyncNormSkuFromBusiService uccSyncNormSkuFromBusiService;
    @Value(value="${NORM_SKU_SYNC_TOPIC:NORM_SKU_SYNC_TOPIC}")
    private String normSkuSyncTopic;
    @Resource(name="uccNormSkuSyncMqProvider")
    private ProxyMessageProducer uccNormSkuSyncMqProvider;

    @PostMapping(value={"syncNormSku"})
    public UccSyncNormSkuFromAbilityRspBO syncNormSku(@RequestBody UccSyncNormSkuFromAbilityReqBO reqBO) {
        Calendar cal;
        UccSyncNormSkuFromAbilityRspBO rspBO = new UccSyncNormSkuFromAbilityRspBO();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (reqBO == null) {
            rspBO.setRespCode("0000");
            return rspBO;
        }
        if (reqBO.getType() == 1) {
            if (StringUtils.isEmpty((String)reqBO.getSync_date())) {
                cal = Calendar.getInstance();
                cal.add(5, -1);
                reqBO.setSync_date(simpleDateFormat.format(cal.getTime()));
            }
        } else if (reqBO.getType() == 2) {
            if (StringUtils.isEmpty((String)reqBO.getUpdate_time())) {
                cal = Calendar.getInstance();
                cal.add(5, -1);
                reqBO.setUpdate_time(simpleDateFormat.format(cal.getTime()));
                reqBO.setSync_date(simpleDateFormat.format(cal.getTime()));
            }
        } else {
            if (reqBO.getType() == 0) {
                UccSyncNormRecordPO normRecordPO = new UccSyncNormRecordPO();
                normRecordPO.setRecordStatus(Integer.valueOf(0));
                List normRecordPOS = this.uccSyncNormRecordMapper.getList(normRecordPO);
                if (!CollectionUtils.isEmpty((Collection)normRecordPOS)) {
                    this.sendMq(normRecordPOS);
                }
                rspBO.setRespCode("0000");
                return rspBO;
            }
            rspBO.setRespCode("0000");
            return rspBO;
        }
        if ("0000".equals((rspBO = this.uccSyncNormSkuFromBusiService.syncNormSku(reqBO)).getRespCode()) && rspBO.getParentId() != null) {
            UccSyncNormRecordPO normRecordPO = new UccSyncNormRecordPO();
            normRecordPO.setParentId(rspBO.getParentId());
            List normRecordPOS = this.uccSyncNormRecordMapper.getList(normRecordPO);
            if (!CollectionUtils.isEmpty((Collection)normRecordPOS)) {
                this.sendMq(normRecordPOS);
            }
        }
        return rspBO;
    }

    private void sendMq(List<UccSyncNormRecordPO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (UccSyncNormRecordPO each : list) {
            UccNormSkuSyncCombReqBO combReqBO = new UccNormSkuSyncCombReqBO();
            combReqBO.setRecordId(each.getRecordId());
            try {
                this.uccNormSkuSyncMqProvider.send(new ProxyMessage(this.normSkuSyncTopic, "*", JSON.toJSONString((Object)combReqBO)));
            }
            catch (Exception e) {
                log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
            }
        }
    }
}

