/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.common.atom.api.UccQryNormSkuFromInterService;
import com.tydic.commodity.common.atom.bo.UccQryNormSkuAtomBO;
import com.tydic.commodity.common.atom.bo.UccQryNormSkuReqBO;
import com.tydic.commodity.common.atom.bo.UccQryNormSkuRspBO;
import com.tydic.commodity.utils.ESBParamUtil;
import com.tydic.commodity.utils.HSHttpHelper;
import com.tydic.commodity.utils.HttpRetBean;
import com.tydic.commodity.utils.PropertiesUtil;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UccQryNormSkuFromInterServiceImpl
implements UccQryNormSkuFromInterService {
    private static final Logger log = LoggerFactory.getLogger(UccQryNormSkuFromInterServiceImpl.class);
    @Value(value="${sync_norm_sku}")
    private String sync_norm_sku;

    @Override
    public UccQryNormSkuRspBO qryMsg(UccQryNormSkuReqBO reqBo) {
        UccQryNormSkuRspBO rspBo = new UccQryNormSkuRspBO();
        try {
            String reqStr = this.initReqStr(reqBo);
            String reqEsbStr = ESBParamUtil.getEsbReqStr((String)reqStr, null, (String)"BUSINESS_COMMODITY");
            BasicHeader[] header = new BasicHeader[]{new BasicHeader("Content-Type", "application/json;charset=UTF-8"), new BasicHeader("appCode", "report")};
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.sync_norm_sku), (Header[])header, (byte[])reqEsbStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                log.error("\u540c\u6b65\u6807\u51c6\u5546\u54c1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty((String)"ESP_APPLY_ADD_GOODS_URL") + "]");
                throw new RuntimeException("\u540c\u6b65\u6807\u51c6\u5546\u54c1\u4e1a\u52a1\u5931\u8d25");
            }
            log.info("\u540c\u6b65\u6807\u51c6\u5546\u54c1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u540c\u6b65\u6807\u51c6\u5546\u54c1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            UccQryNormSkuRspBO resolveRsp = this.resolveRsp(returnString);
            return resolveRsp;
        }
        catch (Exception var9) {
            log.error("\u540c\u6b65\u6807\u51c6\u5546\u54c1\u4e1a\u52a1\u8c03\u7528\u5931\u8d25" + var9);
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u540c\u6b65\u6807\u51c6\u5546\u54c1\u4e1a\u52a1\u4e1a\u52a1\u5931\u8d25");
            return rspBo;
        }
    }

    private String initReqStr(UccQryNormSkuReqBO reqBo) {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBo)));
        return JSON.toJSONString((Object)jsonObject);
    }

    private UccQryNormSkuRspBO resolveRsp(String returnString) {
        UccQryNormSkuRspBO rspBo = new UccQryNormSkuRspBO();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            if ("0".equals(rspJsonObject.get((Object)"code"))) {
                rspBo.setRespCode("0000");
                JSONObject data = rspJsonObject.getJSONObject("data");
                if (data != null) {
                    Integer pageNo = data.getInteger("pageNo");
                    Integer recordsTotal = data.getInteger("recordsTotal");
                    Integer total = data.getInteger("total");
                    JSONArray array = data.getJSONArray("rows");
                    rspBo.setPageNo(pageNo);
                    rspBo.setRecordsTotal(recordsTotal);
                    rspBo.setTotal(total);
                    if (array != null && array.size() > 0) {
                        List rspRows = JSONObject.parseArray((String)JSON.toJSONString((Object)array), UccQryNormSkuAtomBO.class);
                        rspBo.setRows(rspRows);
                    }
                } else {
                    rspBo.setRespCode("8888");
                    rspBo.setRespDesc("\u8fd4\u56dedata \u5185\u5bb9\u4e3a\u7a7a\uff01");
                }
            } else {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc(rspJsonObject.getString("message"));
            }
            return rspBo;
        }
        catch (Exception var10) {
            log.error("\u540c\u6b65\u6807\u51c6\u5546\u54c1\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
            throw new RuntimeException("\u540c\u6b65\u6807\u51c6\u5546\u54c1\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

