/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.common.ability.bo.RelPropDefIdBo;
import com.tydic.commodity.common.ability.bo.UccAddRelPropReqBO;
import com.tydic.commodity.common.ability.bo.UccAddRelPropRspBO;
import com.tydic.commodity.common.busi.api.UccAddRelPropertyBusiService;
import com.tydic.commodity.dao.UccCommodityPropDefMapper;
import com.tydic.commodity.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.dao.UccRelPropGrpPropMapper;
import com.tydic.commodity.po.UccCommdPropDefPo;
import com.tydic.commodity.po.UccCommodityPropGrpPo;
import com.tydic.commodity.po.UccRelPropGrpPropPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccAddRelPropertyBusiServiceImpl
implements UccAddRelPropertyBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccAddRelPropertyBusiServiceImpl.class);
    @Autowired
    private UccCommodityPropDefMapper uccCommodityPropDefMapper;
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;
    @Autowired
    private UccRelPropGrpPropMapper uccRelPropGrpPropMapper;
    private Sequence uccAttributesSequence = Sequence.getInstance();
    private boolean isExp;

    @Override
    public UccAddRelPropRspBO addRelProp(UccAddRelPropReqBO reqBO) {
        List<Object> relId;
        UccAddRelPropRspBO rspBO = new UccAddRelPropRspBO();
        ArrayList<Long> verifyPropId = new ArrayList<Long>();
        String errMsg = this.verify(reqBO, verifyPropId);
        if (!"".equals(errMsg)) {
            if (!this.isExp) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(errMsg);
            } else {
                rspBO.setRespCode("0000");
                rspBO.setFrameInfo(errMsg);
                rspBO.setRelId(verifyPropId);
            }
            return rspBO;
        }
        List relPropGrpPropPoList = this.uccRelPropGrpPropMapper.queryRalatedByDefIdAndGrpIdAll(null, reqBO.getCommodityPropGrpId());
        if (!CollectionUtils.isEmpty((Collection)relPropGrpPropPoList)) {
            List defIds = relPropGrpPropPoList.stream().map(UccRelPropGrpPropPo::getCommodityPropDefId).collect(Collectors.toList());
            ArrayList<Long> inRel = new ArrayList<Long>();
            relId = new ArrayList();
            ArrayList<RelPropDefIdBo> needInsert = new ArrayList<RelPropDefIdBo>();
            for (RelPropDefIdBo each : reqBO.getCommodityPropDefIds()) {
                if (defIds.contains(each.getCommodityPropDefId())) {
                    inRel.add(each.getCommodityPropDefId());
                    continue;
                }
                needInsert.add(each);
            }
            if (!CollectionUtils.isEmpty(inRel)) {
                relId = relPropGrpPropPoList.stream().filter(a -> inRel.contains(a.getRelId())).map(UccRelPropGrpPropPo::getRelId).collect(Collectors.toList());
                try {
                    this.uccRelPropGrpPropMapper.updateOper(relId, reqBO.getUsername());
                }
                catch (Exception e) {
                    throw new ZTBusinessException("\u65b0\u589e\u5c5e\u6027\u7ec4\u5173\u8054\u5931\u8d25\uff01");
                }
            }
            if (CollectionUtils.isEmpty(needInsert)) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u5c5e\u6027\u5173\u8054\u6210\u529f");
                rspBO.setRelId(inRel);
                return rspBO;
            }
            reqBO.setCommodityPropDefIds(needInsert);
        }
        int count = this.uccRelPropGrpPropMapper.queryMaxShowOrder(reqBO.getCommodityPropGrpId());
        UccRelPropGrpPropPo po = null;
        relId = new ArrayList();
        for (RelPropDefIdBo each : reqBO.getCommodityPropDefIds()) {
            po = new UccRelPropGrpPropPo();
            BeanUtils.copyProperties((Object)reqBO, (Object)po);
            po.setCommodityPropDefId(each.getCommodityPropDefId());
            po.setShowOrder(Integer.valueOf(++count));
            po.setCreateOperId(reqBO.getUsername());
            try {
                po.setRelId(Long.valueOf(this.uccAttributesSequence.nextId()));
                this.uccRelPropGrpPropMapper.addRelPropGrpProp(po);
            }
            catch (Exception e) {
                LOGGER.error("\u65b0\u589e\u5c5e\u6027\u7ec4\u5173\u8054\u5931\u8d25\uff1a" + e.getMessage());
                throw new ZTBusinessException("\u65b0\u589e\u5c5e\u6027\u7ec4\u5173\u8054\u5931\u8d25\uff01");
            }
            relId.add(po.getRelId());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5c5e\u6027\u5173\u8054\u6210\u529f");
        rspBO.setRelId(relId);
        return rspBO;
    }

    private String verify(UccAddRelPropReqBO reqBO, List<Long> verifyPropId) {
        String errMsg = "";
        if (reqBO.getCommodityPropDefIds() == null || reqBO.getCommodityPropDefIds().size() == 0) {
            errMsg = "\u5c5e\u6027ID \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBO.getCommodityPropGrpId() == null || reqBO.getCommodityPropGrpId() == 0L) {
            errMsg = "\u5c5e\u6027\u7ec4 \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if ("".equals(errMsg)) {
            errMsg = this.dataBaseVerify(reqBO, verifyPropId);
        }
        return errMsg;
    }

    private String dataBaseVerify(UccAddRelPropReqBO reqBO, List<Long> verifyPropId) {
        String errMsg = "";
        UccCommodityPropGrpPo uccCommodityPropGrpPo = this.uccCommodityPropGrpMapper.queryGroupByGrpId(reqBO.getCommodityPropGrpId());
        if (uccCommodityPropGrpPo == null) {
            return "\u5c5e\u6027\u7ec4ID\uff1a " + reqBO.getCommodityPropGrpId() + "\u4e0d\u5b58\u5728";
        }
        UccCommdPropDefPo uccCommdPropDefPo = null;
        for (RelPropDefIdBo each : reqBO.getCommodityPropDefIds()) {
            uccCommdPropDefPo = new UccCommdPropDefPo();
            uccCommdPropDefPo.setCommodityPropDefId(each.getCommodityPropDefId());
            if ((uccCommdPropDefPo = this.uccCommodityPropDefMapper.queryBycommodityPropDefId(uccCommdPropDefPo)) != null) continue;
            return "\u5c5e\u6027ID\uff1a " + each + "\u4e0d\u5b58\u5728";
        }
        StringBuilder sb = new StringBuilder("");
        UccRelPropGrpPropPo uccRelPropGrpPropPo = null;
        ArrayList<Long> commodityPropDefIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCommodityPropDefIds())) {
            for (int i = 0; i < reqBO.getCommodityPropDefIds().size(); ++i) {
                RelPropDefIdBo each = (RelPropDefIdBo)reqBO.getCommodityPropDefIds().get(i);
                uccRelPropGrpPropPo = this.uccRelPropGrpPropMapper.queryRalatedByDefIdAndGrpId(each.getCommodityPropDefId(), reqBO.getCommodityPropGrpId());
                if (uccRelPropGrpPropPo != null) {
                    if (i == 0) {
                        sb.append("\u60a8\u9009\u62e9\u7684\u5c5e\u6027\u7ec4\"" + reqBO.getCommodityPropGrpName() + "\"\u4e2d\u7684\u5c5e\u6027\"");
                    }
                    sb.append(uccRelPropGrpPropPo.getCommodityPropDefName() + "\u3001");
                    continue;
                }
                commodityPropDefIds.add(each.getCommodityPropDefId());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
            String str = sb.toString().substring(0, sb.toString().lastIndexOf("\u3001")) + "\"";
            sb = new StringBuilder(str);
        }
        if (CollectionUtils.isEmpty(commodityPropDefIds)) {
            sb.append("\u5168\u90fd\u5728\u539f\u5c5e\u6027\u7ec4\u4e2d\u5173\u8054\uff0c\u672c\u6b21\u64cd\u4f5c\u5c06\u4e0d\u5173\u8054\u4efb\u4f55\u5c5e\u6027");
        } else if (!CollectionUtils.isEmpty(commodityPropDefIds) && commodityPropDefIds.size() != reqBO.getCommodityPropDefIds().size()) {
            sb.append("\u5df2\u7ecf\u5728\u539f\u5c5e\u6027\u7ec4\u4e2d\u5173\u8054\uff0c\u672c\u6b21\u64cd\u4f5c\u5c06\u53ea\u5173\u8054");
            String str = "";
            List uccCommdPropDefPos = this.uccCommodityPropDefMapper.querRecordByCommdPropDefIds(commodityPropDefIds);
            if (!CollectionUtils.isEmpty((Collection)uccCommdPropDefPos)) {
                List propNames = uccCommdPropDefPos.stream().map(UccCommdPropDefPo::getPropName).collect(Collectors.toList());
                str = StringUtils.join((Object[])new List[]{propNames}).replace("[", "").replace("]", "").replace(",", "\u3001");
                verifyPropId.addAll(commodityPropDefIds);
                this.isExp = true;
            }
            sb.append("\"" + str + "\"\u5c5e\u6027\uff0c\u662f\u5426\u7ee7\u7eed?");
        }
        return sb.toString();
    }
}

