/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.bo.UccBatchSpuBO;
import com.tydic.commodity.common.ability.bo.UccBatchSaveGoodImagesBO;
import com.tydic.commodity.common.ability.bo.UccBatchSaveGoodImagesFailReason;
import com.tydic.commodity.common.ability.bo.UccBatchSaveGoodImagesReqBO;
import com.tydic.commodity.common.ability.bo.UccBatchSaveGoodImagesRspBO;
import com.tydic.commodity.common.busi.api.UccBatchSaveSpuImagesBusiService;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.po.UccCommodityPicPo;
import com.tydic.commodity.po.UccCommodityPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class UccBatchSaveSpuImagesBusiServiceImpl
implements UccBatchSaveSpuImagesBusiService {
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    private static final String IMAGE_NAME_REGEX = "^[\\d]*_[12345]{1}.((jpg)|(png))$";

    @Override
    public UccBatchSaveGoodImagesRspBO dealBatchSaveGoodImages(UccBatchSaveGoodImagesReqBO reqBO) {
        this.validate(reqBO);
        UccBatchSaveGoodImagesRspBO rspBO = new UccBatchSaveGoodImagesRspBO();
        ArrayList<UccBatchSaveGoodImagesFailReason> failReasonList = new ArrayList<UccBatchSaveGoodImagesFailReason>();
        UccBatchSaveGoodImagesFailReason failReason = new UccBatchSaveGoodImagesFailReason();
        AtomicBoolean flag = new AtomicBoolean(false);
        HashMap<Long, Map> spuImagesMap = new HashMap<Long, Map>();
        HashMap spuCommodityPicTypeMap = new HashMap();
        HashMap<String, Map<Integer, String>> spuImageAddressMap = new HashMap<String, Map<Integer, String>>();
        List<UccBatchSaveGoodImagesBO> collect = reqBO.getSkuImagesList().stream().sorted(Comparator.comparing(UccBatchSaveGoodImagesBO::getSkuImageName)).collect(Collectors.toList());
        this.valSpuImagesInfo(collect, flag, failReason, failReasonList, spuImageAddressMap);
        if (flag.get()) {
            rspBO.setFailReasonList(failReasonList.stream().distinct().collect(Collectors.toList()));
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        List spuCodeList = reqBO.getSkuImagesList().stream().map(e -> {
            String spuImageName = e.getSkuImageName();
            return spuImageName.substring(0, spuImageName.indexOf("_"));
        }).distinct().collect(Collectors.toList());
        List uccCommodityPoList = this.uccCommodityMapper.queryByCommodityCodeLists(spuCodeList);
        Map<Long, String> spuIdCodeMap = uccCommodityPoList.stream().collect(Collectors.toMap(UccCommodityPo::getCommodityId, UccCommodityPo::getCommodityCode, (k1, k2) -> k2));
        List spuIdList = uccCommodityPoList.stream().map(UccCommodityPo::getCommodityId).collect(Collectors.toList());
        List uccSpuPicPoList = this.uccCommodityPicMapper.queryBatchByCommdId(spuIdList, null);
        Map<Long, List<UccCommodityPicPo>> uccSpuPicListPoMap = uccSpuPicPoList.stream().collect(Collectors.groupingBy(UccCommodityPicPo::getCommodityId));
        Map<Long, Integer> commodityIdVsApprovalStatusMap = uccCommodityPoList.stream().filter(o -> null != o.getApprovalStatus()).collect(Collectors.toMap(UccCommodityPo::getCommodityId, UccCommodityPo::getApprovalStatus, (k1, k2) -> k2));
        uccSpuPicListPoMap.forEach((spuId, uccSpuPicPos) -> {
            for (int i = 0; i < uccSpuPicPos.size(); ++i) {
                UccCommodityPicPo picPo = (UccCommodityPicPo)uccSpuPicPos.get(i);
                String spuCode = (String)spuIdCodeMap.get(picPo.getCommodityId());
                Integer imageNameSuffix = i + 1;
                Map stringMap = (Map)spuImageAddressMap.get(spuCode);
                if (!ObjectUtil.isNotEmpty((Object)stringMap) || !stringMap.containsKey(imageNameSuffix)) continue;
                String spuImageAddress = (String)stringMap.get(imageNameSuffix);
                if (!spuCommodityPicTypeMap.containsKey(spuId)) {
                    HashMap<Integer, ArrayList> map = new HashMap<Integer, ArrayList>();
                    map.put(imageNameSuffix, Lists.newArrayList((Object[])new String[]{spuImageAddress}));
                    spuCommodityPicTypeMap.put(spuId, map);
                } else {
                    Map commodityPicTypeMap = (Map)spuCommodityPicTypeMap.get(spuId);
                    if (commodityPicTypeMap.containsKey(imageNameSuffix)) {
                        ((List)commodityPicTypeMap.get(imageNameSuffix)).add(spuImageAddress);
                    } else {
                        commodityPicTypeMap.put(imageNameSuffix, Lists.newArrayList((Object[])new String[]{spuImageAddress}));
                    }
                }
                List spuPicPos = null;
                if (ObjectUtil.isNotEmpty((Object)commodityIdVsApprovalStatusMap) && (Integer)commodityIdVsApprovalStatusMap.get(spuId) == 31) {
                    flag.set(true);
                    failReason.setFailReason("\u5546\u54c1\u7f16\u7801\uff1a" + spuCode + "\u5546\u54c1\u6b63\u5728\u7f16\u8f91\u5ba1\u6838\u4e2d\uff0c\u4e0d\u80fd\u6279\u91cf\u7ef4\u62a4\u56fe\u7247");
                    failReasonList.add(failReason);
                    continue;
                }
                if (!spuImagesMap.containsKey(spuId)) {
                    if (ObjectUtil.isEmpty(uccSpuPicListPoMap.get(spuId)) && ObjectUtil.isEmpty(spuPicPos)) {
                        flag.set(true);
                        failReason.setFailReason("\u5546\u54c1ID\uff1a" + spuId + "\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5546\u54c1\u56fe\u7247\u6570\u636e");
                        failReasonList.add(failReason);
                        break;
                    }
                    spuPicPos = (List)uccSpuPicListPoMap.get(spuId);
                    HashMap<Integer, ArrayList> tmpMap = new HashMap<Integer, ArrayList>();
                    tmpMap.put(imageNameSuffix, Lists.newArrayList((Object[])new UccCommodityPicPo[]{(UccCommodityPicPo)spuPicPos.get(imageNameSuffix - 1)}));
                    spuImagesMap.put((Long)spuId, tmpMap);
                    continue;
                }
                Map imagesMap = (Map)spuImagesMap.get(spuId);
                if (imagesMap.containsKey(imageNameSuffix)) continue;
                if (ObjectUtil.isEmpty(uccSpuPicListPoMap.get(spuId)) && ObjectUtil.isEmpty((Object)spuPicPos)) {
                    flag.set(true);
                    failReason.setFailReason("\u5546\u54c1ID\uff1a" + spuId + "\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5546\u54c1\u56fe\u7247\u6570\u636e");
                    failReasonList.add(failReason);
                    break;
                }
                spuPicPos = (List)uccSpuPicListPoMap.get(spuId);
                imagesMap.put(imageNameSuffix, Lists.newArrayList((Object[])new UccCommodityPicPo[]{(UccCommodityPicPo)spuPicPos.get(imageNameSuffix - 1)}));
            }
        });
        spuImagesMap.forEach((skuId, tmpMap) -> {
            if (tmpMap.containsKey(1) && !ObjectUtils.isEmpty(tmpMap.get(1)) && ((List)tmpMap.get(1)).size() > 1) {
                flag.set(true);
                failReason.setFailReason("\u5546\u54c1\u56fe\u7247\u4e3b\u56fe\u4e0d\u552f\u4e00");
                failReasonList.add(failReason);
            }
        });
        if (flag.get()) {
            rspBO.setFailReasonList(failReasonList.stream().distinct().collect(Collectors.toList()));
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        ArrayList updateUccSpuPicPoList = new ArrayList();
        spuImagesMap.forEach((skuId, tmpMap) -> {
            if (spuCommodityPicTypeMap.containsKey(skuId)) {
                Map commodityPicTypeMap = (Map)spuCommodityPicTypeMap.get(skuId);
                tmpMap.forEach((commodityPicType, uccSpuPicList) -> {
                    if (commodityPicTypeMap.containsKey(commodityPicType) && !ObjectUtils.isEmpty((Object)uccSpuPicList)) {
                        UccCommodityPicPo spuPicPo = (UccCommodityPicPo)uccSpuPicList.get(0);
                        spuPicPo.setCommodityPicUrl((String)((List)commodityPicTypeMap.get(commodityPicType)).get(0));
                        updateUccSpuPicPoList.add(spuPicPo);
                    }
                });
            }
        });
        if (ObjectUtil.isNotEmpty(updateUccSpuPicPoList)) {
            for (UccCommodityPicPo picPo : updateUccSpuPicPoList) {
                this.uccCommodityPicMapper.updateCommodityPic(picPo);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)uccCommodityPoList)) {
            rspBO.setSpuList(JSON.parseArray((String)JSON.toJSONString((Object)uccCommodityPoList), UccBatchSpuBO.class));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setFailReasonList(failReasonList.stream().distinct().collect(Collectors.toList()));
        return rspBO;
    }

    private void valSpuImagesInfo(List<UccBatchSaveGoodImagesBO> spuImagesList, AtomicBoolean flag, UccBatchSaveGoodImagesFailReason failReason, List<UccBatchSaveGoodImagesFailReason> failReasonList, Map<String, Map<Integer, String>> spuImageAddressMap) {
        HashSet<String> imageNameSet = new HashSet<String>();
        HashMap<String, Integer> imageCountMap = new HashMap<String, Integer>();
        ArrayList<String> skuCodeList = new ArrayList<String>();
        HashMap<Integer, String> spuCodeImageAddressMap = new HashMap<Integer, String>();
        for (UccBatchSaveGoodImagesBO bo : spuImagesList) {
            String skuImageName = bo.getSkuImageName();
            Integer imageNameSuffix = Integer.valueOf(skuImageName.substring(skuImageName.indexOf("_") + 1, skuImageName.indexOf(".")));
            if (!Pattern.matches(IMAGE_NAME_REGEX, skuImageName)) {
                flag.set(true);
                failReason.setFailReason(skuImageName + "\uff1a\u56fe\u7247\u547d\u540d\u4e0d\u7b26\u5408\u8981\u6c42(\u201c\u5546\u54c1\u7f16\u7801_xxx.\u56fe\u7247\u540e\u7f00\u201d\uff08xxx\u4e3a\u5e8f\u53f7\uff0c\u4ece1\u5f00\u59cb\uff09");
                failReasonList.add(failReason);
                break;
            }
            if (imageNameSet.contains(skuImageName)) {
                flag.set(true);
                failReason.setFailReason(skuImageName + "\uff1a\u56fe\u7247\u540d\u79f0\u91cd\u590d,\u8bf7\u91cd\u65b0\u4e0a\u4f20");
                failReasonList.add(failReason);
            }
            imageNameSet.add(skuImageName);
            String spuCode = skuImageName.substring(0, skuImageName.indexOf("_"));
            skuCodeList.add(spuCode);
            if (imageCountMap.containsKey(spuCode)) {
                imageCountMap.put(spuCode, (Integer)imageCountMap.get(spuCode) + 1);
                if ((Integer)imageCountMap.get(spuCode) > 5) {
                    flag.set(true);
                    failReason.setFailReason("\u56fe\u7247\u6570\u91cf\u8d85\u8fc7\u4e0a\u9650\uff0c\u6700\u591a\u4e0a\u4f205\u5f20");
                    failReasonList.add(failReason);
                }
            } else {
                imageCountMap.put(spuCode, 1);
            }
            if (!spuImageAddressMap.containsKey(spuCode)) {
                spuCodeImageAddressMap = new HashMap();
                spuCodeImageAddressMap.put(imageNameSuffix, bo.getSkuImageAddress());
                spuImageAddressMap.put(spuCode, spuCodeImageAddressMap);
                continue;
            }
            spuCodeImageAddressMap.put(imageNameSuffix, bo.getSkuImageAddress());
            spuImageAddressMap.put(spuCode, spuCodeImageAddressMap);
        }
        List skuCodeExistsList = this.uccCommodityMapper.querySpuCodeExists(skuCodeList);
        List skuCodeNoExistsList = skuCodeList.stream().filter(e -> !skuCodeExistsList.contains(e)).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(skuCodeNoExistsList)) {
            flag.set(true);
            for (String skuCode : skuCodeNoExistsList) {
                failReason.setFailReason("\u5546\u54c1\u7f16\u7801\uff1a" + skuCode + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u547d\u540d\u56fe\u7247\u540d\u79f0\uff01");
                failReasonList.add(failReason);
            }
        }
    }

    private void validate(UccBatchSaveGoodImagesReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuImagesList())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61[skuImagesList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UccBatchSaveGoodImagesBO bo : reqBO.getSkuImagesList()) {
            if (StringUtil.isEmpty((String)bo.getSkuImageName())) {
                throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61[skuImagesList]\u7684[skuImageName]\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtil.isEmpty((String)bo.getSkuImageAddress())) continue;
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61[skuImagesList]\u7684[skuImageAddress]\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

