/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.csp.sentinel.util.StringUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.enumType.Brand;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.ability.bo.UccBrandUpdateReqBO;
import com.tydic.commodity.common.ability.bo.UccBrandUpdateRspBO;
import com.tydic.commodity.common.busi.api.UccBrandUpdateBusiService;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.commodity.utils.DateUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccBrandUpdateBusiServiceImpl
implements UccBrandUpdateBusiService {
    @Autowired
    private UccBrandDealMapper mapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccBrandUpdateBusiServiceImpl.class);
    UccBrandUpdateRspBO rspBO = new UccBrandUpdateRspBO();

    @Override
    public UccBrandUpdateRspBO updateBrand(UccBrandUpdateReqBO reqBO) {
        if (!this.judge(reqBO)) {
            this.rspBO.setRespCode("8888");
            return this.rspBO;
        }
        UccBrandDealPO brandDealPO = new UccBrandDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)brandDealPO);
        UccBrandUpdateBusiServiceImpl.transStringToDate(reqBO, brandDealPO);
        int result = 0;
        try {
            if (brandDealPO.getBrandStatus() != null) {
                UccBrandDealPO uccBrandDealPO;
                UccBrandDealPO temp;
                Date time = new Date(System.currentTimeMillis());
                if (brandDealPO.getBrandStatus() == 1) {
                    if (brandDealPO.getEffTime() != null && brandDealPO.getExpTime() != null) {
                        if (brandDealPO.getEffTime().getTime() <= time.getTime() && time.getTime() <= brandDealPO.getExpTime().getTime()) {
                            brandDealPO.setExpTime(null);
                            brandDealPO.setEffTime(null);
                        }
                    } else {
                        temp = new UccBrandDealPO();
                        temp.setBrandId(reqBO.getBrandId());
                        uccBrandDealPO = this.mapper.selectById(temp);
                        if (uccBrandDealPO.getExpTime() == null || uccBrandDealPO.getEffTime() == null || uccBrandDealPO.getEffTime().getTime() > time.getTime() || time.getTime() <= uccBrandDealPO.getExpTime().getTime()) {
                            // empty if block
                        }
                    }
                }
                if (brandDealPO.getBrandStatus() == 0) {
                    if (brandDealPO.getEffTime() != null && brandDealPO.getExpTime() != null) {
                        if (brandDealPO.getEffTime().getTime() < time.getTime() && time.getTime() < brandDealPO.getExpTime().getTime()) {
                            // empty if block
                        }
                    } else {
                        temp = new UccBrandDealPO();
                        temp.setBrandId(reqBO.getBrandId());
                        uccBrandDealPO = this.mapper.selectById(temp);
                        if (uccBrandDealPO.getExpTime() != null && uccBrandDealPO.getEffTime() != null && uccBrandDealPO.getEffTime().getTime() < time.getTime() && time.getTime() < uccBrandDealPO.getExpTime().getTime()) {
                            try {
                                this.mapper.updateBrandTime(temp.getBrandId());
                            }
                            catch (Exception e) {
                                throw new BusinessException("8888", "\u6e05\u9664\u751f\u5931\u6548\u65f6\u95f4\u5931\u8d25\uff1a" + e.getMessage());
                            }
                        }
                    }
                }
            }
            result = this.mapper.updateBrand(brandDealPO);
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u54c1\u724c\u5f02\u5e38", (Object)e.getMessage());
            throw new BusinessException("8888", "\u66f4\u65b0\u54c1\u724c\u4fe1\u606f\u5931\u8d25");
        }
        if (result > 0) {
            this.rspBO.setRespCode("0000");
            this.rspBO.setRespDesc("\u66f4\u65b0\u54c1\u724c\u4fe1\u606f\u6210\u529f");
        } else {
            this.rspBO.setRespCode("8888");
            this.rspBO.setRespDesc("\u66f4\u65b0\u54c1\u724c\u4fe1\u606f\u5931\u8d25");
        }
        return this.rspBO;
    }

    public boolean judge(UccBrandUpdateReqBO reqBO) {
        long result1;
        Date expTime;
        SimpleDateFormat str;
        Map map = null;
        if (reqBO.getBrandId() == null) {
            throw new BusinessException("8888", "\u54c1\u724cID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UccBrandDealPO po = new UccBrandDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        if (this.mapper.selectById(po) == null) {
            this.rspBO.setRespDesc("\u54c1\u724cID\u4e0d\u5b58\u5728");
            return false;
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getExpTime()) && StringUtil.isEmpty((String)reqBO.getEffTime())) {
            str = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                expTime = str.parse(reqBO.getExpTime());
                if (expTime.getTime() < new Date(System.currentTimeMillis()).getTime()) {
                    this.rspBO.setRespDesc("\u5931\u6548\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
                    return false;
                }
                UccBrandDealPO bo = new UccBrandDealPO();
                BeanUtils.copyProperties((Object)reqBO, (Object)bo);
                UccBrandDealPO result = this.mapper.selectById(bo);
                if (result != null && result.getEffTime() != null && result.getExpTime() != null && (result1 = result.getEffTime().getTime() - result.getExpTime().getTime()) > 0L) {
                    this.rspBO.setRespDesc("\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65f6\u95f4");
                    return false;
                }
            }
            catch (ParseException e) {
                throw new BusinessException("8888", "\u65f6\u95f4\u683c\u5f0f\u4e0d\u5bf9");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getEffTime()) && StringUtils.isEmpty((CharSequence)reqBO.getExpTime())) {
            str = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            UccBrandDealPO bo = new UccBrandDealPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)bo);
            UccBrandDealPO result = null;
            try {
                result = this.mapper.selectById(bo);
                Date effTime = DateUtils.strToDate((String)reqBO.getEffTime());
                if (result != null && result.getExpTime() != null && (result1 = effTime.getTime() - result.getExpTime().getTime()) > 0L) {
                    this.rspBO.setRespDesc("\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65f6\u95f4");
                    return false;
                }
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u65f6\u95f4\u683c\u5f0f\u4e0d\u5bf9");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getExpTime()) && !StringUtils.isEmpty((CharSequence)reqBO.getEffTime())) {
            str = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                expTime = str.parse(reqBO.getExpTime());
                Date effTime = str.parse(reqBO.getEffTime());
                long result = effTime.getTime() - expTime.getTime();
                if (result > 0L) {
                    this.rspBO.setRespDesc("\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65f6\u95f4");
                    return false;
                }
            }
            catch (ParseException e) {
                throw new BusinessException("8888", "\u65f6\u95f4\u683c\u5f0f\u4e0d\u5bf9");
            }
        }
        if (reqBO.getBrandStatus() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(Brand.BRAND_STATUS.toString())).containsKey(String.valueOf(reqBO.getBrandStatus()))) {
            this.rspBO.setRespDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u72b6\u6001");
            return false;
        }
        return true;
    }

    public static void transStringToDate(UccBrandUpdateReqBO reqBO, UccBrandDealPO brandDealPO) {
        String effTime = reqBO.getEffTime();
        String expTime = reqBO.getExpTime();
        Date effTime1 = null;
        Date expTime1 = null;
        try {
            if (StringUtils.isNotEmpty((CharSequence)effTime)) {
                effTime1 = DateUtils.strToDate((String)effTime);
            }
            if (StringUtils.isNotEmpty((CharSequence)expTime)) {
                expTime1 = DateUtils.strToDate((String)expTime);
            }
            brandDealPO.setEffTime(effTime1);
            brandDealPO.setExpTime(expTime1);
        }
        catch (Exception e) {
            LOGGER.error("\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u9519\u8bef");
            throw new ZTBusinessException(e.getMessage());
        }
    }
}

