/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.UccBrandAddReqBO;
import com.tydic.commodity.base.bo.UccBrandAddRspBO;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.MaterialSpecsEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.busi.api.UccBrandAddBusiService;
import com.tydic.commodity.common.ability.bo.MaterialPropBO;
import com.tydic.commodity.common.ability.bo.UccMaterialAddFromDataGovernanceAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccMaterialAddFromDataGovernanceAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccMaterialAddFromDataGovernanceDataBO;
import com.tydic.commodity.common.busi.api.UccCommdMeasureInfoAddBusiService;
import com.tydic.commodity.common.busi.api.UccMaterialAddFromDataGovernanceBusiService;
import com.tydic.commodity.common.busi.bo.UccCommdMeasureInfoAddBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccCommdMeasureInfoAddBusiRspBO;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccCommodityMeasureMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccEMdmMaterialPropDefMapper;
import com.tydic.commodity.dao.UccEMdmMaterialPropValueMapper;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.commodity.po.UccCommodityMeasurePo;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccEMdmMaterialPropDefPO;
import com.tydic.commodity.po.UccEMdmMaterialPropValuePO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class UccMaterialAddFromDataGovernanceBusiServiceImpl
implements UccMaterialAddFromDataGovernanceBusiService {
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Autowired
    private UccCommodityMeasureMapper uccCommodityMeasureMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccEMdmMaterialPropDefMapper uccEMdmMaterialPropDefMapper;
    @Autowired
    private UccEMdmMaterialPropValueMapper uccEMdmMaterialPropValueMapper;
    @Autowired
    private UccBrandAddBusiService uccBrandAddBusiService;
    @Autowired
    private UccCommdMeasureInfoAddBusiService uccCommdMeasureInfoAddBusiService;

    @Override
    public UccMaterialAddFromDataGovernanceAbilityRspBO dealUccMaterialAddFromDataGovernance(UccMaterialAddFromDataGovernanceAbilityReqBO reqBO) {
        UccMaterialAddFromDataGovernanceAbilityRspBO rspBO = new UccMaterialAddFromDataGovernanceAbilityRspBO();
        String remark = "\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)reqBO);
        UccEMdmMaterialPO uccEMdmMaterialPO = new UccEMdmMaterialPO();
        uccEMdmMaterialPO.setSysTenantId(reqBO.getSysTenantId());
        uccEMdmMaterialPO.setSysTenantName(reqBO.getSysTenantName());
        ArrayList<UccEMdmMaterialPropDefPO> propDefPOList = new ArrayList<UccEMdmMaterialPropDefPO>();
        ArrayList<UccEMdmMaterialPropValuePO> propValuePOList = new ArrayList<UccEMdmMaterialPropValuePO>();
        this.checkParam(reqBO);
        this.buildMaterialInfo(reqBO.getData(), uccEMdmMaterialPO, propDefPOList, propValuePOList);
        this.uccEMdmMaterialMapper.insert(uccEMdmMaterialPO);
        if (!CollectionUtils.isEmpty(propDefPOList)) {
            propDefPOList.forEach(item -> {
                item.setSysTenantId(reqBO.getSysTenantId());
                item.setSysTenantName(reqBO.getSysTenantName());
            });
            this.uccEMdmMaterialPropDefMapper.insertBatch(propDefPOList);
        }
        if (!CollectionUtils.isEmpty(propValuePOList)) {
            propValuePOList.forEach(item -> {
                item.setSysTenantId(reqBO.getSysTenantId());
                item.setSysTenantName(reqBO.getSysTenantName());
            });
            this.uccEMdmMaterialPropValueMapper.insertBatch(propValuePOList);
        }
        rspBO.setSource(uccEMdmMaterialPO.getMaterialId());
        rspBO.setSerialNo(reqBO.getSerialNo());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void buildMaterialInfo(UccMaterialAddFromDataGovernanceDataBO data, UccEMdmMaterialPO uccEMdmMaterialPO, List<UccEMdmMaterialPropDefPO> propDefPOList, List<UccEMdmMaterialPropValuePO> propValuePOList) {
        List materialPOList;
        JSONObject materialJsonObj = new JSONObject();
        Date now = new Date();
        Long materialId = null;
        if (!StringUtils.isEmpty((Object)data.getMaterialId())) {
            materialId = Long.valueOf(data.getMaterialId());
            UccEMdmMaterialPO materialPO = this.uccEMdmMaterialMapper.selectByPrimaryKey(materialId);
            if (!ObjectUtils.isEmpty((Object)materialPO)) {
                throw new BusinessException(RspConstantEnums.SYSTEM_EXCEPTION.code(), "\u6b64\u7269\u6599ID\u5df2\u5b58\u5728");
            }
        } else {
            materialId = Sequence.getInstance().nextId();
        }
        if (!CollectionUtils.isEmpty((Collection)data.getSpecs())) {
            for (MaterialPropBO propBO : data.getSpecs()) {
                if (MaterialSpecsEnum.getByPropName((String)propBO.getPropName()) != null) {
                    materialJsonObj.put(MaterialSpecsEnum.getByPropName((String)propBO.getPropName()).getPropCode(), (Object)propBO.getPropValue());
                    continue;
                }
                UccEMdmMaterialPropDefPO propDefPO = new UccEMdmMaterialPropDefPO();
                propDefPO.setPropDefId(Long.valueOf(Sequence.getInstance().nextId()));
                propDefPO.setMaterialId(materialId);
                propDefPO.setMaterialCode(data.getMaterialCode());
                propDefPO.setCatalogId(data.getCategoryId());
                propDefPO.setPropCode(propDefPO.getPropDefId().toString());
                propDefPO.setPropName(propBO.getPropName());
                propDefPO.setCreateTime(now);
                propDefPOList.add(propDefPO);
                UccEMdmMaterialPropValuePO propValuePO = new UccEMdmMaterialPropValuePO();
                propValuePO.setPropValueId(Long.valueOf(Sequence.getInstance().nextId()));
                propValuePO.setMaterialId(materialId);
                propValuePO.setCatalogId(data.getCategoryId());
                propValuePO.setPropDefId(propDefPO.getPropDefId());
                propValuePO.setPropCode(propDefPO.getPropDefId().toString());
                propValuePO.setPropName(propBO.getPropName());
                propValuePO.setMaterialCode(data.getMaterialCode());
                propValuePO.setPropValue(propBO.getPropValue());
                propValuePO.setCreateTime(now);
                propValuePOList.add(propValuePO);
            }
            UccEMdmMaterialPO tempUccEMdmMaterialPO = (UccEMdmMaterialPO)JSONObject.parseObject((String)JSON.toJSONString((Object)materialJsonObj), UccEMdmMaterialPO.class);
            BeanUtils.copyProperties((Object)tempUccEMdmMaterialPO, (Object)uccEMdmMaterialPO);
        }
        if (!CollectionUtils.isEmpty((Collection)(materialPOList = this.uccEMdmMaterialMapper.selectListByMaterialCode(data.getMaterialCode(), null)))) {
            throw new BusinessException(RspConstantEnums.SYSTEM_EXCEPTION.code(), "\u6b64\u7269\u6599\u7f16\u7801\u5df2\u5b58\u5728");
        }
        uccEMdmMaterialPO.setMaterialId(materialId);
        uccEMdmMaterialPO.setMaterialCode(data.getMaterialCode());
        uccEMdmMaterialPO.setCatalogId(data.getCategoryId());
        uccEMdmMaterialPO.setCatalogName(data.getCategoryName());
        uccEMdmMaterialPO.setMaterialName(data.getMaterialName());
        uccEMdmMaterialPO.setLongDesc(data.getLongDesc());
        uccEMdmMaterialPO.setCreateTime(now);
        uccEMdmMaterialPO.setIsDelete(UccConstants.DeleteFlag.INTEGER_NO);
        uccEMdmMaterialPO.setFreezeFlag(Integer.valueOf(0));
        uccEMdmMaterialPO.setSource(Integer.valueOf(3));
        if (!StringUtils.isEmpty((Object)uccEMdmMaterialPO.getMeasure())) {
            ArrayList<String> measureNames = new ArrayList<String>();
            measureNames.add(uccEMdmMaterialPO.getMeasure());
            UccCommodityMeasurePo uccCommodityMeasurePo = new UccCommodityMeasurePo();
            uccCommodityMeasurePo.setMeasureNames(measureNames);
            List uccCommodityMeasurePos = this.uccCommodityMeasureMapper.queryMeasureByPO(uccCommodityMeasurePo);
            if (CollectionUtils.isEmpty((Collection)uccCommodityMeasurePos)) {
                UccCommdMeasureInfoAddBusiReqBO busiReqBO = new UccCommdMeasureInfoAddBusiReqBO();
                busiReqBO.setMeasureName(uccEMdmMaterialPO.getMeasure());
                busiReqBO.setStatus(1);
                busiReqBO.setMeasureSource(1);
                UccCommdMeasureInfoAddBusiRspBO busiRspBO = this.uccCommdMeasureInfoAddBusiService.addmeasureInfo(busiReqBO);
                if (!"0000".equals(busiRspBO.getRespCode())) {
                    throw new BusinessException(RspConstantEnums.SYSTEM_EXCEPTION.code(), busiRspBO.getRespDesc());
                }
                uccEMdmMaterialPO.setMeasureId(busiRspBO.getMeasureId());
            } else {
                uccEMdmMaterialPO.setMeasureId(((UccCommodityMeasurePo)uccCommodityMeasurePos.get(0)).getMeasureId());
            }
        }
        if (!StringUtils.isEmpty((Object)uccEMdmMaterialPO.getBrandName())) {
            ArrayList<String> brandNames = new ArrayList<String>();
            brandNames.add(uccEMdmMaterialPO.getBrandName());
            List uccBrandDealPOS = this.uccBrandDealMapper.querySpuBrandByNameList(brandNames);
            if (CollectionUtils.isEmpty((Collection)uccBrandDealPOS)) {
                UccBrandAddReqBO brandAddReqBO = new UccBrandAddReqBO();
                brandAddReqBO.setBrandName(uccEMdmMaterialPO.getBrandName());
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                brandAddReqBO.setEffTime(df.format(now));
                brandAddReqBO.setExpTime("2099-12-31 00:00:00");
                brandAddReqBO.setBrandStatus(Integer.valueOf(1));
                brandAddReqBO.setCreateTime(brandAddReqBO.getEffTime());
                UccBrandAddRspBO brandAddRspBO = this.uccBrandAddBusiService.addBrand(brandAddReqBO);
                if (!"0000".equals(brandAddRspBO.getRespCode())) {
                    throw new BusinessException(RspConstantEnums.SYSTEM_EXCEPTION.code(), brandAddRspBO.getRespDesc());
                }
                uccEMdmMaterialPO.setBrandId(brandAddRspBO.getBrandId());
            } else {
                uccEMdmMaterialPO.setBrandId(((UccBrandDealPO)uccBrandDealPOS.get(0)).getBrandId());
            }
        }
    }

    private void checkParam(UccMaterialAddFromDataGovernanceAbilityReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getData())) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e1a\u52a1\u6570\u636e\u3010data\u3011\u4e3a\u7a7a!");
        }
        UccMaterialAddFromDataGovernanceDataBO dataBO = reqBO.getData();
        if (StringUtils.isEmpty((Object)dataBO.getCategoryCode())) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e1a\u52a1\u6570\u636e\u7c7b\u522b\u7f16\u7801\u3010categoryCode\u3011\u4e3a\u7a7a!");
        }
        UccEMdmCatalogPO eMdmCatalogPO = new UccEMdmCatalogPO();
        eMdmCatalogPO.setIsDelete(Integer.valueOf(0));
        eMdmCatalogPO.setCatalogCode(dataBO.getCategoryCode());
        List catalogPOS = this.uccEMdmCatalogMapper.qryUccEMdmCatalog(eMdmCatalogPO);
        if (CollectionUtils.isEmpty((Collection)catalogPOS)) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u7c7b\u522b\u7f16\u7801\u3010categoryCode\u3011\u5bf9\u5e94\u7c7b\u522b!");
        }
        if (((UccEMdmCatalogPO)catalogPOS.get(0)).getLastLevel() == 0) {
            throw new BusinessException("8888", "\u7c7b\u522b\u7f16\u7801\u3010categoryCode\u3011\u4e0d\u662f\u672b\u7ea7\u5206\u7c7b\uff0c\u4e0d\u80fd\u5173\u8054\u7269\u6599\u6570\u636e!");
        }
        dataBO.setCategoryId(((UccEMdmCatalogPO)catalogPOS.get(0)).getCatalogId());
        if (!StringUtils.isEmpty((Object)dataBO.getCategoryName()) && !dataBO.getCategoryName().equals(((UccEMdmCatalogPO)catalogPOS.get(0)).getCatalogName())) {
            throw new BusinessException("8888", "\u7c7b\u522b\u540d\u79f0\u3010categoryName\u3011\u4e0e\u5546\u57ce\u7c7b\u522b\u540d\u79f0\u4e0d\u4e00\u81f4!");
        }
        dataBO.setCategoryName(((UccEMdmCatalogPO)catalogPOS.get(0)).getCatalogName());
        if (StringUtils.isEmpty((Object)dataBO.getMaterialCode())) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e1a\u52a1\u6570\u636e\u7269\u6599\u7f16\u7801\u3010materialCode\u3011\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((Object)dataBO.getMaterialName())) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e1a\u52a1\u6570\u636e\u7269\u6599\u540d\u79f0\u3010materialName\u3011\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((Object)dataBO.getLongDesc())) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e1a\u52a1\u6570\u636e\u7269\u6599\u957f\u63cf\u8ff0\u3010longDesc\u3011\u4e3a\u7a7a!");
        }
        if (CollectionUtils.isEmpty((Collection)dataBO.getSpecs())) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e1a\u52a1\u6570\u636e\u7269\u6599\u5c5e\u6027\u5217\u8868\u3010specs\u3011\u4e3a\u7a7a!");
        }
    }
}

