/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.UccDealPoolSyncESAtomReqBo;
import com.tydic.commodity.common.ability.api.UccCatalogRelChannelAbilityService;
import com.tydic.commodity.common.ability.api.UccReadRedisCatalogAbilityService;
import com.tydic.commodity.common.ability.bo.UccCatalogRelChannelAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccCatalogRelChannelAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccReadRdisCategoryQryReqBO;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.po.UccCatalogDealPO;
import com.tydic.commodity.po.UccRelChannelCatalogPO;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccCatalogRelChannelAbilityService"})
public class UccCatalogRelChannelAbilityServiceImpl
implements UccCatalogRelChannelAbilityService {
    private Sequence uccBrandSequence = Sequence.getInstance();
    @Autowired
    private UccCatalogDealMapper cccCatalogDealMapper;
    @Autowired
    private UccReadRedisCatalogAbilityService uccReadRedisCatalogAbilityService;
    @Resource(name="uccDealPoolSyncToESProvider")
    private ProxyMessageProducer uccDealPoolSyncToESProvider;

    @PostMapping(value={"relChannel"})
    public UccCatalogRelChannelAbilityRspBO relChannel(@RequestBody UccCatalogRelChannelAbilityReqBO reqBO) {
        UccCatalogRelChannelAbilityRspBO rspBO = new UccCatalogRelChannelAbilityRspBO();
        if (reqBO.getChannelId() == null || CollectionUtils.isEmpty((Collection)reqBO.getCatalogIds())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u53c2\u6570\u4e0d\u5b8c\u6574");
            return rspBO;
        }
        List<Long> catalogIds = this.dealData(reqBO);
        reqBO.setCatalogIds(catalogIds);
        List<UccRelChannelCatalogPO> list = this.createList(reqBO);
        this.cccCatalogDealMapper.batchInsert(list);
        UccReadRdisCategoryQryReqBO uccReadRdisCategoryQryReqBO = new UccReadRdisCategoryQryReqBO();
        uccReadRdisCategoryQryReqBO.setRedisKey(reqBO.getChannelId().toString());
        this.uccReadRedisCatalogAbilityService.clearCatagoryRedis(uccReadRdisCategoryQryReqBO);
        this.uccReadRedisCatalogAbilityService.readRedisCatalog(uccReadRdisCategoryQryReqBO);
        UccDealPoolSyncESAtomReqBo uccDealPoolSyncESAtomReqBo = new UccDealPoolSyncESAtomReqBo();
        uccDealPoolSyncESAtomReqBo.setSyncType(Integer.valueOf(5));
        uccDealPoolSyncESAtomReqBo.setGuideCatalogIds(catalogIds);
        this.uccDealPoolSyncToESProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"UCC_SYNC_POOL_ES_TOPIC"), PropertiesUtil.getProperty((String)"UCC_SYNC_POOL_ES_TAG"), JSON.toJSONString((Object)uccDealPoolSyncESAtomReqBo)));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<Long> dealData(UccCatalogRelChannelAbilityReqBO reqBO) {
        List catalogIds = reqBO.getCatalogIds();
        ArrayList<Long> dataIds = new ArrayList<Long>();
        List upperCatalogList = this.cccCatalogDealMapper.queryUpperCatalog(reqBO.getChannelId());
        if (!CollectionUtils.isEmpty((Collection)upperCatalogList)) {
            List upperCatalogIds = upperCatalogList.stream().map(UccCatalogDealPO::getGuideCatalogId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(upperCatalogIds)) {
                for (Long catalogId : catalogIds) {
                    if (upperCatalogIds.contains(catalogId)) continue;
                    dataIds.add(catalogId);
                }
            }
            return dataIds;
        }
        return catalogIds;
    }

    private List<UccRelChannelCatalogPO> createList(UccCatalogRelChannelAbilityReqBO reqBO) {
        ArrayList<UccRelChannelCatalogPO> list = new ArrayList<UccRelChannelCatalogPO>();
        List catalogIds = reqBO.getCatalogIds();
        for (Long catalogId : catalogIds) {
            UccRelChannelCatalogPO cnncUccRelChannelCatalogPO = new UccRelChannelCatalogPO();
            cnncUccRelChannelCatalogPO.setChannelId(reqBO.getChannelId());
            cnncUccRelChannelCatalogPO.setGuideCatalogId(catalogId);
            cnncUccRelChannelCatalogPO.setId(Long.valueOf(this.uccBrandSequence.nextId()));
            cnncUccRelChannelCatalogPO.setSysTenantId(reqBO.getSysTenantId());
            cnncUccRelChannelCatalogPO.setSysTenantName(reqBO.getSysTenantName());
            list.add(cnncUccRelChannelCatalogPO);
        }
        return list;
    }
}

