/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.google.common.collect.Lists;
import com.tydic.commodity.base.bo.OrderColumBo;
import com.tydic.commodity.base.constant.FuzzyFieldsEnum;
import com.tydic.commodity.busibase.comb.api.SearchCommodityManageCombService;
import com.tydic.commodity.busibase.comb.bo.SearchCommodityManageCombReqBo;
import com.tydic.commodity.busibase.comb.bo.SearchCommodityManageCombRspBo;
import com.tydic.commodity.common.ability.api.UccQryNotAddSkuAddPriceListService;
import com.tydic.commodity.common.ability.bo.UccQryNotAddSkuAddPriceListBo;
import com.tydic.commodity.common.ability.bo.UccQryNotAddSkuAddPriceListReqBO;
import com.tydic.commodity.common.ability.bo.UccQryNotAddSkuAddPriceListRspBO;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccQryNotAddSkuAddPriceListService"})
public class UccQryNotAddSkuAddPriceListServiceImpl
implements UccQryNotAddSkuAddPriceListService {
    private static final Logger log = LoggerFactory.getLogger(UccQryNotAddSkuAddPriceListServiceImpl.class);
    @Autowired
    private SearchCommodityManageCombService SearchCommodityManageCombService;
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private UccEMdmCatalogMapper cnncUccEMdmCatalogMapper;

    @PostMapping(value={"getNotAddSkuAddPriceList"})
    public UccQryNotAddSkuAddPriceListRspBO getNotAddSkuAddPriceList(@RequestBody UccQryNotAddSkuAddPriceListReqBO reqBO) {
        UccQryNotAddSkuAddPriceListRspBO rspBO = new UccQryNotAddSkuAddPriceListRspBO();
        ArrayList cnncUccQryNotAddSkuAddPriceListBos = new ArrayList();
        SearchCommodityManageCombReqBo searchCommodityManageAbilityReqBo = new SearchCommodityManageCombReqBo();
        List uccSkuAddCoefficientPOS = this.uccSkuAddCoefficientMapper.selectBySkuIds(null);
        if (!CollectionUtils.isEmpty((Collection)uccSkuAddCoefficientPOS)) {
            List skuIds = uccSkuAddCoefficientPOS.stream().filter(a -> a.getSkuId() != null).map(a -> a.getSkuId()).collect(Collectors.toList());
            searchCommodityManageAbilityReqBo.setIgnoreList(skuIds);
        }
        searchCommodityManageAbilityReqBo.setSkuName(reqBO.getSkuName());
        List fuzzyFields = FuzzyFieldsEnum.getAllField();
        fuzzyFields.add("extSkuId");
        fuzzyFields.add("extSpuId");
        fuzzyFields.add("skuCode");
        fuzzyFields.add("commodityCode");
        searchCommodityManageAbilityReqBo.setFuzzyFields(fuzzyFields);
        searchCommodityManageAbilityReqBo.setPageNo(Integer.valueOf(reqBO.getPageNo()));
        searchCommodityManageAbilityReqBo.setPageSize(Integer.valueOf(reqBO.getPageSize()));
        searchCommodityManageAbilityReqBo.setSupplierShopId(reqBO.getShopId());
        searchCommodityManageAbilityReqBo.setMaterialCatalogId(reqBO.getCatalogId());
        searchCommodityManageAbilityReqBo.setExtSkuId(reqBO.getExtSkuId());
        searchCommodityManageAbilityReqBo.setExtSpuId(reqBO.getExtSpuId());
        searchCommodityManageAbilityReqBo.setSkuCode(reqBO.getSkuCode());
        searchCommodityManageAbilityReqBo.setCommodityCode(reqBO.getCommodityCode());
        searchCommodityManageAbilityReqBo.setSupplierId(reqBO.getSupplierId());
        if (!ObjectUtils.isEmpty((Object)reqBO.getSkuId())) {
            searchCommodityManageAbilityReqBo.setSkuList(new ArrayList<Long>(Arrays.asList(reqBO.getSkuId())));
        }
        if (!ObjectUtils.isEmpty((Object)reqBO.getCommodityId())) {
            searchCommodityManageAbilityReqBo.setCommdIds(new ArrayList<String>(Arrays.asList(reqBO.getCommodityId())));
        }
        searchCommodityManageAbilityReqBo.setSkuSource(Integer.valueOf(2));
        OrderColumBo orderColumBo = new OrderColumBo();
        orderColumBo.setOrderByColumn("create_time");
        orderColumBo.setOrderType(Integer.valueOf(0));
        searchCommodityManageAbilityReqBo.setOrderColum((List)Lists.newArrayList((Object[])new OrderColumBo[]{orderColumBo}));
        SearchCommodityManageCombRspBo SearchCommodityManageCombRspBo2 = this.SearchCommodityManageCombService.searchCommodity(searchCommodityManageAbilityReqBo);
        if ("0000".equals(SearchCommodityManageCombRspBo2.getRespCode())) {
            if (!CollectionUtils.isEmpty((Collection)SearchCommodityManageCombRspBo2.getResult())) {
                HashMap<Long, String> catAndName = new HashMap<Long, String>();
                List<Long> catalogIds = SearchCommodityManageCombRspBo2.getResult().stream().filter(a -> a.getMaterialCatalogId() != null).map(a -> a.getMaterialCatalogId()).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(catalogIds)) {
                    List<UccEMdmCatalogPO> findParent = this.findParent(catalogIds);
                    this.getPath(findParent, catAndName);
                }
                SearchCommodityManageCombRspBo2.getResult().forEach(each -> {
                    UccQryNotAddSkuAddPriceListBo cnncUccQryNotAddSkuAddPriceListBo = new UccQryNotAddSkuAddPriceListBo();
                    cnncUccQryNotAddSkuAddPriceListBo.setCatalogAll((String)catAndName.get(each.getMaterialCatalogId()));
                    cnncUccQryNotAddSkuAddPriceListBo.setExtSkuId(each.getExtSkuId());
                    cnncUccQryNotAddSkuAddPriceListBo.setShopId(each.getSupplierShopId());
                    cnncUccQryNotAddSkuAddPriceListBo.setShopName(each.getShopName());
                    cnncUccQryNotAddSkuAddPriceListBo.setSkuId(each.getSkuId());
                    cnncUccQryNotAddSkuAddPriceListBo.setSkuName(each.getSkuName());
                    cnncUccQryNotAddSkuAddPriceListBo.setCommodityId(each.getCommodityId());
                    cnncUccQryNotAddSkuAddPriceListBo.setCommodityName(each.getCommodityName());
                    cnncUccQryNotAddSkuAddPriceListBo.setExtSpuId(each.getExtSpuId());
                    cnncUccQryNotAddSkuAddPriceListBo.setCommodityName(each.getCommodityName());
                    cnncUccQryNotAddSkuAddPriceListBo.setSupplierShopId(each.getSupplierShopId());
                    cnncUccQryNotAddSkuAddPriceListBo.setVendorId(each.getVendorId());
                    cnncUccQryNotAddSkuAddPriceListBo.setVendorName(each.getVendorName());
                    cnncUccQryNotAddSkuAddPriceListBo.setCatalogId(each.getCatalogId());
                    cnncUccQryNotAddSkuAddPriceListBo.setCommodityCode(each.getCommodityCode());
                    cnncUccQryNotAddSkuAddPriceListBo.setSkuCode(each.getSkuCode());
                    cnncUccQryNotAddSkuAddPriceListBos.add(cnncUccQryNotAddSkuAddPriceListBo);
                });
            }
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(SearchCommodityManageCombRspBo2.getRespDesc());
            return rspBO;
        }
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(SearchCommodityManageCombRspBo2.getRecordsTotal());
        rspBO.setTotal(SearchCommodityManageCombRspBo2.getTotal());
        rspBO.setRows(cnncUccQryNotAddSkuAddPriceListBos);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    List<UccEMdmCatalogPO> findParent(List<Long> catalogId) {
        ArrayList<UccEMdmCatalogPO> poList = new ArrayList<UccEMdmCatalogPO>();
        List qryRspList = this.cnncUccEMdmCatalogMapper.queryByIds(catalogId);
        if (CollectionUtils.isEmpty((Collection)qryRspList)) {
            return poList;
        }
        poList.addAll(qryRspList);
        ArrayList<Long> next = new ArrayList<Long>();
        qryRspList.forEach(a -> {
            if (a.getCatalogLevel() > 1) {
                next.add(a.getParentCatalogId());
            }
        });
        if (CollectionUtils.isEmpty(next)) {
            return poList;
        }
        List<UccEMdmCatalogPO> parent = this.findParent(next);
        poList.addAll(parent);
        return poList;
    }

    void getPath(List<UccEMdmCatalogPO> cnncUccEMdmCatalogPoList, Map<Long, String> catAndName) {
        List<UccEMdmCatalogPO> uccEMdmCatalogPoList;
        Map<Integer, List<UccEMdmCatalogPO>> groupLevel = cnncUccEMdmCatalogPoList.stream().collect(Collectors.groupingBy(UccEMdmCatalogPO::getLastLevel));
        Map<Long, UccEMdmCatalogPO> name = cnncUccEMdmCatalogPoList.stream().collect(Collectors.toMap(UccEMdmCatalogPO::getCatalogId, CnncUccEMdmCatalogPo -> CnncUccEMdmCatalogPo, (item1, item2) -> item1));
        if (groupLevel.containsKey(1)) {
            uccEMdmCatalogPoList = groupLevel.get(1);
            for (UccEMdmCatalogPO each : uccEMdmCatalogPoList) {
                catAndName.put(each.getCatalogId(), this.findParent(each.getParentCatalogId(), name, each.getCatalogName()));
            }
        }
        if (groupLevel.containsKey(2)) {
            uccEMdmCatalogPoList = groupLevel.get(2);
            for (UccEMdmCatalogPO each : uccEMdmCatalogPoList) {
                catAndName.put(each.getCatalogId(), this.findParent(each.getParentCatalogId(), name, each.getCatalogName()));
            }
        }
    }

    String findParent(Long cataLogId, Map<Long, UccEMdmCatalogPO> nameMap, String name) {
        if (nameMap == null || nameMap.isEmpty()) {
            return name;
        }
        if (nameMap.containsKey(cataLogId)) {
            name = nameMap.get(cataLogId).getCatalogName() + "/" + name;
            if (nameMap.get(cataLogId).getCatalogLevel() == 1) {
                return name;
            }
            return this.findParent(nameMap.get(cataLogId).getParentCatalogId(), nameMap, name);
        }
        return name;
    }
}

