/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.commodity.common.ability.api.UccReadRedisCatalogAbilityService;
import com.tydic.commodity.common.ability.bo.GuideCatalogBO;
import com.tydic.commodity.common.ability.bo.UccReadRdisCategoryQryReqBO;
import com.tydic.commodity.common.ability.bo.UccReadRdisCategoryQryRspBO;
import com.tydic.commodity.common.busi.api.UccChannelSelectBusiService;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.po.UccCatalogDealPO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccReadRedisCatalogAbilityService"})
public class UccReadRedisCatalogAbilityServiceImpl
implements UccReadRedisCatalogAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccReadRedisCatalogAbilityServiceImpl.class);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private UccEMdmCatalogMapper eMdmCatalogMapper;
    @Autowired
    private UccCatalogDealMapper uccCatalogDealMapper;
    @Autowired
    private UccChannelSelectBusiService channelSelectBusiService;

    @PostMapping(value={"readRedisCatalog"})
    public UccReadRdisCategoryQryRspBO readRedisCatalog(@RequestBody UccReadRdisCategoryQryReqBO reqBO) {
        UccReadRdisCategoryQryRspBO rspBO = new UccReadRdisCategoryQryRspBO();
        Object object = this.cacheClient.get("CHANNEL_NUM" + reqBO.getRedisKey());
        if (object != null) {
            String jsonString = JSONArray.toJSONString((Object)object);
            List guideCatalogBOS = JSONArray.parseArray((String)jsonString, GuideCatalogBO.class);
            rspBO.setGuideCatalogBOS(guideCatalogBOS);
        } else {
            List uccCatalogDealPOS = this.uccCatalogDealMapper.selectCatalogByChannel(Long.valueOf(reqBO.getRedisKey()));
            List<GuideCatalogBO> guideCatalogBOS = this.createList(uccCatalogDealPOS);
            this.cacheClient.set("CHANNEL_NUM" + reqBO.getRedisKey(), (Object)JSONObject.parseArray((String)JSONObject.toJSONString(guideCatalogBOS)));
            rspBO.setGuideCatalogBOS(guideCatalogBOS);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"clearCatagoryRedis"})
    public UccReadRdisCategoryQryRspBO clearCatagoryRedis(@RequestBody UccReadRdisCategoryQryReqBO reqBO) {
        UccReadRdisCategoryQryRspBO rspBO = new UccReadRdisCategoryQryRspBO();
        this.cacheClient.delete("CHANNEL_NUM" + reqBO.getRedisKey());
        return rspBO;
    }

    private List<GuideCatalogBO> createList(List<UccCatalogDealPO> list) {
        ArrayList<GuideCatalogBO> rows = new ArrayList<GuideCatalogBO>();
        List guideCatalogList01 = list.stream().filter(s -> s.getCatalogLevel().equals(1)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(guideCatalogList01)) {
            List<GuideCatalogBO> rows02;
            for (UccCatalogDealPO uccCatalogDealPO : guideCatalogList01) {
                GuideCatalogBO guideCatalogBO = new GuideCatalogBO();
                BeanUtils.copyProperties((Object)uccCatalogDealPO, (Object)guideCatalogBO);
                rows.add(guideCatalogBO);
            }
            for (GuideCatalogBO guideCatalogBO : rows) {
                rows02 = new ArrayList();
                List guideCatalogList02 = list.stream().filter(s -> s.getUpperCatalogId().equals(guideCatalogBO.getGuideCatalogId())).collect(Collectors.toList());
                for (UccCatalogDealPO uccCatalogDealPO : guideCatalogList02) {
                    GuideCatalogBO guideCatalogBO02 = new GuideCatalogBO();
                    BeanUtils.copyProperties((Object)uccCatalogDealPO, (Object)guideCatalogBO02);
                    rows02.add(guideCatalogBO02);
                }
                guideCatalogBO.setRows(rows02);
            }
            for (GuideCatalogBO guideCatalogBO : rows) {
                rows02 = guideCatalogBO.getRows();
                for (GuideCatalogBO guideCatalogBO2 : rows02) {
                    ArrayList<GuideCatalogBO> rows03 = new ArrayList<GuideCatalogBO>();
                    List guideCatalogList03 = list.stream().filter(s -> s.getUpperCatalogId().equals(guideCatalogBO2.getGuideCatalogId())).collect(Collectors.toList());
                    for (UccCatalogDealPO uccCatalogDealPO : guideCatalogList03) {
                        GuideCatalogBO guideCatalogBO03 = new GuideCatalogBO();
                        BeanUtils.copyProperties((Object)uccCatalogDealPO, (Object)guideCatalogBO03);
                        rows03.add(guideCatalogBO03);
                    }
                    guideCatalogBO2.setRows(rows03);
                }
            }
        }
        return rows;
    }
}

