/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.tydic.commodity.common.ability.api.UccReadRedisCatalogAbilityService;
import com.tydic.commodity.common.ability.bo.UccDelCatalogRelAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccDelCatalogRelAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccReadRdisCategoryQryReqBO;
import com.tydic.commodity.common.busi.api.UccDelCatalogRelBusiService;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.UccRelChannelCatalogMapper;
import com.tydic.commodity.po.UccCatalogDealPO;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccDelCatalogRelBusiServiceImpl
implements UccDelCatalogRelBusiService {
    @Autowired
    private UccCatalogDealMapper uccCatalogDealMapper;
    @Autowired
    private UccRelChannelCatalogMapper uccRelChannelCatalogMapper;
    @Autowired
    private UccReadRedisCatalogAbilityService uccReadRedisCatalogAbilityService;

    @Override
    public UccDelCatalogRelAbilityRspBO delCatalogRel(UccDelCatalogRelAbilityReqBO reqBO) {
        UccDelCatalogRelAbilityRspBO rspBO = new UccDelCatalogRelAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getCatalogIds())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7c7b\u76eeid\u4e3a\u7a7a");
            return rspBO;
        }
        List catalogIds = reqBO.getCatalogIds();
        this.uccCatalogDealMapper.batchDelete(reqBO.getChannelId(), catalogIds);
        for (Long catalogId : reqBO.getCatalogIds()) {
            this.dealUpperCatalogRel(reqBO.getChannelId(), catalogId);
        }
        UccReadRdisCategoryQryReqBO uccReadRdisCategoryQryReqBO = new UccReadRdisCategoryQryReqBO();
        uccReadRdisCategoryQryReqBO.setRedisKey(reqBO.getChannelId().toString());
        this.uccReadRedisCatalogAbilityService.clearCatagoryRedis(uccReadRdisCategoryQryReqBO);
        this.uccReadRedisCatalogAbilityService.readRedisCatalog(uccReadRdisCategoryQryReqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealUpperCatalogRel(Long channelId, Long catalogId) {
        UccCatalogDealPO temp = new UccCatalogDealPO();
        temp.setGuideCatalogId(catalogId);
        UccCatalogDealPO uccCatalogDealPO = this.uccCatalogDealMapper.selectCatalogById(temp);
        List uccCatalogDealPOS = this.uccCatalogDealMapper.selectByUpperCatIds(Arrays.asList(uccCatalogDealPO.getUpperCatalogId()));
        List catalogList = this.uccRelChannelCatalogMapper.checkCatalog(channelId, uccCatalogDealPOS.stream().map(UccCatalogDealPO::getGuideCatalogId).collect(Collectors.toList()));
        if (!CollectionUtils.isEmpty((Collection)catalogList)) {
            Integer catalogLevel = ((UccCatalogDealPO)uccCatalogDealPOS.get(0)).getCatalogLevel();
            catalogList.removeIf(e -> e.equals(catalogId));
            if (catalogList.size() == 0) {
                this.uccCatalogDealMapper.batchDelete(channelId, Arrays.asList(uccCatalogDealPO.getUpperCatalogId()));
                if (catalogLevel != 1) {
                    this.dealUpperCatalogRel(channelId, uccCatalogDealPO.getUpperCatalogId());
                }
            }
        } else {
            this.uccCatalogDealMapper.batchDelete(channelId, Arrays.asList(uccCatalogDealPO.getUpperCatalogId()));
            if (((UccCatalogDealPO)uccCatalogDealPOS.get(0)).getCatalogLevel() != 1) {
                this.dealUpperCatalogRel(channelId, uccCatalogDealPO.getUpperCatalogId());
            }
        }
    }
}

