/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccExportImportResultsBusiReqBO;
import com.tydic.commodity.common.ability.bo.UccExportImportResultsBusiRspBO;
import com.tydic.commodity.common.busi.api.UccExportImportResultsBusiService;
import com.tydic.commodity.utils.ExcelUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UccExportImportResultsBusiServiceImpl
implements UccExportImportResultsBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccExportImportResultsBusiServiceImpl.class);
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Autowired
    private FileClient fileClient;
    @Value(value="${preFilePath}")
    private String preFilePath;
    @Value(value="${export.file.public.url}")
    private String exportFilePublicUrl;

    @Override
    public UccExportImportResultsBusiRspBO importExportLog(UccExportImportResultsBusiReqBO reqBO) {
        UccExportImportResultsBusiRspBO rspBO = new UccExportImportResultsBusiRspBO();
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>();
        ArrayList Data = new ArrayList();
        int index = 0;
        for (Map map : reqBO.getImportDataMaps()) {
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
            item.put("\u5e8f\u53f7", ++index);
            item.put("\u53d6\u6d88\u5546\u54c1\u4e0e\u7269\u6599\u5173\u7cfb\u5bfc\u5165\u539f\u56e0", map.get("uccCancelReasonInfo") != null ? map.get("uccCancelReasonInfo") : "");
            item.put("\u5176\u4ed6\u539f\u56e0", map.get("otherReason") != null ? map.get("otherReason") : "");
            item.put("\u72b6\u6001", map.get("freezeFlag") != null ? map.get("freezeFlag") : "");
            Integer impResult = (Integer)map.get("impResult");
            if (impResult != null) {
                if (impResult.equals(0)) {
                    item.put("\u5bfc\u5165\u7ed3\u679c", "\u6210\u529f");
                    item.put("\u5931\u8d25\u539f\u56e0", "");
                } else {
                    item.put("\u5bfc\u5165\u7ed3\u679c", "\u5931\u8d25");
                    item.put("\u5931\u8d25\u539f\u56e0", map.get("impRemark") != null ? map.get("impRemark") : "");
                    exportData.add(item);
                }
            } else {
                item.put("\u5bfc\u5165\u7ed3\u679c", "\u5bfc\u5165\u5f02\u5e38");
                exportData.add(item);
            }
            LinkedHashMap copyItem = new LinkedHashMap(item);
            Data.add(copyItem);
        }
        this.uploadFile(exportData, rspBO);
        String fullFilePath = "";
        if ("OSS".equals(this.fileType)) {
            fullFilePath = this.preFilePath + rspBO.getFilePath();
        } else if ("FASTDFS".equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)rspBO.getFilePath());
            fullFilePath = this.exportFilePublicUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        }
        rspBO.setExportData(Data);
        rspBO.setFullFilePath(fullFilePath);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u521b\u5efaexcel \u6570\u636e\u6210\u529f!");
        return rspBO;
    }

    private void uploadFile(List<Map<String, Object>> data, UccExportImportResultsBusiRspBO rspBO) {
        SXSSFWorkbook workbook = ExcelUtils.createImportWorkbook(data, (String)"\u5546\u54c1\u4e0e\u7269\u6599\u5173\u7cfb\u5bfc\u5165\u5bfc\u5165");
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        String uploadPath = "ucc";
        String fileName = UUID.randomUUID() + ".xlsx";
        try {
            out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            byte[] buff = out.toByteArray();
            in = new ByteArrayInputStream(buff);
            String result = this.fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)in);
            rspBO.setFilePath(result);
            rspBO.setFileClientType(this.fileType);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new BusinessException("183004", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((Closeable)out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)in);
        IOUtils.closeQuietly((Closeable)out);
    }
}

