/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl.mq.consumer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.commodity.common.ability.bo.MaterialPropBO;
import com.tydic.commodity.common.busi.api.UccCallEbsMaterialDataGovernBusiService;
import com.tydic.commodity.common.busi.bo.UccCallEbsMaterialDataGovernBusiReqBO;
import com.tydic.commodity.dao.UccEbsMaterialMapper;
import com.tydic.commodity.po.UccEbsMaterialPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class EbsMaterialDataSyncConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(EbsMaterialDataSyncConsumer.class);
    @Autowired
    private UccCallEbsMaterialDataGovernBusiService uccCallEbsMaterialDataGovernBusiService;
    @Autowired
    private UccEbsMaterialMapper uccEbsMaterialMapper;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        String content = message.getContent();
        log.info("\u5355\u5143\u7269\u6599\u540c\u6b65\u81f3\u6570\u636e\u6cbb\u7406\u5e73\u53f0\uff0c\u6d88\u606f\u5165\u53c2:{}" + JSONObject.toJSONString((Object)content));
        try {
            List ebsMaterialIdList = JSONArray.parseArray((String)content, Long.class);
            if (!CollectionUtils.isEmpty((Collection)ebsMaterialIdList)) {
                for (Long ebsMaterialId : ebsMaterialIdList) {
                    UccCallEbsMaterialDataGovernBusiReqBO busiReqBO = this.buildSyncParam(ebsMaterialId);
                    if (ObjectUtils.isEmpty((Object)busiReqBO)) continue;
                    this.uccCallEbsMaterialDataGovernBusiService.callEbsMaterialDataGovern(busiReqBO);
                }
            }
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        catch (Exception e) {
            log.error("\u5546\u54c1\u4e2d\u5fc3\u7535\u529b\u7269\u6599\u6cbb\u7406\u6d88\u8d39\u8005\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return ProxyConsumerStatus.RECONSUME_LATER;
        }
    }

    private UccCallEbsMaterialDataGovernBusiReqBO buildSyncParam(Long ebsMaterialId) {
        UccEbsMaterialPO uccEbsMaterialPO = this.uccEbsMaterialMapper.selectByPrimaryKey(ebsMaterialId);
        if (ObjectUtils.isEmpty((Object)uccEbsMaterialPO)) {
            return null;
        }
        UccCallEbsMaterialDataGovernBusiReqBO busiReqBO = new UccCallEbsMaterialDataGovernBusiReqBO();
        busiReqBO.setSysCode(uccEbsMaterialPO.getSysCode());
        busiReqBO.setMaterialId(uccEbsMaterialPO.getEbsMaterialId());
        busiReqBO.setMaterialName(uccEbsMaterialPO.getEbsMaterialName());
        busiReqBO.setMaterialCode(uccEbsMaterialPO.getEbsMaterialCode());
        busiReqBO.setLongDesc(uccEbsMaterialPO.getEbsLongDesc());
        busiReqBO.setSysTenantId(uccEbsMaterialPO.getSysTenantId());
        busiReqBO.setSysTenantName(uccEbsMaterialPO.getSysTenantName());
        ArrayList<MaterialPropBO> specs = new ArrayList<MaterialPropBO>();
        if (StringUtils.isNotBlank((CharSequence)uccEbsMaterialPO.getEbsModel())) {
            specs.add(this.getMaterialPropBO("\u578b\u53f7", uccEbsMaterialPO.getEbsModel()));
        }
        if (StringUtils.isNotBlank((CharSequence)uccEbsMaterialPO.getEbsSpec())) {
            specs.add(this.getMaterialPropBO("\u89c4\u683c", uccEbsMaterialPO.getEbsSpec()));
        }
        if (StringUtils.isNotBlank((CharSequence)uccEbsMaterialPO.getEbsTexture())) {
            specs.add(this.getMaterialPropBO("\u6750\u8d28", uccEbsMaterialPO.getEbsTexture()));
        }
        if (StringUtils.isNotBlank((CharSequence)uccEbsMaterialPO.getEbsFigure())) {
            specs.add(this.getMaterialPropBO("\u56fe\u53f7", uccEbsMaterialPO.getEbsFigure()));
        }
        if (StringUtils.isNotBlank((CharSequence)uccEbsMaterialPO.getBrandName())) {
            specs.add(this.getMaterialPropBO("\u54c1\u724c", uccEbsMaterialPO.getBrandName()));
        }
        if (StringUtils.isNotBlank((CharSequence)uccEbsMaterialPO.getEbsMeasure())) {
            specs.add(this.getMaterialPropBO("\u8ba1\u91cf\u5355\u4f4d", uccEbsMaterialPO.getEbsMeasure()));
        }
        if (StringUtils.isNotBlank((CharSequence)uccEbsMaterialPO.getEbsExecutiveStandards())) {
            specs.add(this.getMaterialPropBO("\u6267\u884c\u6807\u51c6", uccEbsMaterialPO.getEbsExecutiveStandards()));
        }
        busiReqBO.setSpecs(specs);
        return busiReqBO;
    }

    public MaterialPropBO getMaterialPropBO(String propName, String propValue) {
        MaterialPropBO materialPropBO = new MaterialPropBO();
        materialPropBO.setPropName(propName);
        materialPropBO.setPropValue(propValue);
        return materialPropBO;
    }
}

