/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.busibase.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.ability.api.UccMaterialdetailsQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccEMdmMaterialDetailBO;
import com.tydic.commodity.common.ability.bo.UccEMdmMaterialPropBO;
import com.tydic.commodity.common.ability.bo.UccEMdmMaterialPropValueBO;
import com.tydic.commodity.common.ability.bo.UccMaterialdetailsQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccMaterialdetailsQryAbilityRspBO;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccEMdmMaterialPropValueMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccEMdmMaterialPropValuePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccMaterialdetailsQryAbilityService"})
public class UccMaterialdetailsQryAbilityServiceImpl
implements UccMaterialdetailsQryAbilityService {
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccEMdmMaterialPropValueMapper uccEMdmMaterialPropValueMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;

    @PostMapping(value={"getUccMaterialdetailsQry"})
    public UccMaterialdetailsQryAbilityRspBO getUccMaterialdetailsQry(@RequestBody UccMaterialdetailsQryAbilityReqBO reqBO) {
        DicDictionaryPo dictionaryPo;
        UccMaterialdetailsQryAbilityRspBO rspBO = new UccMaterialdetailsQryAbilityRspBO();
        if (reqBO == null || reqBO.getMaterialId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespCode("\u8bf7\u9009\u62e9\u7269\u6599\u660e\u7ec6");
            return rspBO;
        }
        UccEMdmMaterialPO po = this.uccEMdmMaterialMapper.selectByPrimaryKey(reqBO.getMaterialId());
        if (po == null) {
            rspBO.setRespCode("0000");
            rspBO.setRespCode("\u6210\u529f");
            return rspBO;
        }
        UccEMdmMaterialDetailBO bo = (UccEMdmMaterialDetailBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)po), UccEMdmMaterialDetailBO.class);
        if (bo.getBrandId() != null) {
            UccBrandDealPO temp = new UccBrandDealPO();
            temp.setBrandId(bo.getBrandId());
            UccBrandDealPO uccBrandDealPO = this.uccBrandDealMapper.selectById(temp);
            if (uccBrandDealPO != null) {
                bo.setBrandName(uccBrandDealPO.getBrandName());
            }
        }
        if (bo.getFreezeFlag() != null && (dictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(bo.getFreezeFlag().toString(), "UCC_E_MDM_MATERIAL_FREEZE_FLAG")) != null) {
            bo.setFreezeFlagDesc(dictionaryPo.getTitle());
        }
        if (bo.getSource() != null && (dictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(bo.getSource().toString(), "UCC_E_MDM_MATERIAL_SOURCE")) != null) {
            bo.setSourceDesc(dictionaryPo.getTitle());
        }
        if (bo.getIsDelete() != null && (dictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(bo.getIsDelete().toString(), "UCC_E_MDM_MATERIAL_IS_DELETE")) != null) {
            bo.setIsDeleteDesc(dictionaryPo.getTitle());
        }
        rspBO.setMaterialInfo(bo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UccEMdmMaterialPropValuePO valuePO = new UccEMdmMaterialPropValuePO();
        valuePO.setMaterialId(reqBO.getMaterialId());
        List poList = this.uccEMdmMaterialPropValueMapper.qyeryMaterialPropValue(valuePO);
        if (!CollectionUtils.isEmpty((Collection)poList)) {
            Map<Long, List<UccEMdmMaterialPropValuePO>> valueMap = poList.stream().collect(Collectors.groupingBy(UccEMdmMaterialPropValuePO::getPropDefId));
            Iterator<Long> iterator = valueMap.keySet().iterator();
            ArrayList<UccEMdmMaterialPropBO> props = new ArrayList<UccEMdmMaterialPropBO>();
            while (iterator.hasNext()) {
                UccEMdmMaterialPropBO uccEMdmMaterialPropBO = new UccEMdmMaterialPropBO();
                Long propDefId = iterator.next();
                List<UccEMdmMaterialPropValuePO> valuePOList = valueMap.get(propDefId);
                ArrayList propValueInfo = new ArrayList();
                BeanUtils.copyProperties((Object)valuePOList.get(0), (Object)uccEMdmMaterialPropBO);
                valuePOList.stream().forEach(s -> {
                    UccEMdmMaterialPropValueBO uccEMdmMaterialPropValueBO = new UccEMdmMaterialPropValueBO();
                    uccEMdmMaterialPropValueBO.setPropValueId(s.getPropValueId());
                    uccEMdmMaterialPropValueBO.setPropValue(s.getPropValue());
                    propValueInfo.add(uccEMdmMaterialPropValueBO);
                });
                uccEMdmMaterialPropBO.setPropValueInfo(propValueInfo);
                props.add(uccEMdmMaterialPropBO);
            }
            bo.setProps(props);
        }
        return rspBO;
    }
}

