/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SelfRunSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.common.ability.api.UccSkuLimitOrderAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuLimitOrderAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuLimitOrderAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccSkuLimitOrderBusiService;
import com.tydic.commodity.common.busi.bo.UccSkuLimitOrderBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccSkuLimitOrderBusiRspBO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuLimitOrderAbilityService"})
public class UccSkuLimitOrderAbilityServiceImpl
implements UccSkuLimitOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuLimitOrderAbilityServiceImpl.class);
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSkuLimitOrderBusiService uccSkuLimitOrderBusiService;

    @PostMapping(value={"limitOrder"})
    public UccSkuLimitOrderAbilityRspBO limitOrder(@RequestBody UccSkuLimitOrderAbilityReqBO reqBO) {
        UccSkuLimitOrderAbilityRspBO rspBO = new UccSkuLimitOrderAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5355\u54c1id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getOperType() == null) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("operType\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getOperType() != 1 && reqBO.getOperType() != 2) {
            rspBO.setRespCode("0002");
            rspBO.setRespDesc("operType\u4e0d\u6b63\u786e");
            return rspBO;
        }
        if (StringUtil.isEmpty((String)reqBO.getReason())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        UccSkuLimitOrderBusiReqBO busiReqBO = new UccSkuLimitOrderBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        UccSkuLimitOrderBusiRspBO busiRspBO = this.uccSkuLimitOrderBusiService.limitOrder(busiReqBO);
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)rspBO);
        if (busiRspBO.getMapSku() != null) {
            for (Long supplierShopId : busiRspBO.getMapSku().keySet()) {
                List skus = busiRspBO.getMapSku().get(supplierShopId).stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skus));
                syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                try {
                    log.info("\u5546\u54c1\u4e2d\u5fc3\u5355\u54c1\u624b\u52a8\u9650\u5236\u4e0b\u5355\u901a\u7528API es\u540c\u6b65\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                }
            }
        }
        return rspBO;
    }
}

