/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.UccCommodityPicBO;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.busi.api.UccSpuImagevalidationBusiService;
import com.tydic.commodity.common.busi.bo.UccSpuImagevalidationBO;
import com.tydic.commodity.common.busi.bo.UccSpuImagevalidationBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccSpuImagevalidationBusiRspBO;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.po.UccCommodityPicPo;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuPicPo;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccSpuImagevalidationBusiServiceImpl
implements UccSpuImagevalidationBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSpuImagevalidationBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();

    @Override
    public UccSpuImagevalidationBusiRspBO dealUccSpuImagevalidation(UccSpuImagevalidationBusiReqBO reqBO) {
        List<UccSkuPicPo> uccCommodityPicPos;
        ArrayList<UccSkuPicPo> arraySpuPic;
        Map spuMap;
        UccSpuImagevalidationBusiRspBO rspBO = new UccSpuImagevalidationBusiRspBO();
        if (CollectionUtils.isEmpty(reqBO.getImagevalidationBOList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u8f93\u5165\u89c4\u5219\u56fe\u7247\u6821\u9a8c\u4fe1\u606f");
            return rspBO;
        }
        List codeList = reqBO.getImagevalidationBOList().stream().map(UccSpuImagevalidationBO::getCode).collect(Collectors.toList());
        List uccCommodityPoList = this.uccCommodityMapper.queryByCommodityCodeLists(codeList);
        List<Object> spuCode = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)uccCommodityPoList)) {
            spuCode = uccCommodityPoList.stream().map(UccCommodityPo::getCommodityCode).collect(Collectors.toList());
            codeList.remove(spuCode);
        }
        List poList = new ArrayList();
        if (!CollectionUtils.isEmpty(codeList)) {
            poList = this.uccSkuMapper.querySkuByCode(codeList);
        }
        if (!CollectionUtils.isEmpty((Collection)uccCommodityPoList)) {
            spuMap = uccCommodityPoList.stream().collect(Collectors.toMap(UccCommodityPo::getCommodityCode, Function.identity()));
            arraySpuPic = new ArrayList<UccSkuPicPo>();
            uccCommodityPicPos = null;
            HashMap spuPicMapInfo = new HashMap();
            for (UccSpuImagevalidationBO each : reqBO.getImagevalidationBOList()) {
                if (!spuMap.containsKey(each.getCode())) continue;
                uccCommodityPicPos = new ArrayList();
                uccCommodityPicPos = JSONObject.parseArray((String)JSONObject.toJSONString(each.getPicBOS()), UccCommodityPicPo.class);
                uccCommodityPicPos.stream().forEach(a -> {
                    a.setCommodityId(((UccCommodityPo)spuMap.get(each.getCode())).getCommodityId());
                    a.setSupplierShopId(((UccCommodityPo)spuMap.get(each.getCode())).getSupplierShopId());
                    a.setCommodityPicId(Long.valueOf(this.uccBatchSequence.nextId()));
                    a.setSysTenantId(reqBO.getSysTenantId());
                    a.setSysTenantName(reqBO.getSysTenantName());
                    if (spuPicMapInfo.containsKey(a.getCommodityPicType())) {
                        ((List)spuPicMapInfo.get(a.getCommodityPicType())).add(((UccCommodityPo)spuMap.get(each.getCode())).getCommodityId());
                    } else {
                        spuPicMapInfo.put(a.getCommodityPicType(), new ArrayList<Long>(Arrays.asList(((UccCommodityPo)spuMap.get(each.getCode())).getCommodityId())));
                    }
                });
                arraySpuPic.addAll(uccCommodityPicPos);
            }
            if (!spuPicMapInfo.isEmpty()) {
                for (Integer picorderType : spuPicMapInfo.keySet()) {
                    try {
                        this.uccCommodityPicMapper.batchDelete((List)spuPicMapInfo.get(picorderType), picorderType);
                    }
                    catch (Exception e) {
                        log.error("\u5546\u54c1\u56fe\u7247\u5220\u9664\u5f02\u5e38");
                        throw new BusinessException("8888", "\u56fe\u7247\u5220\u9664\u5931\u8d25" + e.getMessage());
                    }
                }
            }
            try {
                this.uccCommodityPicMapper.batchInsert(arraySpuPic);
            }
            catch (Exception e) {
                log.error("\u5546\u54c1\u56fe\u7247\u65b0\u589e\u5f02\u5e38");
                throw new BusinessException("8888", "\u5546\u54c1\u56fe\u7247\u65b0\u589e\u5f02\u5e38" + e.getMessage());
            }
        }
        if (!CollectionUtils.isEmpty(poList)) {
            spuMap = poList.stream().collect(Collectors.toMap(UccSkuPo::getSkuCode, Function.identity()));
            arraySpuPic = new ArrayList();
            uccCommodityPicPos = null;
            HashMap<Integer, ArrayList<Long>> skuPicMapInfo = new HashMap<Integer, ArrayList<Long>>();
            for (UccSpuImagevalidationBO each : reqBO.getImagevalidationBOList()) {
                if (!spuMap.containsKey(each.getCode())) continue;
                uccCommodityPicPos = new ArrayList();
                UccSkuPicPo uccSkuPicPo = null;
                for (UccCommodityPicBO pic : each.getPicBOS()) {
                    uccSkuPicPo = new UccSkuPicPo();
                    uccSkuPicPo.setPicOrder(pic.getPicOrder());
                    uccSkuPicPo.setSkuPicId(Long.valueOf(this.uccBatchSequence.nextId()));
                    uccSkuPicPo.setSkuId(((UccSkuPo)spuMap.get(each.getCode())).getSkuId());
                    uccSkuPicPo.setSkuPicUrl(pic.getCommodityPicUrl());
                    uccSkuPicPo.setCommodityPicType(pic.getCommodityPicType());
                    uccSkuPicPo.setSupplierShopId(((UccSkuPo)spuMap.get(each.getCode())).getSupplierShopId());
                    uccSkuPicPo.setSysTenantId(reqBO.getSysTenantId());
                    uccSkuPicPo.setSysTenantName(reqBO.getSysTenantName());
                    uccCommodityPicPos.add(uccSkuPicPo);
                    if (skuPicMapInfo.containsKey(pic.getCommodityPicType())) {
                        ((List)skuPicMapInfo.get(pic.getCommodityPicType())).add(((UccSkuPo)spuMap.get(each.getCode())).getSkuId());
                        continue;
                    }
                    skuPicMapInfo.put(pic.getCommodityPicType(), new ArrayList<Long>(Arrays.asList(((UccSkuPo)spuMap.get(each.getCode())).getSkuId())));
                }
                arraySpuPic.addAll(uccCommodityPicPos);
            }
            if (!skuPicMapInfo.isEmpty()) {
                for (Integer picorderType : skuPicMapInfo.keySet()) {
                    try {
                        this.uccSkuPicMapper.batchDelete((List)skuPicMapInfo.get(picorderType), picorderType);
                    }
                    catch (Exception e) {
                        log.error("\u5355\u54c1\u56fe\u7247\u5220\u9664\u5f02\u5e38");
                        throw new BusinessException("8888", "\u5355\u54c1\u5220\u9664\u5931\u8d25" + e.getMessage());
                    }
                }
            }
            try {
                this.uccSkuPicMapper.batchInsert(arraySpuPic);
            }
            catch (Exception e) {
                log.error("\u5546\u54c1\u56fe\u7247\u65b0\u589e\u5f02\u5e38");
                throw new BusinessException("8888", "\u5546\u54c1\u56fe\u7247\u65b0\u589e\u5f02\u5e38" + e.getMessage());
            }
        }
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>();
        if (!CollectionUtils.isEmpty((Collection)uccCommodityPoList)) {
            for (UccCommodityPo each : uccCommodityPoList) {
                if (result.containsKey(each.getSupplierShopId())) {
                    ((List)result.get(each.getSupplierShopId())).add(each.getCommodityId());
                    continue;
                }
                result.put(each.getSupplierShopId(), Arrays.asList(each.getCommodityId()));
            }
        }
        if (!CollectionUtils.isEmpty(poList)) {
            for (UccCommodityPo each : poList) {
                if (result.containsKey(each.getSupplierShopId())) {
                    ((List)result.get(each.getSupplierShopId())).add(each.getCommodityId());
                    continue;
                }
                result.put(each.getSupplierShopId(), Arrays.asList(each.getCommodityId()));
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setResult(result);
        return rspBO;
    }
}

