/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.busibase.comb.bo.UccCombEsCommodityBo;
import com.tydic.commodity.common.ability.api.UccApplyForSaleSkuListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccApplyForSaleSkuListBO;
import com.tydic.commodity.common.ability.bo.UccApplyForSaleSkuListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccApplyForSaleSkuListQryAbilityRspBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccApplyForSaleSkuListQryAbilityService"})
public class UccApplyForSaleSkuListQryAbilityServiceImpl
implements UccApplyForSaleSkuListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccApplyForSaleSkuListQryAbilityServiceImpl.class);
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;

    @PostMapping(value={"getSkuInfoList"})
    public UccApplyForSaleSkuListQryAbilityRspBO getSkuInfoList(@RequestBody UccApplyForSaleSkuListQryAbilityReqBO reqBO) {
        UccApplyForSaleSkuListQryAbilityRspBO rspBO = new UccApplyForSaleSkuListQryAbilityRspBO();
        if (reqBO.getCommodityTypeId() == null) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5546\u54c1\u7c7b\u578bID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getOrgId() == null) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("orgId\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        BoolQueryBuilder extBoolQueryBuilder = this.buildEsSql(reqBO);
        String queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder);
        String result = this.searchInfo(queryString);
        if (StringUtils.isEmpty((Object)result)) {
            rspBO.setTotal(0);
            rspBO.setRespCode("0000");
            rspBO.setRecordsTotal(0);
            rspBO.setRows(new ArrayList());
            return rspBO;
        }
        rspBO = this.dealSearchData(result, reqBO);
        return rspBO;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private BoolQueryBuilder buildEsSql(UccApplyForSaleSkuListQryAbilityReqBO reqBo) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_id", (Object)reqBo.getCommodityTypeId()));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_status", (int)3));
        if (!StringUtils.isEmpty((Object)reqBo.getSkuCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_code", (String)reqBo.getSkuCode()));
        }
        if (reqBo.getSkuSource() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)reqBo.getSkuSource()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuName())) {
            WildcardQueryBuilder wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_name.keyword", (String)("*" + reqBo.getSkuName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        return boolQueryBuilder;
    }

    private String excuteEsSql(UccApplyForSaleSkuListQryAbilityReqBO reqBo, BoolQueryBuilder extBoolQueryBuilder) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("track_total_hits", (Object)true);
        queryJson.put("size", (Object)reqBo.getPageSize());
        queryJson.put("from", (Object)(reqBo.getPageSize() * (reqBo.getPageNo() - 1)));
        String queryString = null;
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        return queryJson.toString();
    }

    private UccApplyForSaleSkuListQryAbilityRspBO dealSearchData(String result, UccApplyForSaleSkuListQryAbilityReqBO reqBo) {
        UccApplyForSaleSkuListQryAbilityRspBO rspBo = new UccApplyForSaleSkuListQryAbilityRspBO();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = 0;
        try {
            total = hitsObj.getInteger("total");
        }
        catch (Exception e) {
            JSONObject totalObj = (JSONObject)hitsObj.get((Object)"total");
            total = totalObj.getInteger("value");
        }
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        }
        ArrayList<UccCombEsCommodityBo> commodityModels = new ArrayList<UccCombEsCommodityBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                UccCombEsCommodityBo commodity = new UccCombEsCommodityBo();
                try {
                    commodity = (UccCombEsCommodityBo)JSON.toJavaObject((JSON)data, UccCombEsCommodityBo.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                    if (!skuIdSet.contains(commodity.getSku_id())) {
                        commodityModels.add(commodity);
                    }
                    skuIdSet.add(commodity.getSku_id());
                }
            }
        }
        rspBo = this.copyData(commodityModels, total, reqBo.getPageNo(), reqBo.getPageSize());
        return rspBo;
    }

    private UccApplyForSaleSkuListQryAbilityRspBO copyData(List<UccCombEsCommodityBo> commodityModels, Integer totalNum, int pageNo, int pageSize) {
        UccApplyForSaleSkuListQryAbilityRspBO rspBo = new UccApplyForSaleSkuListQryAbilityRspBO();
        ArrayList<UccApplyForSaleSkuListBO> uccApplyForSaleSkuListBOS = new ArrayList<UccApplyForSaleSkuListBO>();
        if (totalNum != null) {
            rspBo.setPageNo(pageNo);
            int size = pageSize;
            int totalPage = 0;
            int add = 0;
            Integer total = 0;
            totalPage = totalNum / size;
            add = totalNum % size == 0 ? 0 : 1;
            total = totalNum;
            rspBo.setTotal(totalPage + add);
            rspBo.setRecordsTotal(total.intValue());
            if (!CollectionUtils.isEmpty(commodityModels)) {
                for (UccCombEsCommodityBo cnncEsCommodityBo : commodityModels) {
                    UccApplyForSaleSkuListBO uccApplyForSaleSkuListBO = new UccApplyForSaleSkuListBO();
                    uccApplyForSaleSkuListBO.setSkuId(Long.valueOf(cnncEsCommodityBo.getSku_id()));
                    uccApplyForSaleSkuListBO.setSupplierShopId(cnncEsCommodityBo.getSupplier_shop_id());
                    uccApplyForSaleSkuListBO.setSkuCode(cnncEsCommodityBo.getSku_code());
                    uccApplyForSaleSkuListBO.setSkuName(cnncEsCommodityBo.getSku_name());
                    uccApplyForSaleSkuListBO.setSkuSource(Integer.valueOf(cnncEsCommodityBo.getSku_source()));
                    uccApplyForSaleSkuListBO.setCommodityTypeId(cnncEsCommodityBo.getType_id());
                    uccApplyForSaleSkuListBO.setCommodityTypeName(cnncEsCommodityBo.getType_name());
                    uccApplyForSaleSkuListBO.setBrandId(Long.valueOf(cnncEsCommodityBo.getBrand_id()));
                    uccApplyForSaleSkuListBO.setBrandName(cnncEsCommodityBo.getBrand_name());
                    uccApplyForSaleSkuListBO.setModel(cnncEsCommodityBo.getModel());
                    uccApplyForSaleSkuListBO.setSpec(cnncEsCommodityBo.getSpec());
                    uccApplyForSaleSkuListBOS.add(uccApplyForSaleSkuListBO);
                }
            }
            rspBo.setRows(uccApplyForSaleSkuListBOS);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

