/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccAutoSellToDownAbilityService;
import com.tydic.commodity.common.ability.bo.UccAutoSellToDownAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccAutoSellToDownBusiService;
import com.tydic.commodity.common.busi.bo.UccAutoSellToDownBusiReqBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.smcsdk.api.SmcsdkQryStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccAutoSellToDownAbilityService"})
public class UccAutoSellToDownAbilityServiceImpl
implements UccAutoSellToDownAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAutoSellToDownAbilityServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccAutoSellToDownBusiService uccAutoSellToDownBusiService;
    @Autowired
    private SmcsdkQryStockNumService smcsdkQryStockNumService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"autoSellToDown"})
    public UccAutoSellToDownAbilityRspBO autoSellToDown() {
        UccAutoSellToDownAbilityRspBO rspBO = new UccAutoSellToDownAbilityRspBO();
        List uccSkuPos = this.uccSkuMapper.selectSkuIsSell();
        if (CollectionUtils.isEmpty((Collection)uccSkuPos)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        ArrayList<UccSkuPo> newSkuList = new ArrayList<UccSkuPo>();
        SmcsdkQryStockNumReqBO smcsdkQryStockNumReqBO = new SmcsdkQryStockNumReqBO();
        smcsdkQryStockNumReqBO.setSkuIds(uccSkuPos.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList()));
        SmcsdkQryStockNumRspBO smcsdkQryStockNumRspBO = this.smcsdkQryStockNumService.qryStockNum(smcsdkQryStockNumReqBO);
        log.info("\u7b80\u7248\u5e93\u5b58\uff1a" + JSONObject.toJSONString((Object)smcsdkQryStockNumRspBO));
        if ("0000".equals(smcsdkQryStockNumRspBO.getRespCode())) {
            Map getMap = smcsdkQryStockNumRspBO.getSkuStockNumMap();
            if (getMap != null) {
                for (UccSkuPo each : uccSkuPos) {
                    Long stock;
                    if (!getMap.containsKey(each.getSkuId()) || (stock = (Long)getMap.get(each.getSkuId())) == null || stock > 0L) continue;
                    newSkuList.add(each);
                }
            }
        } else {
            log.error("\u8c03\u7528\u7b80\u7248\u5e93\u5b58\u67e5\u8be2\u5931\u8d25" + smcsdkQryStockNumRspBO.getRespDesc());
            throw new BusinessException(RspConstantEnums.SMCSDKOPERATESTOCK_QRY_FAIL.code(), "\u8c03\u7528\u7b80\u7248\u5e93\u5b58\u67e5\u8be2\u5931\u8d25" + smcsdkQryStockNumRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty(newSkuList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        UccAutoSellToDownBusiReqBO uccAutoSellToDownBusiReqBO = new UccAutoSellToDownBusiReqBO();
        uccAutoSellToDownBusiReqBO.setUccSkuPos(newSkuList);
        rspBO = this.uccAutoSellToDownBusiService.autoSellToDown(uccAutoSellToDownBusiReqBO);
        if (!CollectionUtils.isEmpty(newSkuList)) {
            Map<Long, List<UccSkuPo>> mapSku = newSkuList.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
            for (Long supplierShopId : mapSku.keySet()) {
                List skus = mapSku.get(supplierShopId).stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skus));
                syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                }
            }
        }
        return rspBO;
    }
}

