/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.commodity.common.ability.api.UccBuildExcelImportChangeMaterialTemplateService;
import com.tydic.commodity.common.ability.bo.UccBuildExcelImportChangeMaterialTemplateReqBO;
import com.tydic.commodity.common.ability.bo.UccBuildExcelImportChangeMaterialTemplateRspBO;
import com.tydic.commodity.dao.UccDicDictionaryMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccBuildExcelImportChangeMaterialTemplateService"})
public class UccBuildExcelImportChangeMaterialTemplateServiceImpl
implements UccBuildExcelImportChangeMaterialTemplateService {
    private static final Logger log = LoggerFactory.getLogger(UccBuildExcelImportChangeMaterialTemplateServiceImpl.class);
    @Autowired
    private UccDicDictionaryMapper uccDicDictionaryMapper;
    @Autowired
    private FileClient fileClient;
    private static final String EXCEL_XLS = "xls";
    private static final String EXCEL_XLSX = "xlsx";
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    @PostMapping(value={"buildExcelImportChangeMaterialTemplate"})
    public UccBuildExcelImportChangeMaterialTemplateRspBO buildExcelImportChangeMaterialTemplate(@RequestBody UccBuildExcelImportChangeMaterialTemplateReqBO reqBO) {
        Long currentSbuId;
        UccBuildExcelImportChangeMaterialTemplateRspBO rspBO = new UccBuildExcelImportChangeMaterialTemplateRspBO();
        List ebsMaterialOrg = this.uccDicDictionaryMapper.selectByPCodeAndSysTenant("EBS_MATERIAL_ORG", reqBO.getSysTenantId());
        if (ebsMaterialOrg == null || ebsMaterialOrg.isEmpty()) {
            throw new ZTBusinessException("\u67e5\u8be2\u4e1a\u52a1\u5355\u4f4d\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u5b57\u5178\u914d\u7f6e\u662f\u5426\u6b63\u786e");
        }
        Map<String, String> allSysCodeNameMap = ebsMaterialOrg.stream().collect(Collectors.toMap(DicDictionaryPo::getCode, DicDictionaryPo::getTitle, (oldVal, newVal) -> newVal));
        Map<String, String> allSysCode = ebsMaterialOrg.stream().collect(Collectors.toMap(DicDictionaryPo::getDescrip, DicDictionaryPo::getCode, (oldVal, newVal) -> newVal));
        HashMap<String, String> permissionSysCode = new HashMap<String, String>(allSysCode);
        if (!"0".equals(reqBO.getIsProfessionalOrgExt()) && (currentSbuId = reqBO.getSbuId()) != null) {
            permissionSysCode.keySet().removeIf(key -> !key.equals(currentSbuId.toString()));
        }
        allSysCodeNameMap.keySet().removeIf(key -> !permissionSysCode.containsValue(key));
        try {
            String path = reqBO.getImportTemplateUrl();
            URL url = new URL(path);
            try (InputStream inputStream = url.openStream();){
                UccBuildExcelImportChangeMaterialTemplateServiceImpl.checkExcelVaild(path);
                Workbook workbook = UccBuildExcelImportChangeMaterialTemplateServiceImpl.getWorkbok(path, inputStream);
                Sheet sheet = workbook.getSheetAt(1);
                this.clearSheet(sheet);
                this.writeSheetData(sheet, allSysCodeNameMap);
                byte[] excelBytes = this.writeWorkbookToBytes(workbook);
                String result = this.uploadExcelFile(excelBytes, this.fileClient);
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)result);
                log.info("\u6587\u4ef6\u4fe1\u606f", (Object)JSON.toJSONString((Object)fastdfsFileInfo));
                log.info("\u6587\u4ef6\u5730\u5740", (Object)this.fastdfsDownloadUrl);
                String fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                rspBO.setImportTemplateUrl(fileUrl);
            }
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff1a" + e.getMessage());
        }
        return rspBO;
    }

    private static void checkExcelVaild(String filePath) throws Exception {
        if (filePath == null) {
            return;
        }
        String extString = filePath.substring(filePath.lastIndexOf(".") + 1);
        if (!EXCEL_XLS.equals(extString) && !EXCEL_XLSX.equals(extString)) {
            throw new Exception("\u6587\u4ef6\u4e0d\u662fExcel");
        }
    }

    private void clearSheet(Sheet sheet) {
        int lastRowNum = sheet.getLastRowNum();
        for (int i = 0; i <= lastRowNum; ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            sheet.removeRow(row);
        }
    }

    private void writeSheetData(Sheet sheet, Map<String, String> data) {
        ArrayList<List<String>> newData = new ArrayList<List<String>>();
        newData.add(Arrays.asList("\u4e1a\u52a1\u5355\u5143\u540d\u79f0", "\u4e1a\u52a1\u5355\u5143\u7f16\u7801"));
        data.forEach((code, name) -> newData.add(Arrays.asList(name, code)));
        int rowNum = 0;
        for (List list : newData) {
            Row newRow = sheet.createRow(rowNum++);
            int cellNum = 0;
            for (String cellData : list) {
                newRow.createCell(cellNum++).setCellValue(cellData);
            }
        }
    }

    private byte[] writeWorkbookToBytes(Workbook workbook) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            workbook.write((OutputStream)out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    private String uploadExcelFile(byte[] excelBytes, FileClient fileClient) throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(excelBytes);){
            String uploadPath = "ucc";
            String fileName = UUID.randomUUID() + ".xlsx";
            String string = fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)in);
            return string;
        }
    }

    private static Workbook getWorkbok(String filePath, InputStream inputStream) throws IOException {
        if (filePath == null) {
            return null;
        }
        String extString = filePath.substring(filePath.lastIndexOf(".") + 1);
        if (!EXCEL_XLS.equals(extString) && !EXCEL_XLSX.equals(extString)) {
            throw new IOException("\u6587\u4ef6\u4e0d\u662fExcel");
        }
        HSSFWorkbook wb = null;
        if (EXCEL_XLS.equals(extString)) {
            wb = new HSSFWorkbook(inputStream);
        } else if (EXCEL_XLSX.equals(extString)) {
            wb = new XSSFWorkbook(inputStream);
        }
        return wb;
    }
}

