/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccCalculateMatchDegreeAbilityService;
import com.tydic.commodity.common.ability.bo.UccCalculateMatchDegreeAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccCalculateMatchDegreeAbilityRspBO;
import com.tydic.commodity.common.comb.bo.UccCalculateMatchDegreeCombReqBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccCalculateMatchDegreeAbilityService"})
public class UccCalculateMatchDegreeAbilityServiceImpl
implements UccCalculateMatchDegreeAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccCalculateMatchDegreeAbilityServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Value(value="${UCC_CALCULATE_MATCH_DEGREE_TOPIC:UCC_CALCULATE_MATCH_DEGREE_TOPIC}")
    private String topic;
    @Resource(name="lmBatchSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmBatchSyncCommodityMqServiceProvider;

    @PostMapping(value={"calculateMatchDegree"})
    public UccCalculateMatchDegreeAbilityRspBO calculateMatchDegree(@RequestBody UccCalculateMatchDegreeAbilityReqBO reqBO) {
        UccCalculateMatchDegreeAbilityRspBO abilityRspBO = new UccCalculateMatchDegreeAbilityRspBO();
        Integer size = 2000;
        abilityRspBO.setRespCode("0000");
        Page page = new Page(1, size.intValue());
        List poList = this.uccSkuMapper.getMatchDegreeList(reqBO.getStandardCommodityIds(), page);
        if (page.getTotalCount() < size) {
            this.sendMq(poList);
            return abilityRspBO;
        }
        int count = 0;
        do {
            page.setPageSize(size.intValue());
            page.setPageNo(++count);
            poList = this.uccSkuMapper.getMatchDegreeList(reqBO.getStandardCommodityIds(), page);
            this.sendMq(poList);
        } while (!CollectionUtils.isEmpty((Collection)poList) && size.compareTo(poList.size()) <= 0);
        return abilityRspBO;
    }

    private void sendMq(List<UccSkuPo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(e -> {
            UccCalculateMatchDegreeCombReqBO commodityToEsReqBO = new UccCalculateMatchDegreeCombReqBO();
            commodityToEsReqBO.setSkuId(e.getSkuId());
            commodityToEsReqBO.setCommodityId(e.getCommodityId());
            commodityToEsReqBO.setSupplierShopId(e.getSupplierShopId());
            commodityToEsReqBO.setSysTenantId(e.getSysTenantId());
            commodityToEsReqBO.setSysTenantName(e.getSysTenantName());
            commodityToEsReqBO.setStandardCommodityId(e.getStandardCommodityId());
            try {
                this.lmBatchSyncCommodityMqServiceProvider.send(new ProxyMessage(this.topic, "*", JSON.toJSONString((Object)commodityToEsReqBO)));
            }
            catch (Exception ea) {
                log.error("\u540c\u6b65\u5546\u54c1\u6570\u636e\u5931\u8d25 \uff1a" + ea);
                throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
            }
        });
    }
}

