/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.ExcelNewUtils;
import com.tydic.commodity.common.ability.api.UccEbsMaterialChangeExcelImportAbilityService;
import com.tydic.commodity.common.ability.bo.UccEbsMaterialChangeBO;
import com.tydic.commodity.common.ability.bo.UccEbsMaterialChangeExcelImportAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccEbsMaterialExcelImportAbilityReqBO;
import com.tydic.commodity.dao.UccDicDictionaryMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccEbsMaterialChangeImportMapper;
import com.tydic.commodity.dao.UccEbsMaterialMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccEbsMaterialChangeImportPO;
import com.tydic.commodity.po.UccEbsMaterialPO;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.umc.general.ability.api.UmcOrgQryListByTypeAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccEbsMaterialChangeExcelImportAbilityService"})
public class UccEbsMaterialChangeExcelImportAbilityServiceImpl
implements UccEbsMaterialChangeExcelImportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccEbsMaterialChangeExcelImportAbilityServiceImpl.class);
    @Autowired
    private UccEbsMaterialMapper uccEbsMaterialMapper;
    @Autowired
    private UccEbsMaterialChangeImportMapper uccEbsMaterialChangeImportMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UmcOrgQryListByTypeAbilityService umcOrgQryListByTypeAbilityService;
    private Sequence sequence = Sequence.getInstance();
    @Autowired
    private UccDicDictionaryMapper uccDicDictionaryMapper;

    @PostMapping(value={"dealExcelImportChangeMaterial"})
    public UccEbsMaterialChangeExcelImportAbilityRspBO dealExcelImportChangeMaterial(@RequestBody UccEbsMaterialExcelImportAbilityReqBO reqBO) {
        Long currentSbuId;
        UccEbsMaterialChangeExcelImportAbilityRspBO rspBO = new UccEbsMaterialChangeExcelImportAbilityRspBO();
        ArrayList<UccEbsMaterialChangeBO> uccEbsMaterialChangeBOS = new ArrayList<UccEbsMaterialChangeBO>();
        List<Object> firstSheet = new ArrayList();
        List<Object> secondSheet = new ArrayList();
        List<String> head = null;
        List ebsMaterialOrg = this.uccDicDictionaryMapper.selectByPCodeAndSysTenant("EBS_MATERIAL_ORG", reqBO.getSysTenantId());
        if (ebsMaterialOrg == null || ebsMaterialOrg.isEmpty()) {
            throw new ZTBusinessException("\u67e5\u8be2\u4e1a\u52a1\u5355\u4f4d\u6570\u636e\u6570\u636e\u5f02\u5e38!");
        }
        Map<String, String> allSysCodeNameMap = ebsMaterialOrg.stream().collect(Collectors.toMap(DicDictionaryPo::getCode, DicDictionaryPo::getTitle, (key1, key2) -> key1));
        Map<String, String> allSysCode = ebsMaterialOrg.stream().collect(Collectors.toMap(DicDictionaryPo::getDescrip, DicDictionaryPo::getCode, (key1, key2) -> key1));
        HashMap<String, String> permissionSysCode = new HashMap<String, String>(allSysCode);
        if (!Objects.equals(reqBO.getIsProfessionalOrgExt(), "0") && (currentSbuId = reqBO.getSbuId()) != null) {
            permissionSysCode.keySet().removeIf(key -> !key.equals(String.valueOf(currentSbuId)));
        }
        long timestamp = System.currentTimeMillis();
        int random = new Random().nextInt(90) + 10;
        long lotNum = Long.parseLong(timestamp + String.valueOf(random));
        try {
            List<List<String>> excel = this.dealEcxel(reqBO.getUrl(), 1, 0);
            head = excel.get(0);
            firstSheet = this.dealEcxel(reqBO.getUrl(), 2, 0);
            secondSheet = this.dealEcxel(reqBO.getUrl(), 2, 1);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
        if (!CollectionUtils.isEmpty(firstSheet)) {
            Integer len = head.size();
            try {
                if (CollectionUtils.isNotEmpty(firstSheet)) {
                    for (List list : firstSheet) {
                        String error = "";
                        this.fill(list, len);
                        UccEbsMaterialChangeBO uccEbsMaterialChangeBO = new UccEbsMaterialChangeBO();
                        uccEbsMaterialChangeBO.setStatus(Integer.valueOf(1));
                        int i = 0;
                        int n = ++i;
                        ++i;
                        String sysCode = (String)list.get(n);
                        if (StringUtils.isEmpty((Object)sysCode)) {
                            error = "\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a!";
                            uccEbsMaterialChangeBO.setErrorParam("sysCode");
                        } else {
                            if (!allSysCode.containsValue(sysCode) && StringUtils.isEmpty((Object)error)) {
                                error = sysCode + "\u4e0d\u6b63\u786e!";
                                uccEbsMaterialChangeBO.setErrorParam("sysCode");
                            }
                            if (!permissionSysCode.containsValue(sysCode) && StringUtils.isEmpty((Object)error)) {
                                error = "\u65e0\u6743\u5904\u7406'" + sysCode + "'\u7269\u6599\u4fe1\u606f\u6570\u636e!";
                                uccEbsMaterialChangeBO.setErrorParam("sysCode");
                            }
                            uccEbsMaterialChangeBO.setSysCode(sysCode);
                            uccEbsMaterialChangeBO.setSysName(allSysCodeNameMap.get(sysCode));
                        }
                        String ebsMaterialCode = this.convertIfScientific((String)list.get(i++));
                        String ebsMaterialName = (String)list.get(i++);
                        if (StringUtils.isEmpty((Object)ebsMaterialCode) && StringUtils.isEmpty((Object)error)) {
                            error = "\u4e1a\u52a1\u5355\u5143\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!";
                            uccEbsMaterialChangeBO.setErrorParam("ebsMaterialCode");
                        }
                        if (!StringUtils.isEmpty((Object)ebsMaterialCode)) {
                            List<UccEbsMaterialPO> uccEbsMaterialPOList = this.checkEbsMaterialCode(sysCode, ebsMaterialCode, reqBO.getSysTenantId());
                            UccEbsMaterialPO uccEbsMaterialPO = null;
                            if (CollectionUtils.isEmpty(uccEbsMaterialPOList)) {
                                if (StringUtils.isEmpty((Object)error)) {
                                    error = "\u4e1a\u52a1\u5355\u5143\u7269\u6599\u7f16\u7801\u4e0d\u6b63\u786e!";
                                    uccEbsMaterialChangeBO.setErrorParam("ebsMaterialCode");
                                }
                            } else {
                                uccEbsMaterialPO = uccEbsMaterialPOList.get(0);
                            }
                            if (uccEbsMaterialPO != null) {
                                ebsMaterialName = uccEbsMaterialPO.getEbsMaterialName();
                            }
                        }
                        uccEbsMaterialChangeBO.setEbsMaterialCode(ebsMaterialCode);
                        uccEbsMaterialChangeBO.setEbsMaterialName(ebsMaterialName);
                        String meterialCode = this.convertIfScientific((String)list.get(i++));
                        String materialName = (String)list.get(i++);
                        uccEbsMaterialChangeBO.setMaterialCode(meterialCode);
                        if (!StringUtils.isEmpty((Object)meterialCode)) {
                            UccEMdmMaterialPO uccEMdmMaterialPO = this.uccEMdmMaterialMapper.selectByMaterialCode(meterialCode);
                            if (uccEMdmMaterialPO == null) {
                                if (StringUtils.isEmpty((Object)error)) {
                                    error = "\u5173\u8054\u7269\u6599\u7f16\u7801\u4e0d\u6b63\u786e!";
                                    uccEbsMaterialChangeBO.setErrorParam("materialCode");
                                }
                            } else {
                                materialName = uccEMdmMaterialPO.getMaterialName();
                            }
                        }
                        uccEbsMaterialChangeBO.setMaterialName(materialName);
                        if (StringUtils.isEmpty((Object)materialName)) {
                            // empty if block
                        }
                        String vendorMaterialCode = (String)list.get(i++);
                        uccEbsMaterialChangeBO.setVendorMaterialCode(vendorMaterialCode);
                        String vendorMaterialName = (String)list.get(i++);
                        uccEbsMaterialChangeBO.setVendorMaterialName(vendorMaterialName);
                        if (!error.isEmpty()) {
                            uccEbsMaterialChangeBO.setFailReason(error);
                            uccEbsMaterialChangeBO.setStatus(Integer.valueOf(0));
                        }
                        uccEbsMaterialChangeBOS.add(uccEbsMaterialChangeBO);
                    }
                    List importChangeDataList = JUtil.jsl(uccEbsMaterialChangeBOS, UccEbsMaterialChangeImportPO.class);
                    importChangeDataList.forEach(item -> {
                        item.setLotNum(reqBO.getReqId());
                        item.setSysTenantId(reqBO.getSysTenantId());
                        item.setSysTenantName(reqBO.getSysTenantName());
                        item.setId(Long.valueOf(this.sequence.nextId()));
                        item.setCreateLoginId(reqBO.getUserId());
                        item.setCreateLoginName(reqBO.getUsername());
                        item.setCreateTime(new Date());
                    });
                    this.uccEbsMaterialChangeImportMapper.insertBatch(importChangeDataList);
                }
            }
            catch (Exception e) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(e.getMessage());
            }
        }
        ArrayList sysCodeMapList = new ArrayList();
        try {
            for (List list : secondSheet) {
                HashMap sysCodeMap = new HashMap();
                sysCodeMap.put("title", list.get(0));
                sysCodeMap.put("code", list.get(1));
                sysCodeMapList.add(sysCodeMap);
            }
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
        }
        rspBO.setLotNum(Long.valueOf(lotNum));
        rspBO.setSysCodeMapList(sysCodeMapList);
        return rspBO;
    }

    private List<UccEbsMaterialPO> checkEbsMaterialCode(String sysCode, String ebsMaterialCode, Long sysTenantId) {
        return this.uccEbsMaterialMapper.selectByMaterialCodeAndTenantId(sysCode, ebsMaterialCode, sysTenantId);
    }

    private List<List<String>> dealEcxel(String url, Integer startReadLine, Integer sheetAt) {
        if (StringUtils.isEmpty((Object)url)) {
            return new ArrayList<List<String>>();
        }
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        try {
            ExcelNewUtils.getExcelDateCanNull((String)url, lines, (Integer)startReadLine, (Integer)sheetAt);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u5904\u7406Excel\u5931\u8d25");
        }
        log.info("\u8bfb\u53d6\u5230\u7684\u6570\u636e\uff1a" + JSONObject.toJSONString(lines));
        return lines;
    }

    void fill(List<String> row, Integer len) {
        while (row.size() < len) {
            row.add(null);
        }
    }

    public String convertIfScientific(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        if (input.matches("[-+]?\\d*\\.?\\d+([eE][-+]?\\d+)?")) {
            try {
                BigDecimal value = new BigDecimal(input);
                if (value.stripTrailingZeros().scale() <= 0) {
                    return value.toBigInteger().toString();
                }
                return value.toPlainString();
            }
            catch (NumberFormatException e) {
                return input;
            }
        }
        return input;
    }
}

