/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.common.ability.api.UccMallESearchTOCommodityAbilityService;
import com.tydic.commodity.common.ability.bo.UccCommodityToEsBO;
import com.tydic.commodity.common.ability.bo.UccCommodityToEsRspBO;
import com.tydic.commodity.common.ability.bo.UccSearchAssociatedWordTOEsAbilityReqBo;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.SearchAssociatedWordMapper;
import com.tydic.commodity.dao.UccCatRCommdTypeMapper;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.UccChannelDealMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.SearchAssociatedWordPO;
import com.tydic.commodity.po.UccCommodityTypePo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccMallESearchTOCommodityAbilityService"})
public class UccMallESearchTOCommodityAbilityServiceImpl
implements UccMallESearchTOCommodityAbilityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallESearchTOCommodityAbilityServiceImpl.class);
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccChannelDealMapper uccChannelDealMapper;
    @Autowired
    private UccCatalogDealMapper uccCatalogDealMapper;
    @Autowired
    private UccCatRCommdTypeMapper uccCatRCommdTypeMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private SearchAssociatedWordMapper searchAssociatedWordMapper;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private EsConfig esConfig;

    @PostMapping(value={"autoCommodityToEs"})
    public UccCommodityToEsRspBO autoCommodityToEs() {
        ArrayList<UccCommodityToEsBO> listEs1 = new ArrayList<UccCommodityToEsBO>();
        UccCommodityToEsRspBO rspBO = new UccCommodityToEsRspBO();
        UccCommodityTypePo uccCommodityTypePo = new UccCommodityTypePo();
        List uccCommodityTypePos = this.uccCommodityTypeMapper.queryAllCommdTypeDetails(uccCommodityTypePo);
        if (CollectionUtils.isEmpty((Collection)uccCommodityTypePos)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u540c\u6b65\u5546\u54c1\u7c7b\u578b\u5230ES");
            return rspBO;
        }
        for (UccCommodityTypePo each : uccCommodityTypePos) {
            UccCommodityToEsBO esBO = new UccCommodityToEsBO();
            esBO.setCommodityTypeId(each.getCommodityTypeId());
            esBO.setCommodityTypeName(each.getCommodityTypeName());
            esBO.setChannelId(Long.valueOf(1001L));
            esBO.setCommodityNum(Integer.valueOf(1));
            listEs1.add(esBO);
        }
        this.syncCommodityInfoToEs(listEs1);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u540c\u6b65\u5546\u54c1\u7c7b\u578b\u5230ES");
        return rspBO;
    }

    @PostMapping(value={"syncAssociatedWordToEs"})
    public UccCommodityToEsRspBO syncAssociatedWordToEs(@RequestBody UccSearchAssociatedWordTOEsAbilityReqBo reqBo) {
        ArrayList<UccCommodityToEsBO> listEs1 = new ArrayList<UccCommodityToEsBO>();
        UccCommodityToEsRspBO rspBO = new UccCommodityToEsRspBO();
        if (reqBo.getOperType() != null && reqBo.getOperType() == 1) {
            this.deleteDate(reqBo.getAssociatedWordIds());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u540c\u6b65\u5546\u54c1\u8054\u60f3\u8bcd\u5230ES");
            return rspBO;
        }
        SearchAssociatedWordPO searchAssociatedWordPo = new SearchAssociatedWordPO();
        searchAssociatedWordPo.setAssociatedWordIds(reqBo.getAssociatedWordIds());
        List searchAssociatedWordPOS = this.searchAssociatedWordMapper.getList(searchAssociatedWordPo);
        if (CollectionUtils.isEmpty((Collection)searchAssociatedWordPOS)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u540c\u6b65\u8054\u60f3\u8bcd\u7ed3\u675f");
            return rspBO;
        }
        for (SearchAssociatedWordPO each : searchAssociatedWordPOS) {
            UccCommodityToEsBO esBO = new UccCommodityToEsBO();
            esBO.setCommodityTypeId(each.getAssociatedWordId());
            esBO.setCommodityTypeName(each.getAssociatedWordName());
            esBO.setChannelId(Long.valueOf(1001L));
            esBO.setCommodityNum(Integer.valueOf(1));
            listEs1.add(esBO);
        }
        this.syncCommodityInfoToEs(listEs1);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u540c\u6b65\u5546\u54c1\u8054\u60f3\u8bcd\u5230ES");
        return rspBO;
    }

    private void syncCommodityInfoToEs(List<UccCommodityToEsBO> toEsBOList) {
        for (UccCommodityToEsBO uccCommodityToEsBO : toEsBOList) {
            String jsonStr = JSONObject.toJSONString((Object)uccCommodityToEsBO);
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            String esId = String.valueOf(uccCommodityToEsBO.getCommodityTypeId());
            String id = this.elasticsearchUtil.addData("search", "suggest", esId, jsonObject);
            if (!StringUtils.isBlank((CharSequence)id)) continue;
            LOGGER.error("\u5546\u54c1\u4fe1\u606f[" + uccCommodityToEsBO.getCommodityTypeName() + "|" + uccCommodityToEsBO.getCommodityTypeId() + "]\u540c\u6b65\u5931\u8d25!");
        }
    }

    private void deleteDate(List<Long> associatedWordIds) {
        JSONObject associatedWordId = new JSONObject();
        associatedWordId.put("commodityTypeId", associatedWordIds);
        JSONObject termOrderJson = new JSONObject();
        termOrderJson.put("terms", (Object)associatedWordId);
        JSONArray jsonArray = new JSONArray();
        JSONObject mustJson = new JSONObject();
        mustJson.put("must", (Object)jsonArray);
        JSONObject boolJson = new JSONObject();
        boolJson.put("bool", (Object)mustJson);
        JSONObject qryJson = new JSONObject();
        qryJson.put("query", (Object)boolJson);
        jsonArray.add((Object)termOrderJson);
        String endPoint = "/search/suggest/_delete_by_query";
        Boolean deleteResult = this.elasticsearchUtil.deleteDataByCondition(endPoint, qryJson);
        if (!deleteResult.booleanValue()) {
            LOGGER.error("\u8054\u60f3\u8bcd\u5220\u9664\u5931\u8d25!");
        }
    }
}

