/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SelfRunSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.common.ability.api.UccPlanCallBackAbilityService;
import com.tydic.commodity.common.ability.bo.UccPlanCallBackAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccPlanCallBackAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccPlanCallBackBO;
import com.tydic.commodity.common.busi.api.UccPlanCallBackBusiService;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.uac.exception.BusinessException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccPlanCallBackAbilityService"})
public class UccPlanCallBackAbilityServiceImpl
implements UccPlanCallBackAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccPlanCallBackAbilityServiceImpl.class);
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccPlanCallBackBusiService uccPlanCallBackBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"dealCallBack"})
    public UccPlanCallBackAbilityRspBO dealCallBack(@RequestBody UccPlanCallBackAbilityReqBO reqBO) {
        ArrayList skuPos = new ArrayList();
        if (reqBO.getRows().isEmpty()) {
            UccPlanCallBackAbilityRspBO rspBO = new UccPlanCallBackAbilityRspBO();
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        for (UccPlanCallBackBO each : reqBO.getRows()) {
            if (StringUtils.isEmpty((String)each.getEbsMaterialCode())) {
                throw new BusinessException("8888", "\u5165\u53c2eEbsMaterialCode\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)each.getSysCode())) {
                throw new BusinessException("8888", "\u5165\u53c2sysCode\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (each.getSkuId() != null) {
                List uccSkuPoList = this.uccSkuMapper.batchQrySku(Arrays.asList(each.getSkuId()), null);
                if (CollectionUtils.isEmpty((Collection)uccSkuPoList)) {
                    throw new BusinessException("8888", "\u5165\u53c2skuId\u672a\u67e5\u8be2\u5230");
                }
                if (!StringUtils.isEmpty((String)((UccSkuPo)uccSkuPoList.get(0)).getMaterialId())) {
                    each.setMaterialId(Long.valueOf(Long.parseLong(((UccSkuPo)uccSkuPoList.get(0)).getMaterialId())));
                }
                skuPos.add(uccSkuPoList.get(0));
                continue;
            }
            throw new BusinessException("8888", "\u5165\u53c2skuId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UccPlanCallBackAbilityRspBO rspBO = this.uccPlanCallBackBusiService.dealCallBack(reqBO);
        if (!CollectionUtils.isEmpty(skuPos)) {
            Map<Long, List<UccSkuPo>> skuMap = skuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
            for (Long supplierShopId : skuMap.keySet()) {
                List skus = skuMap.get(supplierShopId).stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skus));
                syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                try {
                    log.info("\u5546\u54c1\u4e2d\u5fc3\u8ba1\u5212\u56de\u8c03\u540c\u6b65ebs\u7269\u6599\u5173\u8054\u5173\u7cfbAPI es\u540c\u6b65\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                }
            }
        }
        return rspBO;
    }
}

