/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.common.ability.api.UccSubmitEbsMaterialChangeAbilityService;
import com.tydic.commodity.common.ability.bo.UccSubmitEbsMaterialChangeAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSubmitEbsMaterialChangeAbilityRspBO;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccEbsMaterialChangeImportMapper;
import com.tydic.commodity.dao.UccEbsMaterialMapper;
import com.tydic.commodity.dao.UccEbsMaterialOperationMapper;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccEbsMaterialChangeImportPO;
import com.tydic.commodity.po.UccEbsMaterialOperationPO;
import com.tydic.commodity.po.UccEbsMaterialPO;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSubmitEbsMaterialChangeAbilityService"})
public class UccSubmitEbsMaterialChangeAbilityServiceImpl
implements UccSubmitEbsMaterialChangeAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSubmitEbsMaterialChangeAbilityServiceImpl.class);
    @Autowired
    private UccEbsMaterialChangeImportMapper uccEbsMaterialChangeImportMapper;
    @Autowired
    private UccEbsMaterialMapper uccEbsMaterialMapper;
    @Autowired
    private UccEbsMaterialOperationMapper uccEbsMaterialOperationMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;

    @PostMapping(value={"submitEbsMaterialChange"})
    public UccSubmitEbsMaterialChangeAbilityRspBO submitEbsMaterialChange(@RequestBody UccSubmitEbsMaterialChangeAbilityReqBO reqBO) {
        UccSubmitEbsMaterialChangeAbilityRspBO rspBO = new UccSubmitEbsMaterialChangeAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.vailidate(reqBO);
        UccEbsMaterialChangeImportPO uccEbsMaterialChangeImportPO = new UccEbsMaterialChangeImportPO();
        uccEbsMaterialChangeImportPO.setSysTenantId(reqBO.getSysTenantId());
        uccEbsMaterialChangeImportPO.setStatus(Integer.valueOf(1));
        uccEbsMaterialChangeImportPO.setLotNum(reqBO.getReqId());
        List list = this.uccEbsMaterialChangeImportMapper.getList(uccEbsMaterialChangeImportPO);
        list.forEach(item -> {
            List<UccEbsMaterialPO> ebsMaterialPOList = this.checkEbsMaterialCode(item.getSysCode(), item.getEbsMaterialCode(), reqBO.getSysTenantId());
            log.info("\u6821\u9a8c\u5b8c\u6210\u7684\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)item));
            this.updateEbsMaterialRelation((UccEbsMaterialChangeImportPO)item, ebsMaterialPOList, reqBO);
            UccEbsMaterialChangeImportPO delete = new UccEbsMaterialChangeImportPO();
            delete.setId(item.getId());
            delete.setSysTenantId(reqBO.getSysTenantId());
            this.uccEbsMaterialChangeImportMapper.deleteBy(delete);
        });
        return rspBO;
    }

    private void updateEbsMaterialRelation(UccEbsMaterialChangeImportPO item, List<UccEbsMaterialPO> ebsMaterialPOList, UccSubmitEbsMaterialChangeAbilityReqBO reqBO) {
        ebsMaterialPOList.forEach(ebsMaterialPO -> {
            UccEbsMaterialOperationPO operationPO = (UccEbsMaterialOperationPO)JSON.parseObject((String)JSON.toJSONString((Object)ebsMaterialPO), UccEbsMaterialOperationPO.class);
            operationPO.setOperationUserId(String.valueOf(reqBO.getUserId()));
            operationPO.setOperationUserName(reqBO.getUsername());
            operationPO.setOperationTime(new Date());
            if (StringUtils.isNotBlank((String)item.getMaterialCode()) && ebsMaterialPO.getMaterialId() != null) {
                UccEMdmMaterialPO uccEMdmMaterialPO = this.uccEMdmMaterialMapper.selectByMaterialCode(item.getMaterialCode());
                operationPO.setOperationType(Integer.valueOf(2));
                operationPO.setOperationContent("\u4fee\u6539\uff1a\u89e3\u9664EBS\u7269\u6599\u7f16\u7801" + ebsMaterialPO.getEbsMaterialCode() + "\u4e0e\u7269\u6599\u7f16\u7801" + ebsMaterialPO.getMaterialId() + "\u5173\u8054");
                UccEbsMaterialPO update = new UccEbsMaterialPO();
                update.setEbsMaterialId(ebsMaterialPO.getEbsMaterialId());
                update.setMaterialId(uccEMdmMaterialPO.getMaterialId());
                update.setMaterialCode(uccEMdmMaterialPO.getMaterialCode());
                update.setMaterialName(uccEMdmMaterialPO.getMaterialName());
                this.uccEbsMaterialMapper.updateSelf(update);
            } else {
                operationPO.setOperationType(Integer.valueOf(0));
                operationPO.setOperationContent("\u505c\u7528\uff1a\u505c\u7528\u7269\u6599\u7f16\u7801+" + ebsMaterialPO.getMaterialCode() + "\uff0c\u89e3\u9664EBS\u7269\u6599\u7f16\u7801" + ebsMaterialPO.getEbsMaterialCode() + "\u5173\u8054");
                UccEbsMaterialPO update = new UccEbsMaterialPO();
                update.setEbsMaterialId(ebsMaterialPO.getEbsMaterialId());
                update.setCleanSkuId(Integer.valueOf(1));
                update.setCleanMaterialId(Integer.valueOf(1));
                update.setSkuId(null);
                update.setMaterialId(null);
                this.uccEbsMaterialMapper.updateByPrimaryKeySelective(update);
            }
            this.ebsMaterialOperLogAdd(operationPO);
        });
    }

    private void ebsMaterialOperLogAdd(UccEbsMaterialOperationPO operationPO) {
        operationPO.setOperationId(Long.valueOf(Sequence.getInstance().nextId()));
        try {
            this.uccEbsMaterialOperationMapper.insert(operationPO);
        }
        catch (Exception e) {
            log.error("EBS\u7269\u6599\u6620\u5c04\u64cd\u4f5c\u65e5\u5fd7\u63d2\u5165\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private List<UccEbsMaterialPO> checkEbsMaterialCode(String sysCode, String ebsMaterialCode, Long sysTenantId) {
        return this.uccEbsMaterialMapper.selectByMaterialCodeAndTenantId(sysCode, ebsMaterialCode, sysTenantId);
    }

    private void vailidate(UccSubmitEbsMaterialChangeAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getReqId() == null) {
            throw new ZTBusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

