/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccSyncNormToEsAbilityService;
import com.tydic.commodity.common.ability.bo.UccSyncNormToEsAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSyncNormToEsAbilityRspBO;
import com.tydic.commodity.dao.UccNormSpuMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSyncNormToEsAbilityService"})
public class UccSyncNormToEsAbilityServiceImpl
implements UccSyncNormToEsAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSyncNormToEsAbilityServiceImpl.class);
    @Autowired
    private UccNormSpuMapper uccNormSpuMapper;
    @Value(value="${NORM_SPU_SYNC_TOPIC:NORM_SPU_SYNC_TOPIC}")
    private String normSpuTopic;
    @Value(value="${NORM_SPU_SYNC_TAG:*}")
    private String normSpuTag;
    @Resource(name="lmSyncNormSpuMqServiceProvider")
    private ProxyMessageProducer lmSyncNormSpuMqServiceProvider;

    @PostMapping(value={"syncNormSpuToEs"})
    public UccSyncNormToEsAbilityRspBO syncNormSpuToEs(@RequestBody UccSyncNormToEsAbilityReqBO reqBO) {
        List skuList;
        Integer size = 200;
        Integer sizetotal = 2000;
        Page page = new Page();
        int count = 0;
        do {
            page.setPageSize(sizetotal.intValue());
            page.setPageNo(++count);
            skuList = this.uccNormSpuMapper.getIdListPage(reqBO.getVCommodityIdList(), page);
            if (CollectionUtils.isEmpty((Collection)skuList)) break;
            List<List<List>> result = UccSyncNormToEsAbilityServiceImpl.averageAssign(skuList, size);
            result.forEach(list -> {
                UccSyncNormToEsAbilityReqBO syncNormToEsAbilityReqBO = new UccSyncNormToEsAbilityReqBO();
                syncNormToEsAbilityReqBO.setVCommodityIdList(list);
                syncNormToEsAbilityReqBO.setOperType(reqBO.getOperType());
                try {
                    this.lmSyncNormSpuMqServiceProvider.send(new ProxyMessage(this.normSpuTopic, this.normSpuTag, JSON.toJSONString((Object)syncNormToEsAbilityReqBO)));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65\u5546\u54c1\u6570\u636e\u5931\u8d25 \uff1a" + e);
                    throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
                }
            });
        } while (sizetotal.compareTo(skuList.size()) <= 0);
        UccSyncNormToEsAbilityRspBO abilityRspBO = new UccSyncNormToEsAbilityRspBO();
        abilityRspBO.setRespCode("0000");
        return abilityRspBO;
    }

    public static <T> List<List<T>> averageAssign(List<T> source, int splitItemNum) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (source != null && source.size() > 0 && splitItemNum > 0) {
            if (source.size() <= splitItemNum) {
                result.add(source);
            } else {
                int splitNum = source.size() % splitItemNum == 0 ? source.size() / splitItemNum : source.size() / splitItemNum + 1;
                List<T> value = null;
                for (int i = 0; i < splitNum; ++i) {
                    value = i < splitNum - 1 ? source.subList(i * splitItemNum, (i + 1) * splitItemNum) : source.subList(i * splitItemNum, source.size());
                    result.add(value);
                }
            }
        }
        return result;
    }
}

