/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.common.ability.api.UccTaskSnycGovernSkuAbilityService;
import com.tydic.commodity.common.ability.bo.UccTaskSnycGovernSkuAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccTaskSnycGovernSkuAbilityRspBO;
import com.tydic.commodity.common.comb.bo.UccSnycGovernSkuCombReqBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccTaskSnycGovernSkuAbilityService"})
public class UccTaskSnycGovernSkuAbilityServiceImpl
implements UccTaskSnycGovernSkuAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccTaskSnycGovernSkuAbilityServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    private final Integer snycSize = 50;
    @Value(value="${SNYC_GOVERN_SKU_TOPIC:SNYC_GOVERN_SKU_TOPIC}")
    private String snycGovernSkuTopic;
    @Resource(name="uccSnycGovernSkuMqProvider")
    private ProxyMessageProducer uccGovernSkuResultMqProvider;

    @PostMapping(value={"syncGovernSku"})
    public UccTaskSnycGovernSkuAbilityRspBO syncGovernSku(@RequestBody UccTaskSnycGovernSkuAbilityReqBO reqBO) {
        UccTaskSnycGovernSkuAbilityRspBO rspBO = new UccTaskSnycGovernSkuAbilityRspBO();
        rspBO.setRespCode("0000");
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSkuList())) {
            List uccSkuPoList = this.uccSkuMapper.batchQrySku(reqBO.getSkuList(), null);
            if (CollectionUtils.isEmpty((Collection)uccSkuPoList)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5355\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
                return rspBO;
            }
            List filterSku = uccSkuPoList.stream().filter(a -> !(a.getGovernStatus() == 1 && a.getGovernStatus() == 3 || a.getStepId() != null && "2".equals(a.getStepId()))).collect(Collectors.toList());
            log.info("\u5f85\u540c\u6b65\u5546\u54c1\u72b6\u6001\u6709\u8bef\u6570\u91cf\uff1a" + filterSku.size());
            if (!CollectionUtils.isEmpty(filterSku)) {
                List skus = filterSku.stream().map(UccSkuPo::getSkuCode).collect(Collectors.toList());
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5355\u54c1\u7f16\u7801: " + skus + "\u4e0d\u4e3a\u5f85\u540c\u6b65\u72b6\u6001");
                return rspBO;
            }
            List<Long> skus = uccSkuPoList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            this.sendMq(skus);
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getIsAllPush()) && "1".equals(reqBO.getIsAllPush())) {
            ArrayList<Integer> governStatuss = new ArrayList<Integer>();
            if ("1".equals(reqBO.getPushTag())) {
                governStatuss.add(1);
            } else if ("2".equals(reqBO.getPushTag())) {
                governStatuss.add(3);
            } else {
                governStatuss.add(1);
                governStatuss.add(3);
            }
            Page page = null;
            int i = 1;
            while (true) {
                page = new Page(i, this.snycSize.intValue());
                List skulist = this.uccSkuMapper.pageQryByGovernStatus(page, governStatuss, "2");
                this.sendMq(skulist);
                if (skulist.size() >= this.snycSize) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            Page page = null;
            int i = 1;
            while (true) {
                page = new Page(i, this.snycSize.intValue());
                ArrayList<Integer> governStatuss = new ArrayList<Integer>();
                governStatuss.add(1);
                governStatuss.add(3);
                List skulist = this.uccSkuMapper.pageQryByGovernStatus(page, governStatuss, "2");
                this.sendMq(skulist);
                if (skulist.size() < this.snycSize) break;
                ++i;
            }
        }
        return rspBO;
    }

    private void sendMq(List<Long> skus) {
        UccSnycGovernSkuCombReqBO sendMessage = new UccSnycGovernSkuCombReqBO();
        sendMessage.setSkuId(skus);
        try {
            this.uccGovernSkuResultMqProvider.send(new ProxyMessage(this.snycGovernSkuTopic, "*", JSON.toJSONString((Object)sendMessage)));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u53d1\u9001mq\u5931\u8d25\uff1a " + e.getMessage());
        }
    }
}

