/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSkuPutCirAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuPutCirReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.common.busi.api.UccAutoPutOnShelfBusiService;
import com.tydic.commodity.common.busi.bo.UccAutoPutOnShelfBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccAutoPutOnShelfBusiRspBO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccAutoPutOnShelfBusiServiceImpl
implements UccAutoPutOnShelfBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccAutoPutOnShelfBusiServiceImpl.class);
    @Autowired
    private UccSkuPutCirAtomService uccSkuPutCirAtomService;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;

    @Override
    public UccAutoPutOnShelfBusiRspBO dealAutoPutOnShelf(UccAutoPutOnShelfBusiReqBO reqBO) {
        UccAutoPutOnShelfBusiRspBO rspBO = new UccAutoPutOnShelfBusiRspBO();
        try {
            for (UccSkuPo each : reqBO.getUccSkuPos()) {
                UccSkuPutCirReqBO uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                uccSkuPutCirReqBO.setSkuId(each.getSkuId());
                uccSkuPutCirReqBO.setSupplierShopId(each.getSupplierShopId());
                uccSkuPutCirReqBO.setUptype(Integer.valueOf(2));
                uccSkuPutCirReqBO.setRealUpTime(DateUtils.dateToStr((Date)new Date()));
                uccSkuPutCirReqBO.setCreateOperId("admin");
                uccSkuPutCirReqBO.setSysTenantId(reqBO.getSysTenantId());
                uccSkuPutCirReqBO.setSysTenantName(reqBO.getSysTenantName());
                this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u66f4\u65b0\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25");
        }
        Map<Long, List<UccSkuPo>> mapSku = reqBO.getUccSkuPos().stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
        for (Long supplierShopId : mapSku.keySet()) {
            List<Long> skus = mapSku.get(supplierShopId).stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            try {
                this.updateSkuStatus(ModelRuleConstant.SKU_STATUS_ON_SHELF, null, null, skus, supplierShopId);
            }
            catch (Exception e) {
                throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateSkuStatus(Integer newStatus, String newApprovalStatus, String newStepId, List<Long> skus, Long supplierShopId) {
        UccStatusChangeUpdateSpuAtomRspBO statusChangeUpdateSpuAtomRspBO = null;
        UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
        ArrayList<UccSkuUpdateStatusBO> skuUpdateStatusBOS = new ArrayList<UccSkuUpdateStatusBO>();
        UccSkuUpdateStatusBO bo = null;
        for (Long each : skus) {
            bo = new UccSkuUpdateStatusBO();
            bo.setSkuId(each);
            bo.setSkuStatus(newStatus);
            if (newStatus.equals(ModelRuleConstant.SKU_STATUS_ON_SHELF)) {
                bo.setOnShelveTime(new Date());
            }
            skuUpdateStatusBOS.add(bo);
        }
        uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuUpdateStatusBOS);
        uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
        uccStatusChangeUpdateSpuAtomReqBO.setUserId(Long.valueOf(1L));
        uccStatusChangeUpdateSpuAtomReqBO.setApprovalStatus(newApprovalStatus);
        uccStatusChangeUpdateSpuAtomReqBO.setStepId(newStepId);
        try {
            statusChangeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
            if (!"0000".equals(statusChangeUpdateSpuAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), statusChangeUpdateSpuAtomRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
        }
    }
}

