/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccConfigurationparametersEditBO;
import com.tydic.commodity.common.busi.api.UccConfigurationparametersEditBusiService;
import com.tydic.commodity.common.busi.bo.UccConfigurationparametersEditBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccConfigurationparametersEditBusiRspBO;
import com.tydic.commodity.dao.UccParamsConfigDetailMapper;
import com.tydic.commodity.dao.UccParamsConfigMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccParamsConfigDetailPO;
import com.tydic.commodity.po.UccParamsConfigPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UccConfigurationparametersEditBusiServiceImpl
implements UccConfigurationparametersEditBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccConfigurationparametersEditBusiServiceImpl.class);
    @Autowired
    private UccParamsConfigDetailMapper uccParamsConfigDetailMapper;
    @Autowired
    private UccParamsConfigMapper uccParamsConfigMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Resource(name="lOGToleranceSyncProvider")
    private ProxyMessageProducer logToleranceSyncProvider;

    @Override
    public UccConfigurationparametersEditBusiRspBO dealparametersEdit(UccConfigurationparametersEditBusiReqBO reqBO) {
        UccConfigurationparametersEditBusiRspBO rspBO = new UccConfigurationparametersEditBusiRspBO();
        int num = 0;
        for (UccConfigurationparametersEditBO each : reqBO.getEditInfoList()) {
            UccParamsConfigDetailPO po = new UccParamsConfigDetailPO();
            po.setId(each.getId());
            UccParamsConfigDetailPO uccParamsConfigDetailPO = this.uccParamsConfigDetailMapper.getModelBy(po);
            if (uccParamsConfigDetailPO == null) {
                rspBO.setRespCode("0002");
                rspBO.setRespDesc("\u67e5\u8be2id\u4e3a:" + each.getId() + "\u4e0d\u5b58\u5728");
                return rspBO;
            }
            UccParamsConfigPO uccParamsConfigPO = new UccParamsConfigPO();
            uccParamsConfigPO.setParamsId(uccParamsConfigDetailPO.getParamsId());
            UccParamsConfigPO modelBy = this.uccParamsConfigMapper.getModelBy(uccParamsConfigPO);
            if ("TOLERANCE".equals(modelBy.getParamsCode())) {
                num += this.update(each, reqBO);
                List listByID = this.uccSkuMapper.getListByID(uccParamsConfigDetailPO);
                for (UccSkuPo uccSkuPo : listByID) {
                    uccSkuPo.setTolerance(BigDecimal.valueOf(Double.parseDouble(each.getUpWarn())));
                    this.uccSkuMapper.updateSkuTolerance(uccSkuPo);
                    this.syncES(uccSkuPo);
                }
                continue;
            }
            num += this.update(each, reqBO);
        }
        if (reqBO.getEditInfoList().size() != num) {
            throw new BusinessException("8888", "\u66f4\u65b0\u6570\u636e\u6761\u6570\u4e8e\u5165\u53c2\u6761\u6570\u4e0d\u5339\u914d");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private int update(UccConfigurationparametersEditBO each, UccConfigurationparametersEditBusiReqBO reqBO) {
        UccParamsConfigDetailPO set = new UccParamsConfigDetailPO();
        set.setEnable(each.getEnable());
        set.setOrder(each.getOrder());
        if (!StringUtils.isEmpty((Object)each.getRule())) {
            set.setRule(each.getRule());
        }
        if (!StringUtils.isEmpty((Object)each.getUpWarn())) {
            set.setUpWarn(each.getUpWarn());
        }
        if (!StringUtils.isEmpty((Object)each.getDownWarn())) {
            set.setDownWarn(each.getDownWarn());
        }
        set.setUpdateTime((Date)new Timestamp(System.currentTimeMillis()));
        set.setUpdateOper(reqBO.getUsername());
        UccParamsConfigDetailPO where = new UccParamsConfigDetailPO();
        where.setId(each.getId());
        return this.uccParamsConfigDetailMapper.updateBy(set, where);
    }

    private void syncES(UccSkuPo uccSkuPo) {
        try {
            log.debug("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\uff1a " + uccSkuPo);
            this.logToleranceSyncProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)uccSkuPo)));
        }
        catch (Exception e) {
            log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25: " + e);
        }
    }
}

