/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.cfc.ability.api.CrcCfcQryLetterOfGuaranteeStatusAbilityService;
import com.tydic.cfc.ability.bo.CrcCfcQryLetterOfGuaranteeStatusAbilityReqBO;
import com.tydic.cfc.ability.bo.CrcCfcQryLetterOfGuaranteeStatusAbilityRspBO;
import com.tydic.cfc.ability.bo.CrcCfcQryLetterOfGuaranteeStatusBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSkuPutCirAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuPutCirReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuPutCirRspBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.common.ability.bo.UccGetletterOfGuaranteeUpdateBO;
import com.tydic.commodity.common.busi.api.UccOverToleranceUpdateBusiService;
import com.tydic.commodity.common.busi.bo.UccOverToleranceUpdateBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccOverToleranceUpdateBusiRspBO;
import com.tydic.commodity.consumer.bo.DycUccApproveTaskSyncBO;
import com.tydic.commodity.dao.EacRuTaskMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.EacRuTaskPO;
import com.tydic.commodity.po.UccParamsConfigDetailPO;
import com.tydic.commodity.po.UccSkuExpandPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.osworkflow.approve.ability.EacRuTaskAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityRspInfoBO;
import com.tydic.osworkflow.approve.ability.bo.EacRuInstAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacRuInstAbilityRspBO;
import com.tydic.umc.general.ability.api.UmcSendHaveDoneAbilityService;
import com.tydic.umc.general.ability.bo.UmcSendHaveDoneAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcSendHaveDoneAbilityRspBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccOverToleranceUpdateBusiServiceImpl
implements UccOverToleranceUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccOverToleranceUpdateBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPutCirAtomService uccSkuPutCirAtomService;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private EacRuTaskMapper eacRuTaskMapper;
    @Autowired
    private EacRuTaskAbilityService eacRuTaskAbilityService;
    @Autowired
    private UmcSendHaveDoneAbilityService umcSendHaveDoneAbilityService;
    @Autowired
    private CrcCfcQryLetterOfGuaranteeStatusAbilityService crcCfcQryLetterOfGuaranteeStatusAbilityService;
    @Resource(name="dycUccProcessTaskSyncBySelfProducer")
    private ProxyMessageProducer dycUccProcessTaskSyncBySelfProducer;
    @Resource(name="logSkuStatusSyncProvider")
    private ProxyMessageProducer logSkuStatusSyncProvider;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;

    @Override
    public UccOverToleranceUpdateBusiRspBO overToleranceUpdate(UccOverToleranceUpdateBusiReqBO reqBO) {
        UccOverToleranceUpdateBusiRspBO rspBO = new UccOverToleranceUpdateBusiRspBO();
        List<UccGetletterOfGuaranteeUpdateBO> vendorList = reqBO.getVendorList();
        for (UccGetletterOfGuaranteeUpdateBO uccGetletterOfGuaranteeUpdateBO : vendorList) {
            this.dealOverToleranceUpdate(uccGetletterOfGuaranteeUpdateBO, reqBO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealOverToleranceUpdate(UccGetletterOfGuaranteeUpdateBO updateBO, UccOverToleranceUpdateBusiReqBO reqBO) {
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setVendorId(updateBO.getVendorId());
        if (UccConstants.GetletterOfGuarantee0perType.NO_DEAL.equals(updateBO.getOperType())) {
            uccSkuPo.setLimitOrder(Integer.valueOf(3));
            List uccSkuPoList = this.uccSkuMapper.qerySku(uccSkuPo);
            if (CollectionUtils.isEmpty((Collection)uccSkuPoList)) {
                return;
            }
            Map<Long, List<UccSkuPo>> collect = uccSkuPoList.stream().collect(Collectors.groupingBy(UccSkuPo::getVendorId));
            CrcCfcQryLetterOfGuaranteeStatusAbilityReqBO crcCfcQryLetterOfGuaranteeStatusAbilityReqBO = new CrcCfcQryLetterOfGuaranteeStatusAbilityReqBO();
            crcCfcQryLetterOfGuaranteeStatusAbilityReqBO.setVendorIds(new ArrayList<Long>(collect.keySet()));
            crcCfcQryLetterOfGuaranteeStatusAbilityReqBO.setSysTenantId(((UccSkuPo)uccSkuPoList.get(0)).getSysTenantId());
            log.info("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u4fdd\u51fd\u914d\u7f6e\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)crcCfcQryLetterOfGuaranteeStatusAbilityReqBO));
            CrcCfcQryLetterOfGuaranteeStatusAbilityRspBO crcCfcQryLetterOfGuaranteeStatusAbilityRspBO = this.crcCfcQryLetterOfGuaranteeStatusAbilityService.qryLetterOfGuaranteeStatus(crcCfcQryLetterOfGuaranteeStatusAbilityReqBO);
            log.info("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u4fdd\u51fd\u914d\u7f6e\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)crcCfcQryLetterOfGuaranteeStatusAbilityRspBO));
            if (!"0000".equals(crcCfcQryLetterOfGuaranteeStatusAbilityRspBO.getRespCode())) {
                throw new BusinessException("8888", "\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u4fdd\u51fd\u914d\u7f6e\u51fa\u9519:" + crcCfcQryLetterOfGuaranteeStatusAbilityRspBO.getRespDesc());
            }
            Map<Long, List<CrcCfcQryLetterOfGuaranteeStatusBO>> VendorMap = crcCfcQryLetterOfGuaranteeStatusAbilityRspBO.getCrcCfcQryLetterOfGuaranteeStatusBOList().stream().collect(Collectors.groupingBy(CrcCfcQryLetterOfGuaranteeStatusBO::getVendorId));
            List skuIds = uccSkuPoList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            for (UccSkuPo each : uccSkuPoList) {
                if (!CollectionUtils.isEmpty((Collection)VendorMap.get(each.getVendorId())) && VendorMap.get(each.getVendorId()).get(0).getOperType() == 2) {
                    skuIds.removeIf(e -> e.equals(each.getSkuId()));
                }
                if (each.getSkuSource() == 2) {
                    int isOverTolerance = each.getDiscount().subtract(each.getSignDiscount()).subtract(each.getTolerance()).compareTo(new BigDecimal(0)) > 0 ? 2 : 1;
                    if (isOverTolerance != 1) continue;
                    skuIds.removeIf(e -> e.equals(each.getSkuId()));
                    continue;
                }
                skuIds.removeIf(e -> e.equals(each.getSkuId()));
            }
            UccSkuPo temp = new UccSkuPo();
            temp.setLimitOrder(Integer.valueOf(1));
            if (!CollectionUtils.isEmpty(skuIds)) {
                this.uccSkuMapper.batchUpdateById(skuIds, temp);
            }
        } else if (UccConstants.GetletterOfGuarantee0perType.LOOK_NO_ORDER.equals(updateBO.getOperType())) {
            uccSkuPo.setLimitOrder(Integer.valueOf(1));
            List uccSkuPoList = this.uccSkuMapper.qerySku(uccSkuPo);
            if (CollectionUtils.isEmpty((Collection)uccSkuPoList)) {
                return;
            }
            List skuIds = uccSkuPoList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            for (UccSkuPo each : uccSkuPoList) {
                if (each.getSkuSource() == 2) {
                    int isOverTolerance = each.getDiscount().subtract(each.getSignDiscount()).subtract(each.getTolerance()).compareTo(new BigDecimal(0)) > 0 ? 2 : 1;
                    if (isOverTolerance != 1) continue;
                    skuIds.removeIf(e -> e.equals(each.getSkuId()));
                    continue;
                }
                skuIds.removeIf(e -> e.equals(each.getSkuId()));
            }
            UccSkuPo temp = new UccSkuPo();
            temp.setLimitOrder(Integer.valueOf(3));
            if (!CollectionUtils.isEmpty(skuIds)) {
                this.uccSkuMapper.batchUpdateById(skuIds, temp);
            }
        } else if (UccConstants.GetletterOfGuarantee0perType.TAKE_DOWN.equals(updateBO.getOperType())) {
            this.dealUccSkuUpdateAtom(updateBO, reqBO);
        } else {
            log.debug("\u6ca1\u6709\u5f53\u524d\u7c7b\u578b\uff1a" + updateBO.getOperType());
        }
    }

    private void dealUccSkuUpdateAtom(UccGetletterOfGuaranteeUpdateBO updateBO, UccOverToleranceUpdateBusiReqBO reqBO) {
        UccParamsConfigDetailPO uccParamsConfigDetailPO = new UccParamsConfigDetailPO();
        uccParamsConfigDetailPO.setBusinessType(String.valueOf(updateBO.getVendorId()));
        uccParamsConfigDetailPO.setAmend(Integer.valueOf(0));
        ArrayList<UccSkuPo> uccSkuPos = this.uccSkuMapper.getListByID(uccParamsConfigDetailPO);
        if (CollectionUtils.isEmpty((Collection)uccSkuPos)) {
            return;
        }
        ArrayList<UccSkuPo> tempList = new ArrayList<UccSkuPo>();
        for (UccSkuPo each : uccSkuPos) {
            int isOverTolerance;
            if (each.getSkuSource() != 2 || (isOverTolerance = each.getDiscount().subtract(each.getSignDiscount()).subtract(each.getTolerance()).compareTo(new BigDecimal(0)) > 0 ? 2 : 1) != 2) continue;
            tempList.add(each);
        }
        uccSkuPos = tempList;
        if (CollectionUtils.isEmpty(uccSkuPos)) {
            return;
        }
        uccParamsConfigDetailPO.setAmend(Integer.valueOf(1));
        List stopList = this.uccSkuMapper.getListByID(uccParamsConfigDetailPO);
        ArrayList<Long> businessIdList = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)stopList)) {
            Map<Integer, List<UccSkuPo>> collect = stopList.stream().collect(Collectors.groupingBy(UccSkuPo::getApprovalStatus));
            if (collect.containsKey(31)) {
                Set spuIds = collect.get(31).stream().map(UccSkuPo::getCommodityId).collect(Collectors.toSet());
                businessIdList.addAll(spuIds);
            }
            if (collect.containsKey(41)) {
                Set skuIds = collect.get(41).stream().map(UccSkuPo::getSkuId).collect(Collectors.toSet());
                businessIdList.addAll(skuIds);
            }
        }
        log.debug("\u5df2\u4e0a\u67b6\u5355\u54c1\u96c6\u5408\uff1a " + uccSkuPos.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList()));
        Map<Long, List<UccSkuPo>> mapSku = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
        for (Long supplierShopId : mapSku.keySet()) {
            List skus = mapSku.get(supplierShopId).stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            ArrayList<UccSkuUpdateStatusBO> skuUpdateStatusBOS = new ArrayList<UccSkuUpdateStatusBO>();
            UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
            for (Long each : skus) {
                this.updateSkuExpand(each, updateBO);
                UccSkuPutCirReqBO uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                uccSkuPutCirReqBO.setSkuId(each);
                uccSkuPutCirReqBO.setSupplierShopId(supplierShopId);
                uccSkuPutCirReqBO.setDownType(Integer.valueOf(2));
                uccSkuPutCirReqBO.setRealDownTime(DateUtils.dateToStr((Date)new Date()));
                uccSkuPutCirReqBO.setRemark("\u8d85\u5bb9\u5fcd\u5ea6\uff0c\u7cfb\u7edf\u81ea\u52a8\u4e0b\u67b6");
                uccSkuPutCirReqBO.setCreateOperId("1");
                uccSkuPutCirReqBO.setSysTenantId(reqBO.getSysTenantId());
                uccSkuPutCirReqBO.setSysTenantName(reqBO.getSysTenantName());
                UccSkuPutCirRspBO uccSkuPutCirRspBO = this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
                if (!"0000".equals(uccSkuPutCirRspBO.getRespCode())) {
                    throw new BusinessException("8888", uccSkuPutCirRspBO.getRespDesc());
                }
                UccSkuUpdateStatusBO bo = new UccSkuUpdateStatusBO();
                bo.setSkuId(each);
                bo.setSkuStatus(ModelRuleConstant.SKU_STATUS_AUTO_DOWN_SHELF);
                skuUpdateStatusBOS.add(bo);
            }
            uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuUpdateStatusBOS);
            uccStatusChangeUpdateSpuAtomReqBO.setApprovalStatus("0");
            uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
            uccStatusChangeUpdateSpuAtomReqBO.setUserId(reqBO.getUserId());
            try {
                UccStatusChangeUpdateSpuAtomRspBO statusChangeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
                if ("0000".equals(statusChangeUpdateSpuAtomRspBO.getRespCode())) continue;
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), statusChangeUpdateSpuAtomRspBO.getRespDesc());
            }
            catch (Exception e) {
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)stopList)) {
            this.dealApproveRollBack(businessIdList);
        }
    }

    private void updateSkuExpand(Long objId, UccGetletterOfGuaranteeUpdateBO reqBO) {
        UccSkuExpandPo uccSkuExpandPo = new UccSkuExpandPo();
        uccSkuExpandPo.setSkuId(objId);
        List uccSkuExpandPos = this.uccSkuExpandMapper.querySkuExpand(uccSkuExpandPo);
        uccSkuExpandPo.setExpand16("\u8d85\u5bb9\u5fcd\u5ea6");
        if (!CollectionUtils.isEmpty((Collection)uccSkuExpandPos)) {
            this.uccSkuExpandMapper.updateSkuExpand(uccSkuExpandPo);
        } else {
            List uccSkuPoList = this.uccSkuMapper.batchQrySku(Arrays.asList(objId), null);
            uccSkuExpandPo.setCommodityId(((UccSkuPo)uccSkuPoList.get(0)).getCommodityId());
            uccSkuExpandPo.setSupplierShopId(((UccSkuPo)uccSkuPoList.get(0)).getSupplierShopId());
            uccSkuExpandPo.setSysTenantId(reqBO.getSysTenantId());
            uccSkuExpandPo.setSysTenantName(reqBO.getSysTenantName());
            this.uccSkuExpandMapper.insertSkuExpand(uccSkuExpandPo);
        }
    }

    private void dealApproveRollBack(List<Long> businessIdList) {
        log.info("\u65e0\u534f\u8bae\u5355\u54c1\u5f3a\u5236\u4e0b\u67b6\uff0c\u64a4\u9500\u5ba1\u6279\u540e\u7eed\u64cd\u4f5c-----------businessIdList:{}", (Object)JSON.toJSONString(businessIdList));
        EacRuTaskPO eacRuTaskPO = new EacRuTaskPO();
        eacRuTaskPO.setBusinessIds(businessIdList.stream().map(Object::toString).collect(Collectors.toList()));
        eacRuTaskPO.setStatus("ACTIVE");
        List taskList = this.eacRuTaskMapper.getList(eacRuTaskPO);
        Map<String, List<EacRuTaskPO>> collect = taskList.stream().collect(Collectors.groupingBy(EacRuTaskPO::getApproveInstId));
        EacRuTaskPO qryPO = new EacRuTaskPO();
        qryPO.setTaskIds(taskList.stream().map(EacRuTaskPO::getTaskId).collect(Collectors.toList()));
        List uccSkuPos = this.eacRuTaskMapper.qryTaskSku(qryPO);
        Map<Object, Object> taskIdMap = new HashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)uccSkuPos)) {
            taskIdMap = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getTaskId));
        }
        ArrayList<EacApproveAbilityRspInfoBO> list = new ArrayList<EacApproveAbilityRspInfoBO>();
        for (String approveInstId : collect.keySet()) {
            EacRuInstAbilityReqBO eacRuInstAbilityReqBO = new EacRuInstAbilityReqBO();
            eacRuInstAbilityReqBO.setApproveInstId(approveInstId);
            if (taskIdMap.containsKey(collect.get(approveInstId).get(0).getTaskId()) && ((UccSkuPo)((List)taskIdMap.get(collect.get(approveInstId).get(0).getTaskId())).get(0)).getSysTenantId() != null) {
                eacRuInstAbilityReqBO.setSysTenantId(((UccSkuPo)((List)taskIdMap.get(collect.get(approveInstId).get(0).getTaskId())).get(0)).getSysTenantId().toString());
            }
            try {
                log.info("\u5ba1\u6279\u5355\u5ba1\u6279\u6d41\u7a0b\u7ec8\u6b62\u5165\u53c2eacRuInstAbilityReqBO:" + JSON.toJSON((Object)eacRuInstAbilityReqBO));
                EacRuInstAbilityRspBO eacRuInstAbilityRspBO = this.eacRuTaskAbilityService.suspensionApprove(eacRuInstAbilityReqBO);
                log.info("\u5ba1\u6279\u5355\u5ba1\u6279\u6d41\u7a0b\u7ec8\u6b62\u51fa\u53c2eacRuInstAbilityRspBO:" + JSON.toJSON((Object)eacRuInstAbilityRspBO));
                if (!"0000".equals(eacRuInstAbilityRspBO.getRespCode())) {
                    throw new BusinessException(RspConstantEnums.COMMODITY_APPROVAL_PASS_FAIL.code(), eacRuInstAbilityRspBO.getRespDesc());
                }
            }
            catch (BusinessException e) {
                throw new BusinessException(RspConstantEnums.COMMODITY_APPROVAL_PASS_FAIL.code(), e.getMsgInfo());
            }
            EacApproveAbilityRspInfoBO eacApproveAbilityRspInfoBO = new EacApproveAbilityRspInfoBO();
            eacApproveAbilityRspInfoBO.setApproveInstId(approveInstId);
            eacApproveAbilityRspInfoBO.setIsFinish(Boolean.valueOf(true));
            eacApproveAbilityRspInfoBO.setTacheCode(collect.get(approveInstId).get(0).getTacheCode());
            eacApproveAbilityRspInfoBO.setTacheName(collect.get(approveInstId).get(0).getTacheName());
            list.add(eacApproveAbilityRspInfoBO);
        }
        log.info("----------------------list:{}", (Object)JSON.toJSONString(list));
        for (EacApproveAbilityRspInfoBO each : list) {
            try {
                DycUccApproveTaskSyncBO dycUccApproveTaskSyncBO = new DycUccApproveTaskSyncBO();
                dycUccApproveTaskSyncBO.setIsfinish(null);
                dycUccApproveTaskSyncBO.setIsfinish(each.getIsFinish());
                dycUccApproveTaskSyncBO.setProcInstId(each.getApproveInstId());
                log.info("------------------\u64a4\u9500\u5ba1\u6279\u540e\u7eed\u64cd\u4f5c\uff0c\u4eff\u7167\u5ba1\u6279\u4e2d\u5fc3\u53d1\u9001mq\uff1a{}" + JSON.toJSONString((Object)dycUccApproveTaskSyncBO));
                this.dycUccProcessTaskSyncBySelfProducer.send(new ProxyMessage(PropertiesUtil.getProperty((String)"UCC_APPROVE_TASK_SYNC_BY_SELF_TOPIC"), PropertiesUtil.getProperty((String)"APPROVE_TASK_SYNC_TAG"), JSON.toJSONString((Object)dycUccApproveTaskSyncBO)));
            }
            catch (Exception e) {
                log.error("\u64a4\u9500\u5ba1\u6279\u540e\u7eed\u64cd\u4f5c\uff0c\u4eff\u7167\u5ba1\u6279\u4e2d\u5fc3\u53d1\u9001mq\u5931\u8d25\uff1a" + e.getMessage());
            }
            try {
                UmcSendHaveDoneAbilityReqBO umcSendHaveDoneAbilityReqBO = new UmcSendHaveDoneAbilityReqBO();
                umcSendHaveDoneAbilityReqBO.setBusiId(each.getApproveInstId() + "-" + each.getTacheCode());
                umcSendHaveDoneAbilityReqBO.setOperUserId("1");
                umcSendHaveDoneAbilityReqBO.setOperUserName("admin");
                umcSendHaveDoneAbilityReqBO.setBusinessUnid(each.getApproveInstId());
                umcSendHaveDoneAbilityReqBO.setCurnode(each.getTacheName());
                umcSendHaveDoneAbilityReqBO.setFlowstatus("\u6d41\u7a0b\u7ed3\u675f");
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                umcSendHaveDoneAbilityReqBO.setFlowovertime(simpleDateFormat.format(new Date(System.currentTimeMillis())));
                log.info("\u64a4\u9500\u5ba1\u6279\u540e\u7eed\u64cd\u4f5c\uff0c\u6d41\u7a0b\u7ed3\u675f\uff0c\u53d1\u9001\u5df2\u529e\u5165\u53c2umcSendHaveDoneAbilityReqBO:{}", (Object)JSON.toJSONString((Object)umcSendHaveDoneAbilityReqBO));
                UmcSendHaveDoneAbilityRspBO umcSendHaveDoneAbilityRspBO = this.umcSendHaveDoneAbilityService.sendHaveDone(umcSendHaveDoneAbilityReqBO);
                log.info("\u64a4\u9500\u5ba1\u6279\u540e\u7eed\u64cd\u4f5c\uff0c\u6d41\u7a0b\u7ed3\u675f\uff0c\u53d1\u9001\u5df2\u529e\u51fa\u53c2umcSendHaveDoneAbilityRspBO:{}", (Object)JSON.toJSONString((Object)umcSendHaveDoneAbilityRspBO));
            }
            catch (Exception e) {
                log.info("\u64a4\u9500\u5ba1\u6279\u540e\u7eed\u64cd\u4f5c\uff0c\u6d41\u7a0b\u7ed3\u675f\uff0c\u53d1\u9001\u5df2\u529e\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }
}

