/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.tydic.commodity.busibase.atom.api.UccEbsMaterialOperLogAddAtomService;
import com.tydic.commodity.busibase.atom.api.UccEbsMaterialRelCallBackAtomService;
import com.tydic.commodity.busibase.atom.bo.UccEbsMaterialOperLogAddAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccEbsMaterialOperLogAddAtomRspBO;
import com.tydic.commodity.busibase.atom.bo.UccEbsMaterialRelCallBackAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccEbsMaterialRelCallBackAtomRspBO;
import com.tydic.commodity.common.ability.bo.UccPlanCallBackAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccPlanCallBackAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccPlanCallBackBO;
import com.tydic.commodity.common.busi.api.UccPlanCallBackBusiService;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccEbsMaterialMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccEbsMaterialPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.uac.exception.BusinessException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccPlanCallBackBusiServiceImpl
implements UccPlanCallBackBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccPlanCallBackBusiServiceImpl.class);
    @Autowired
    private UccEbsMaterialMapper uccEbsMaterialMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccEbsMaterialOperLogAddAtomService uccEbsMaterialOperLogAddAtomService;
    @Autowired
    private UccEbsMaterialRelCallBackAtomService uccEbsMaterialRelCallBackAtomService;

    @Override
    public UccPlanCallBackAbilityRspBO dealCallBack(UccPlanCallBackAbilityReqBO reqBO) {
        UccPlanCallBackAbilityRspBO rspBO = new UccPlanCallBackAbilityRspBO();
        ArrayList<UccEbsMaterialPO> addlogPOList = new ArrayList<UccEbsMaterialPO>();
        Date time = new Date(System.currentTimeMillis());
        for (UccPlanCallBackBO each : reqBO.getRows()) {
            List uccEbsMaterialPOS = this.uccEbsMaterialMapper.selectByMaterialCode(each.getSysCode(), null, Arrays.asList(each.getEbsMaterialCode()));
            if (CollectionUtils.isEmpty((Collection)uccEbsMaterialPOS)) {
                throw new BusinessException("8888", "\u5165\u53c2eEbsMaterialCode\u672a\u67e5\u8be2\u5230");
            }
            UccEbsMaterialPO updatePO = new UccEbsMaterialPO();
            updatePO.setUpdateTime(time);
            updatePO.setUpdateLoginId(each.getUpdateLoginId());
            updatePO.setUpdateLoginName(each.getUpdateLoginName());
            updatePO.setEbsMaterialId(((UccEbsMaterialPO)uccEbsMaterialPOS.get(0)).getEbsMaterialId());
            updatePO.setEbsMaterialCode(((UccEbsMaterialPO)uccEbsMaterialPOS.get(0)).getEbsMaterialCode());
            updatePO.setEbsMaterialName(((UccEbsMaterialPO)uccEbsMaterialPOS.get(0)).getEbsMaterialName());
            if (((UccEbsMaterialPO)uccEbsMaterialPOS.get(0)).getMaterialId() == null) {
                if (each.getMaterialId() != null) {
                    updatePO.setMaterialId(each.getMaterialId());
                    addlogPOList.add(updatePO);
                }
            } else {
                List uccSkuPoList = this.uccSkuMapper.batchQrySku(Arrays.asList(each.getSkuId()), null);
                if (((UccSkuPo)uccSkuPoList.get(0)).getMaterialId() == null) {
                    UccSkuPo temp = new UccSkuPo();
                    temp.setMaterialId(((UccEbsMaterialPO)uccEbsMaterialPOS.get(0)).getMaterialId().toString());
                    temp.setSkuId(each.getSkuId());
                    this.uccSkuMapper.updateSku(temp);
                }
            }
            if (((UccEbsMaterialPO)uccEbsMaterialPOS.get(0)).getSkuId() == null) {
                updatePO.setSkuId(each.getSkuId());
            }
            if (updatePO.getMaterialId() == null && updatePO.getSkuId() == null) continue;
            this.uccEbsMaterialMapper.updateByPrimaryKeySelective(updatePO);
        }
        if (!CollectionUtils.isEmpty(addlogPOList)) {
            this.addRelLog(addlogPOList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void addRelLog(List<UccEbsMaterialPO> addlogPOList) {
        List materialIds = addlogPOList.stream().map(UccEbsMaterialPO::getMaterialId).collect(Collectors.toList());
        List uccEMdmMaterialPOS = this.uccEMdmMaterialMapper.batchQryById(materialIds);
        if (!CollectionUtils.isEmpty((Collection)uccEMdmMaterialPOS)) {
            Map materialMap = uccEMdmMaterialPOS.stream().collect(Collectors.toMap(UccEMdmMaterialPO::getMaterialId, Function.identity()));
            for (UccEbsMaterialPO each : addlogPOList) {
                try {
                    UccEbsMaterialOperLogAddAtomReqBO uccEbsMaterialOperLogAddAtomReqBO = new UccEbsMaterialOperLogAddAtomReqBO();
                    uccEbsMaterialOperLogAddAtomReqBO.setOperationType(Integer.valueOf(1));
                    uccEbsMaterialOperLogAddAtomReqBO.setOperationContent("\u65b0\u589e\uff1a\u65b0\u589eEBS\u7269\u6599\u7f16\u7801" + each.getEbsMaterialCode() + "\u5173\u8054\u7269\u6599\u7f16\u7801" + ((UccEMdmMaterialPO)materialMap.get(each.getMaterialId())).getMaterialCode());
                    uccEbsMaterialOperLogAddAtomReqBO.setEbsMaterialId(each.getEbsMaterialId());
                    uccEbsMaterialOperLogAddAtomReqBO.setEbsMaterialCode(each.getEbsMaterialCode());
                    uccEbsMaterialOperLogAddAtomReqBO.setEbsMaterialName(each.getEbsMaterialName());
                    uccEbsMaterialOperLogAddAtomReqBO.setMaterialId(each.getMaterialId());
                    uccEbsMaterialOperLogAddAtomReqBO.setMaterialCode(((UccEMdmMaterialPO)materialMap.get(each.getMaterialId())).getMaterialCode());
                    uccEbsMaterialOperLogAddAtomReqBO.setRemark(null);
                    uccEbsMaterialOperLogAddAtomReqBO.setUserId(each.getUpdateLoginId());
                    uccEbsMaterialOperLogAddAtomReqBO.setUsername(each.getUpdateLoginName());
                    UccEbsMaterialOperLogAddAtomRspBO uccEbsMaterialOperLogAddAtomRspBO = this.uccEbsMaterialOperLogAddAtomService.ebsMaterialOperLogAdd(uccEbsMaterialOperLogAddAtomReqBO);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u65b0\u589eebs\u7269\u6599\u5173\u8054\u5173\u7cfb\u65e5\u5fd7\u62a5\u9519:" + e.getMessage());
                }
                UccEbsMaterialRelCallBackAtomReqBO reqBO = new UccEbsMaterialRelCallBackAtomReqBO();
                reqBO.setEbsMaterialId(each.getEbsMaterialId());
                reqBO.setType("NEW");
                UccEbsMaterialRelCallBackAtomRspBO rspBO = this.uccEbsMaterialRelCallBackAtomService.ebsMaterialRelCallBack(reqBO);
                if ("0000".equals(rspBO.getRespCode())) continue;
                throw new BusinessException("8888", "EBS\u7269\u6599\u5173\u8054\u5173\u7cfb\u540c\u6b65\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a" + rspBO.getRespDesc());
            }
        }
    }
}

