/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccSyncNormToEsAbilityReqBO;
import com.tydic.commodity.common.atom.api.UccQryNormSkuFromInterService;
import com.tydic.commodity.common.atom.bo.UccQryNormSkuAtomBO;
import com.tydic.commodity.common.atom.bo.UccQryNormSkuReqBO;
import com.tydic.commodity.common.atom.bo.UccQryNormSkuRspBO;
import com.tydic.commodity.common.busi.api.UccNormSkuSyncBusiService;
import com.tydic.commodity.common.comb.api.UccNormSkuSyncCombService;
import com.tydic.commodity.common.comb.bo.UccNormSkuSyncCombReqBO;
import com.tydic.commodity.common.comb.bo.UccNormSkuSyncCombRspBO;
import com.tydic.commodity.dao.UccNormSpuMapper;
import com.tydic.commodity.dao.UccSyncNormRecordMapper;
import com.tydic.commodity.po.UccSyncNormRecordPO;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccNormSkuSyncCombServiceImpl
implements UccNormSkuSyncCombService {
    private static final Logger log = LoggerFactory.getLogger(UccNormSkuSyncCombServiceImpl.class);
    @Autowired
    private UccQryNormSkuFromInterService uccQryNormSkuFromInterService;
    @Autowired
    private UccNormSkuSyncBusiService uccNormSkuSyncBusiService;
    @Autowired
    private UccSyncNormRecordMapper uccSyncNormRecordMapper;
    @Autowired
    private UccNormSpuMapper uccNormSpuMapper;
    @Value(value="${NORM_SPU_SYNC_TOPIC:NORM_SPU_SYNC_TOPIC}")
    private String normSpuTopic;
    @Value(value="${NORM_SPU_SYNC_TAG:*}")
    private String normSpuTag;
    @Resource(name="lmSyncNormSpuMqServiceProvider")
    private ProxyMessageProducer lmSyncNormSpuMqServiceProvider;

    @Override
    public UccNormSkuSyncCombRspBO syncNormSku(UccNormSkuSyncCombReqBO reqBO) {
        UccNormSkuSyncCombRspBO combRspBO = new UccNormSkuSyncCombRspBO();
        combRspBO.setRespCode("0000");
        UccSyncNormRecordPO recordPO = new UccSyncNormRecordPO();
        recordPO.setRecordId(reqBO.getRecordId());
        UccSyncNormRecordPO normRecordPO = this.uccSyncNormRecordMapper.getModelBy(recordPO);
        if (normRecordPO != null && normRecordPO.getRecordStatus() != 1) {
            UccQryNormSkuReqBO skuReqBO = new UccQryNormSkuReqBO();
            skuReqBO = (UccQryNormSkuReqBO)((Object)JSONObject.parseObject((String)normRecordPO.getParms(), UccQryNormSkuReqBO.class));
            UccQryNormSkuRspBO rspBO = this.uccQryNormSkuFromInterService.qryMsg(skuReqBO);
            if ("0000".equals(rspBO.getRespCode())) {
                reqBO.setRows(rspBO.getRows());
                combRspBO = this.uccNormSkuSyncBusiService.updateNormSku(reqBO);
                if (!"0000".equals(combRspBO.getRespCode())) {
                    reqBO.setErrMsg(combRspBO.getRespDesc());
                    reqBO.setRows(null);
                    combRspBO = this.uccNormSkuSyncBusiService.updateFail(reqBO);
                }
            } else {
                reqBO.setErrMsg(rspBO.getRespDesc());
                combRspBO = this.uccNormSkuSyncBusiService.updateFail(reqBO);
            }
            if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
                UccSyncNormToEsAbilityReqBO sync = new UccSyncNormToEsAbilityReqBO();
                sync.setVCommodityIdList(rspBO.getRows().stream().map(UccQryNormSkuAtomBO::getV_commodity_id).collect(Collectors.toList()));
                sync.setOperType(Integer.valueOf(1));
                try {
                    this.lmSyncNormSpuMqServiceProvider.send(new ProxyMessage(this.normSpuTopic, this.normSpuTag, JSON.toJSONString((Object)sync)));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65\u5546\u54c1\u6570\u636e\u5931\u8d25 \uff1a" + e);
                    throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
                }
            }
        }
        return combRspBO;
    }
}

