/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.comb.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccSyncNormToEsAbilityReqBO;
import com.tydic.commodity.common.busi.api.UccNormSpuCountBusiService;
import com.tydic.commodity.common.comb.api.UccNormSpuCountCombService;
import com.tydic.commodity.common.comb.bo.UccNormSpuCountCombReqBO;
import com.tydic.commodity.common.comb.bo.UccNormSpuCountCombRspBO;
import com.tydic.commodity.dao.UccNormSpuControlMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccNormSpuControlPO;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UccNormSpuCountCombServiceImpl
implements UccNormSpuCountCombService {
    private static final Logger log = LoggerFactory.getLogger(UccNormSpuCountCombServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccNormSpuCountBusiService uccNormSpuCountBusiService;
    @Value(value="${NORM_SPU_SYNC_TOPIC:NORM_SPU_SYNC_TOPIC}")
    private String normSpuTopic;
    @Value(value="${NORM_SPU_SYNC_TAG:*}")
    private String normSpuTag;
    @Resource(name="lmSyncNormSpuMqServiceProvider")
    private ProxyMessageProducer lmSyncNormSpuMqServiceProvider;
    @Autowired
    private UccNormSpuControlMapper uccNormSpuControlMapper;

    @Override
    public UccNormSpuCountCombRspBO syncNormSpuCount(UccNormSpuCountCombReqBO reqBO) {
        UccNormSpuCountCombRspBO combRspBO = new UccNormSpuCountCombRspBO();
        combRspBO.setRespCode("0000");
        if (StringUtils.isEmpty((Object)reqBO.getVCommodityId())) {
            return combRspBO;
        }
        ArrayList<Integer> status = new ArrayList<Integer>();
        status.add(0);
        status.add(2);
        status.add(6);
        status.add(19);
        int count = this.uccSkuMapper.getNormSpuCount(reqBO.getVCommodityId(), status);
        UccNormSpuControlPO controlPO = new UccNormSpuControlPO();
        controlPO.setVCommodityId(reqBO.getVCommodityId());
        controlPO = this.uccNormSpuControlMapper.getModelBy(controlPO);
        if (controlPO == null || controlPO.getCommodityNum() != null && count == controlPO.getCommodityNum()) {
            return combRspBO;
        }
        reqBO.setCount(count);
        combRspBO = this.uccNormSpuCountBusiService.syncNormSpuCount(reqBO);
        if ("0000".equals(combRspBO.getRespCode())) {
            UccSyncNormToEsAbilityReqBO syncNormToEsAbilityReqBO = new UccSyncNormToEsAbilityReqBO();
            syncNormToEsAbilityReqBO.setVCommodityIdList(Arrays.asList(reqBO.getVCommodityId()));
            syncNormToEsAbilityReqBO.setOperType(Integer.valueOf(1));
            try {
                this.lmSyncNormSpuMqServiceProvider.send(new ProxyMessage(this.normSpuTopic, this.normSpuTag, JSON.toJSONString((Object)syncNormToEsAbilityReqBO)));
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u6807\u51c6\u5546\u54c1\u6570\u636e\u5931\u8d25 \uff1a" + e);
                throw new BusinessException("8888", "\u540c\u6b65\u6807\u51c6\u5546\u54c1\u6570\u636e\u5931\u8d25");
            }
        }
        return combRspBO;
    }
}

