/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelNewUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelNewUtils.class);
    private static final String EXCEL_XLS = "xls";
    private static final String EXCEL_XLSX = "xlsx";

    public static void getExcelDate(String path, List<List<String>> data, Integer readLine, Integer sheetAt) throws Exception {
        URL url = new URL(path);
        File file = new File(url.getFile());
        InputStream inputStream = url.openStream();
        ExcelNewUtils.checkExcelVaild(file);
        Workbook workbook = ExcelNewUtils.getWorkbok(file, inputStream);
        int count = 2;
        Sheet sheet = workbook.getSheetAt(sheetAt.intValue());
        for (int rowNum = 2; rowNum <= sheet.getLastRowNum(); ++rowNum) {
            ArrayList<String> c = new ArrayList<String>();
            if (sheet.getRow(rowNum).getPhysicalNumberOfCells() == 0) continue;
            int end = sheet.getRow(rowNum).getLastCellNum();
            for (int i = 1; i < end; ++i) {
                Cell cell = sheet.getRow(rowNum).getCell(i, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                if (cell == null) {
                    c.add("");
                    continue;
                }
                Object obj = ExcelNewUtils.getValue(cell);
                if (count < readLine) continue;
                c.add(String.valueOf(obj).trim());
            }
            ++count;
            if (c.size() <= 0) continue;
            data.add(c);
        }
    }

    public static void getExcelDateIndex(String path, List<List<Object>> data, Integer readLine, Integer sheetAt, Integer inndex) throws Exception {
        URL url = new URL(path);
        File file = new File(url.getFile());
        InputStream inputStream = url.openStream();
        ExcelNewUtils.checkExcelVaild(file);
        Workbook workbook = ExcelNewUtils.getWorkbok(file, inputStream);
        Sheet sheet = workbook.getSheetAt(sheetAt.intValue());
        Iterator rowIterator = sheet.iterator();
        int count = 1;
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            if (count < readLine) {
                ++count;
                continue;
            }
            ++count;
            ArrayList<Object> each = new ArrayList<Object>();
            for (int i = 0; i <= inndex; ++i) {
                Cell cell = row.getCell(i, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                if (cell != null) {
                    switch (cell.getCellType()) {
                        case STRING: {
                            each.add(cell.getStringCellValue());
                            break;
                        }
                        case NUMERIC: {
                            double value = cell.getNumericCellValue();
                            each.add(String.valueOf((long)value));
                            break;
                        }
                        case BOOLEAN: {
                            each.add(cell.getBooleanCellValue());
                            break;
                        }
                        case ERROR: {
                            each.add(cell.getErrorCellValue());
                            break;
                        }
                        default: {
                            each.add(cell.getStringCellValue());
                            break;
                        }
                    }
                    continue;
                }
                each.add("");
            }
            data.add(each);
        }
    }

    private static void checkExcelVaild(File file) throws Exception {
        if (!file.getName().endsWith(EXCEL_XLS) && !file.getName().endsWith(EXCEL_XLSX)) {
            throw new Exception("\u6587\u4ef6\u4e0d\u662fExcel");
        }
    }

    private static Workbook getWorkbok(File file, InputStream inputStream) throws IOException {
        HSSFWorkbook wb = null;
        if (file.getName().endsWith(EXCEL_XLS)) {
            wb = new HSSFWorkbook(inputStream);
        } else if (file.getName().endsWith(EXCEL_XLSX)) {
            wb = new XSSFWorkbook(inputStream);
        }
        return wb;
    }

    private static Object getValue(Cell cell) {
        Object obj = null;
        cell.setCellType(CellType.STRING);
        switch (cell.getCellTypeEnum()) {
            case BOOLEAN: {
                obj = cell.getBooleanCellValue();
                break;
            }
            case ERROR: {
                obj = cell.getErrorCellValue();
                break;
            }
            case NUMERIC: {
                obj = cell.getNumericCellValue();
                break;
            }
            case STRING: {
                obj = cell.getStringCellValue();
                break;
            }
        }
        return obj;
    }
}

