/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.common.ability.api.UccSpuControlImportAddAbilityService;
import com.tydic.commodity.common.ability.bo.UccNormSpuControlImportBO;
import com.tydic.commodity.common.ability.bo.UccSpuControlImportAddAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSpuControlImportAddAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccSpuControlImportAddBusiService;
import com.tydic.commodity.common.utils.ExcelNewUtils;
import com.tydic.commodity.dao.UccNormSpuControlMapper;
import com.tydic.commodity.dao.UccNormSpuMapper;
import com.tydic.commodity.po.UccNormSpuControlPO;
import com.tydic.commodity.po.UccNormSpuPO;
import com.tydic.ppc.ability.bo.PurchaseDemandImportBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSpuControlImportAddAbilityService"})
public class UccSpuControlImportAddAbilityServiceImpl
implements UccSpuControlImportAddAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSpuControlImportAddAbilityServiceImpl.class);
    @Autowired
    private UccSpuControlImportAddBusiService uccSpuControlImportAddBusiService;
    @Autowired
    private UccNormSpuMapper uccNormSpuMapper;
    @Autowired
    private UccNormSpuControlMapper uccNormSpuControlMapper;

    @PostMapping(value={"addSpuControlImport"})
    public UccSpuControlImportAddAbilityRspBO addSpuControlImport(@RequestBody UccSpuControlImportAddAbilityReqBO reqBO) {
        UccSpuControlImportAddAbilityRspBO rspBO = new UccSpuControlImportAddAbilityRspBO();
        if (StringUtils.isEmpty((Object)reqBO.getUrl()) || reqBO.getReqId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5fc5\u4f20\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        List<String> codeList = this.getSpuNameList(reqBO.getUrl());
        if (CollectionUtils.isEmpty(codeList)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        UccNormSpuPO normSpuPO = new UccNormSpuPO();
        normSpuPO.setVCommodityIdList(codeList);
        List normSpuPOList = this.uccNormSpuMapper.getList(normSpuPO);
        ArrayList<UccNormSpuControlImportBO> list = new ArrayList<UccNormSpuControlImportBO>();
        if (!CollectionUtils.isEmpty((Collection)normSpuPOList)) {
            Map spuMap = normSpuPOList.stream().collect(Collectors.toMap(UccNormSpuPO::getVCommodityId, Function.identity()));
            UccNormSpuControlPO controlPO = new UccNormSpuControlPO();
            controlPO.setVCommodityIds(codeList);
            controlPO.setStatus(Integer.valueOf(1));
            List controlPOS = this.uccNormSpuControlMapper.getList(controlPO);
            List controlList = controlPOS.stream().map(UccNormSpuControlPO::getVCommodityId).collect(Collectors.toList());
            HashSet<String> uniqueCheck = new HashSet<String>();
            for (String each : codeList) {
                UccNormSpuControlImportBO importPO = new UccNormSpuControlImportBO();
                if (!spuMap.containsKey(each)) {
                    importPO.setReqId(reqBO.getReqId());
                    importPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    importPO.setVCommodityId(each);
                    importPO.setStatus(Integer.valueOf(0));
                    importPO.setRemark("\u6807\u54c1\u5546\u54c1\u7f16\u7801\uff1a\u201c" + each + "\u201d\uff0c\u4e0d\u6b63\u786e");
                    list.add(importPO);
                    continue;
                }
                if (!"1".equals(reqBO.getIsDeleteImport())) {
                    if (controlList.contains(each) || uniqueCheck.contains(each)) {
                        importPO.setReqId(reqBO.getReqId());
                        importPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                        importPO.setVCommodityId(each);
                        importPO.setStatus(Integer.valueOf(0));
                        importPO.setRemark("\u6807\u54c1\u5546\u54c1\u7f16\u7801\uff1a\u201c" + each + "\u201d\uff0c\u5df2\u7ef4\u62a4");
                        list.add(importPO);
                        continue;
                    }
                } else if (!controlList.contains(each) && !uniqueCheck.contains(each)) {
                    importPO.setReqId(reqBO.getReqId());
                    importPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    importPO.setVCommodityId(each);
                    importPO.setStatus(Integer.valueOf(0));
                    importPO.setRemark("\u6807\u54c1\u5546\u54c1\u7f16\u7801\uff1a\u201c" + each + "\u201d\uff0c\u4e0d\u5b58\u5728");
                    list.add(importPO);
                    continue;
                }
                importPO.setReqId(reqBO.getReqId());
                importPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                importPO.setVCommodityId(each);
                importPO.setStatus(Integer.valueOf(1));
                importPO.setVCommodityName(((UccNormSpuPO)spuMap.get(each)).getVCommodityName());
                importPO.setMarkingRemark(((UccNormSpuPO)spuMap.get(each)).getMarkingRemark());
                importPO.setCategoryId(((UccNormSpuPO)spuMap.get(each)).getCategoryId());
                importPO.setCategoryName(((UccNormSpuPO)spuMap.get(each)).getCategoryName());
                importPO.setCategoryIdFirst(((UccNormSpuPO)spuMap.get(each)).getCategoryIdFirst());
                importPO.setCategoryNameFirst(((UccNormSpuPO)spuMap.get(each)).getCategoryNameFirst());
                importPO.setCategoryIdSecond(((UccNormSpuPO)spuMap.get(each)).getCategoryIdSecond());
                importPO.setCategoryNameSecond(((UccNormSpuPO)spuMap.get(each)).getCategoryNameSecond());
                importPO.setCategoryIdThird(((UccNormSpuPO)spuMap.get(each)).getCategoryIdThird());
                importPO.setCategoryNameThird(((UccNormSpuPO)spuMap.get(each)).getCategoryNameThird());
                importPO.setPropArry(((UccNormSpuPO)spuMap.get(each)).getPropArry());
                list.add(importPO);
                uniqueCheck.add(each);
            }
        } else {
            for (String each : codeList) {
                UccNormSpuControlImportBO importPO = new UccNormSpuControlImportBO();
                importPO.setReqId(reqBO.getReqId());
                importPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                importPO.setVCommodityId(each);
                importPO.setStatus(Integer.valueOf(0));
                importPO.setRemark("\u6807\u54c1\u5546\u54c1\u7f16\u7801\uff1a\u201c" + each + "\u201d\uff0c\u4e0d\u6b63\u786e");
                list.add(importPO);
            }
        }
        reqBO.setRows(list);
        return this.uccSpuControlImportAddBusiService.addSpuControlImport(reqBO);
    }

    private List<String> getSpuNameList(String url) {
        List<Object> data = new ArrayList();
        try {
            data = this.dealEcxel(url, 2, 0, 20);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
        int rowNum = 2;
        ArrayList<String> importData = new ArrayList<String>();
        try {
            if (!CollectionUtils.isEmpty(data)) {
                for (List list : data) {
                    ++rowNum;
                    PurchaseDemandImportBO demandImportBO = new PurchaseDemandImportBO();
                    int i = 0;
                    Object name = list.get(i++);
                    importData.add(String.valueOf(name));
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
        }
        return importData;
    }

    private List<List<Object>> dealEcxel(String url, Integer startReadLine, Integer sheetAt, Integer inndex) {
        if (StringUtils.isEmpty((Object)url)) {
            return new ArrayList<List<Object>>();
        }
        ArrayList<List<Object>> lines = new ArrayList<List<Object>>();
        try {
            ExcelNewUtils.getExcelDateIndex(url, lines, startReadLine, sheetAt, inndex);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u5904\u7406Excel\u5931\u8d25");
        }
        log.info("\u8bfb\u53d6\u5230\u7684\u6570\u636e\uff1a" + JSONObject.toJSONString(lines));
        return lines;
    }
}

