/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.busibase.busi.api.UccSyncDataFailBusiService;
import com.tydic.commodity.busibase.busi.bo.UccSyncDataFailBusiReqBO;
import com.tydic.commodity.busibase.busi.bo.UccSyncDataFailBusiRspBO;
import com.tydic.commodity.common.ability.api.UccTaskSnycGoverFailDataAbilityService;
import com.tydic.commodity.common.ability.bo.UccTaskSnycGoverFailDataAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccTaskSnycGoverFailDataAbilityRspBO;
import com.tydic.commodity.common.comb.bo.UccSnycGovernSkuCombReqBO;
import com.tydic.commodity.common.comb.bo.UccSyncGovernCommodityBindCombReqBO;
import com.tydic.commodity.dao.UccSyncDataFailMapper;
import com.tydic.commodity.po.UccSyncDataFailPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccTaskSnycGoverFailDataAbilityService"})
public class UccTaskSnycGoverFailDataAbilityServiceImpl
implements UccTaskSnycGoverFailDataAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccTaskSnycGoverFailDataAbilityServiceImpl.class);
    @Autowired
    private UccSyncDataFailMapper uccSyncDataFailMapper;
    @Value(value="${SNYC_GOVERN_SKU_TOPIC:SNYC_GOVERN_SKU_TOPIC}")
    private String snycGovernSkuTopic;
    @Resource(name="uccSnycGovernSkuMqProvider")
    private ProxyMessageProducer uccGovernSkuResultMqProvider;
    @Resource(name="uccSyncGovernPriceMqProvider")
    private ProxyMessageProducer uccSyncGovernPriceMqProvider;
    @Value(value="${SYNC_GOVERN_PRICE_TOPIC:SYNC_GOVERN_PRICE_TOPIC}")
    private String syncGovernPriceTopic;
    @Value(value="${SNYC_GOVERN_COMMODITY_BIND_TOPIC:SNYC_GOVERN_COMMODITY_BIND_TOPIC}")
    private String snycGovernCommodityBindTopic;
    @Resource(name="uccSnycGovernCommodityBindMqProvider")
    private ProxyMessageProducer uccSnycGovernCommodityBindMqProvider;
    @Autowired
    private UccSyncDataFailBusiService uccSyncDataFailBusiService;

    @PostMapping(value={"dealTaskAgrin"})
    public UccTaskSnycGoverFailDataAbilityRspBO dealTaskAgrin(@RequestBody UccTaskSnycGoverFailDataAbilityReqBO reqBO) {
        UccTaskSnycGoverFailDataAbilityRspBO rspBO = new UccTaskSnycGoverFailDataAbilityRspBO();
        rspBO.setRespCode("0000");
        UccSyncDataFailPO uccSyncDataFailPO = new UccSyncDataFailPO();
        uccSyncDataFailPO.setSerialNo(reqBO.getSerialNo());
        uccSyncDataFailPO.setType(reqBO.getType());
        List uccSyncDataFailPOS = this.uccSyncDataFailMapper.getList(uccSyncDataFailPO);
        if (CollectionUtils.isEmpty((Collection)uccSyncDataFailPOS)) {
            return rspBO;
        }
        ArrayList<UccSyncDataFailPO> sendSucess = new ArrayList<UccSyncDataFailPO>();
        Map<Integer, List<UccSyncDataFailPO>> typeMap = uccSyncDataFailPOS.stream().collect(Collectors.groupingBy(UccSyncDataFailPO::getType));
        for (Integer type : typeMap.keySet()) {
            List<Long> skus;
            List<UccSyncDataFailPO> poList = typeMap.get(type);
            if (1 == type) {
                skus = poList.stream().map(UccSyncDataFailPO::getSource).collect(Collectors.toList());
                if (!this.sendSkuMq(skus).booleanValue()) continue;
                sendSucess.addAll(poList);
                continue;
            }
            if (2 == type) {
                skus = poList.iterator();
                while (skus.hasNext()) {
                    UccSyncDataFailPO each = (UccSyncDataFailPO)skus.next();
                    if (!this.SendPriceMq(each.getSource()).booleanValue()) continue;
                    sendSucess.add(each);
                }
                continue;
            }
            if (5 != type || !this.SendCommodityBindMq(skus = poList.stream().map(UccSyncDataFailPO::getSource).collect(Collectors.toList())).booleanValue()) continue;
            sendSucess.addAll(poList);
        }
        if (!CollectionUtils.isEmpty(sendSucess)) {
            UccSyncDataFailBusiReqBO busiReqBO = new UccSyncDataFailBusiReqBO();
            List ids = sendSucess.stream().map(UccSyncDataFailPO::getId).collect(Collectors.toList());
            busiReqBO.setId(ids);
            UccSyncDataFailBusiRspBO busiRspBO = this.uccSyncDataFailBusiService.deleteRecords(busiReqBO);
            if (!"0000".equals(busiRspBO.getRespCode())) {
                // empty if block
            }
        }
        return rspBO;
    }

    private Boolean sendSkuMq(List<Long> skus) {
        List<List<Long>> lists = UccTaskSnycGoverFailDataAbilityServiceImpl.averageAssign(skus, 100);
        for (List<Long> each : lists) {
            UccSnycGovernSkuCombReqBO sendMessage = new UccSnycGovernSkuCombReqBO();
            sendMessage.setSkuId(each);
            sendMessage.setIsUpdateSkuType(true);
            try {
                this.uccGovernSkuResultMqProvider.send(new ProxyMessage(this.snycGovernSkuTopic, "*", JSON.toJSONString((Object)sendMessage)));
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u53d1\u9001mq\u5931\u8d25\uff1a " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    private Boolean SendCommodityBindMq(List<Long> skus) {
        List<List<Long>> lists = UccTaskSnycGoverFailDataAbilityServiceImpl.averageAssign(skus, 100);
        for (List<Long> each : lists) {
            UccSyncGovernCommodityBindCombReqBO sendMessage = new UccSyncGovernCommodityBindCombReqBO();
            sendMessage.setSkuId(each);
            try {
                this.uccSnycGovernCommodityBindMqProvider.send(new ProxyMessage(this.snycGovernCommodityBindTopic, "*", JSON.toJSONString((Object)sendMessage)));
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u53d1\u9001mq\u5931\u8d25\uff1a " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    private Boolean SendPriceMq(Long skuId) {
        JSONObject syncCoovern = new JSONObject();
        try {
            syncCoovern.put("skuId", (Object)skuId);
            this.uccSyncGovernPriceMqProvider.send(new ProxyMessage(this.syncGovernPriceTopic, "*", JSON.toJSONString((Object)syncCoovern)));
        }
        catch (Exception e) {
            log.error("\u53d1\u9001MQ\u6570\u636e" + JSON.toJSONString((Object)syncCoovern) + "\u5f02\u5e38\uff1a{}" + e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static <T> List<List<T>> averageAssign(List<T> source, int splitItemNum) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (source != null && source.size() > 0 && splitItemNum > 0) {
            if (source.size() <= splitItemNum) {
                result.add(source);
            } else {
                int splitNum = source.size() % splitItemNum == 0 ? source.size() / splitItemNum : source.size() / splitItemNum + 1;
                List<T> value = null;
                for (int i = 0; i < splitNum; ++i) {
                    value = i < splitNum - 1 ? source.subList(i * splitItemNum, (i + 1) * splitItemNum) : source.subList(i * splitItemNum, source.size());
                    result.add(value);
                }
            }
        }
        return result;
    }
}

