/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.bo.UccSnycGovernSkuBO;
import com.tydic.commodity.base.bo.UccSnycGovernSkuImgBO;
import com.tydic.commodity.base.bo.UccSnycGovernSkuInfoBO;
import com.tydic.commodity.base.bo.UccSnycGovernSkuSpecBO;
import com.tydic.commodity.common.busi.api.UccSnycGovernSkuBusiService;
import com.tydic.commodity.common.comb.bo.UccSnycGovernSkuCombReqBO;
import com.tydic.commodity.common.comb.bo.UccSnycGovernSkuCombRspBO;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuSpecMapper;
import com.tydic.commodity.po.UccCommodityPicPo;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccSkuPicPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.po.UccSkuSpecPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccSnycGovernSkuBusiServiceImpl
implements UccSnycGovernSkuBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSnycGovernSkuBusiServiceImpl.class);
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;

    @Override
    public UccSnycGovernSkuCombRspBO syncGovernSku(UccSnycGovernSkuCombReqBO reqBO) {
        UccSnycGovernSkuCombRspBO combRspBO = new UccSnycGovernSkuCombRspBO();
        combRspBO.setRespCode("0000");
        if (CollectionUtils.isEmpty(reqBO.getUccSkuPos())) {
            return combRspBO;
        }
        UccCommodityTypePo uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(reqBO.getUccSkuPos().get(0).getCommodityTypeId());
        if (uccCommodityTypePo == null) {
            log.error("\u540c\u6b65\u6570\u636e\u5931\u8d25\u5546\u54c1\u7c7b\u578b\uff1a" + reqBO.getUccSkuPos().get(0).getCommodityTypeId() + " \u4e0d\u5b58\u5728");
            return combRspBO;
        }
        UccEMdmCatalogPO uccEMdmCatalogPO = this.uccEMdmCatalogMapper.queryByCatId(uccCommodityTypePo.getCatalogId());
        if (uccEMdmCatalogPO == null) {
            log.error("\u540c\u6b65\u6570\u636e\u5931\u8d25\u5546\u54c1\u5206\u7c7b\uff1a" + uccCommodityTypePo.getCatalogId() + " \u4e0d\u5b58\u5728");
            return combRspBO;
        }
        UccSnycGovernSkuBO skuBO = new UccSnycGovernSkuBO();
        if (uccEMdmCatalogPO.getCatalogName().contains("\uff08\u81ea\u8425\uff09")) {
            log.info("\u6709\u81ea\u8425\uff0c\u66ff\u6362,{}", (Object)uccEMdmCatalogPO.getCatalogName());
            UccEMdmCatalogPO replacePO = this.uccEMdmCatalogMapper.queryCatalogByName(uccEMdmCatalogPO.getCatalogName().replace("\uff08\u81ea\u8425\uff09", ""), uccEMdmCatalogPO.getParentCatalogId());
            if (replacePO == null) {
                log.error("\u540c\u6b65\u6570\u636e\u5931\u8d25\u5546\u54c1\u5206\u7c7b\uff1a" + uccCommodityTypePo.getCatalogId() + " \u7684\u540c\u4e0a\u7ea7\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u64ae\u5408\u7c7b\u5546\u54c1\u7c7b\u76ee");
                combRspBO.setRespDesc("\u540c\u6b65\u6570\u636e\u5931\u8d25\u5546\u54c1\u5206\u7c7b\uff1a" + uccCommodityTypePo.getCatalogId() + " \u7684\u540c\u4e0a\u7ea7\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u64ae\u5408\u7c7b\u5546\u54c1\u7c7b\u76ee");
                return combRspBO;
            }
            skuBO.setCategoryCode(replacePO.getCatalogCode());
            skuBO.setCategoryName(replacePO.getCatalogName());
        } else {
            log.info("\u6ca1\u6709\u81ea\u8425\uff0c\u4e0d\u66ff\u6362,{}", (Object)uccEMdmCatalogPO.getCatalogName());
            skuBO.setCategoryCode(uccEMdmCatalogPO.getCatalogCode());
            skuBO.setCategoryName(uccEMdmCatalogPO.getCatalogName());
        }
        List<Long> skus = reqBO.getUccSkuPos().stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
        List commdIds = reqBO.getUccSkuPos().stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList());
        try {
            this.uccSkuMapper.batchUpdateSpuStepBySkuId(skus, "1");
            this.uccSkuMapper.batchUpdateGovernStatusBySkuId(skus, Integer.valueOf(4));
            this.uccCommodityMapper.batchUpdateStep(commdIds, "1", null);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage());
            return combRspBO;
        }
        combRspBO.setSkus(skus);
        List skuPricePoList = this.uccSkuPriceMapper.batchQryPriBySkuIds(skus, null);
        Map<Object, Object> pricePoMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)skuPricePoList)) {
            pricePoMap = skuPricePoList.stream().collect(Collectors.toMap(UccSkuPricePo::getSkuId, Function.identity()));
        }
        List specPoList = this.uccSkuSpecMapper.qryBatchBySkus(skus);
        Map<Object, Object> specMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)specPoList)) {
            specMap = specPoList.stream().collect(Collectors.groupingBy(UccSkuSpecPo::getSkuId));
        }
        List picPos = this.uccSkuPicMapper.qeurySkuPicBySkuId(skus, null);
        Map<Object, Object> picMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)picPos)) {
            picMap = picPos.stream().collect(Collectors.groupingBy(UccSkuPicPo::getSkuId));
        }
        ArrayList<UccSnycGovernSkuInfoBO> syncCovernSkuList = new ArrayList<UccSnycGovernSkuInfoBO>();
        UccSnycGovernSkuInfoBO snycGovernSkuInfo = null;
        for (UccSkuPo skuEach : reqBO.getUccSkuPos()) {
            snycGovernSkuInfo = new UccSnycGovernSkuInfoBO();
            snycGovernSkuInfo.setSkuId(skuEach.getSkuId().toString());
            snycGovernSkuInfo.setExtSkuId(skuEach.getExtSkuId());
            snycGovernSkuInfo.setSkuName(skuEach.getSkuName());
            snycGovernSkuInfo.setSupplierShopId(skuEach.getSupplierShopId().toString());
            snycGovernSkuInfo.setShopName(skuEach.getShopName());
            snycGovernSkuInfo.setBrandId(skuEach.getBrandId().toString());
            snycGovernSkuInfo.setBrandName(skuEach.getBrandName());
            snycGovernSkuInfo.setSkuStatus(skuEach.getSkuStatus().toString());
            if (pricePoMap.containsKey(skuEach.getSkuId())) {
                snycGovernSkuInfo.setMarketPrice(((UccSkuPricePo)pricePoMap.get(skuEach.getSkuId())).getMarketPrice());
                snycGovernSkuInfo.setSalesPrice(((UccSkuPricePo)pricePoMap.get(skuEach.getSkuId())).getSalePrice());
                snycGovernSkuInfo.setPurchasePrice(((UccSkuPricePo)pricePoMap.get(skuEach.getSkuId())).getAgreementPrice());
            }
            snycGovernSkuInfo.setUpcCode(skuEach.getUpcCode());
            snycGovernSkuInfo.setMfgsku(skuEach.getMfgsku());
            if (specMap.containsKey(skuEach.getSkuId())) {
                List specPoListEach = (List)specMap.get(skuEach.getSkuId());
                List snycGovernSkuSpecBOS = JSONObject.parseArray((String)JSON.toJSONString((Object)specPoListEach), UccSnycGovernSkuSpecBO.class);
                snycGovernSkuInfo.setSpecs(snycGovernSkuSpecBOS);
            }
            if (picMap.containsKey(skuEach.getSkuId())) {
                List eachSkuPic = (List)picMap.get(skuEach.getSkuId());
                ArrayList<UccSnycGovernSkuImgBO> skuImages = new ArrayList<UccSnycGovernSkuImgBO>();
                UccSnycGovernSkuImgBO skuImgBO = null;
                for (UccSkuPicPo commPic : eachSkuPic) {
                    skuImgBO = new UccSnycGovernSkuImgBO();
                    skuImgBO.setSkuPicId(commPic.getSkuPicId().toString());
                    skuImgBO.setSkuPicUrl(commPic.getSkuPicUrl());
                    skuImgBO.setCommodityPicType(commPic.getCommodityPicType());
                    skuImgBO.setRemark(commPic.getRemark());
                    skuImages.add(skuImgBO);
                }
                snycGovernSkuInfo.setSkuImages(skuImages);
            } else {
                UccCommodityPicPo uccCommodityPicPo = new UccCommodityPicPo();
                uccCommodityPicPo.setCommodityId(skuEach.getCommodityId());
                uccCommodityPicPo.setSupplierShopId(skuEach.getSupplierShopId());
                List uccCommodityPicPos = this.uccCommodityPicMapper.queryCommdPic(uccCommodityPicPo);
                if (!CollectionUtils.isEmpty((Collection)uccCommodityPicPos)) {
                    ArrayList<UccSnycGovernSkuImgBO> skuImages = new ArrayList<UccSnycGovernSkuImgBO>();
                    UccSnycGovernSkuImgBO skuImgBO = null;
                    for (UccCommodityPicPo commPic : uccCommodityPicPos) {
                        skuImgBO = new UccSnycGovernSkuImgBO();
                        skuImgBO.setSkuPicId(commPic.getCommodityPicId().toString());
                        skuImgBO.setSkuPicUrl(commPic.getCommodityPicUrl());
                        skuImgBO.setCommodityPicType(commPic.getCommodityPicType());
                        skuImgBO.setRemark(commPic.getRemark());
                        skuImages.add(skuImgBO);
                    }
                    snycGovernSkuInfo.setSkuImages(skuImages);
                }
            }
            syncCovernSkuList.add(snycGovernSkuInfo);
        }
        skuBO.setSkuInfos(syncCovernSkuList);
        combRspBO.setSkuBO(skuBO);
        return combRspBO;
    }

    @Override
    public UccSnycGovernSkuCombRspBO syncGovernSkuTask(UccSnycGovernSkuCombReqBO reqBO) {
        UccSnycGovernSkuCombRspBO combRspBO = new UccSnycGovernSkuCombRspBO();
        combRspBO.setRespCode("0000");
        if (CollectionUtils.isEmpty(reqBO.getUccSkuPos())) {
            return combRspBO;
        }
        UccCommodityTypePo uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(reqBO.getUccSkuPos().get(0).getCommodityTypeId());
        if (uccCommodityTypePo == null) {
            log.error("\u540c\u6b65\u6570\u636e\u5931\u8d25\u5546\u54c1\u7c7b\u578b\uff1a" + reqBO.getUccSkuPos().get(0).getCommodityTypeId() + " \u4e0d\u5b58\u5728");
            return combRspBO;
        }
        UccEMdmCatalogPO uccEMdmCatalogPO = this.uccEMdmCatalogMapper.queryByCatId(uccCommodityTypePo.getCatalogId());
        if (uccEMdmCatalogPO == null) {
            log.error("\u540c\u6b65\u6570\u636e\u5931\u8d25\u5546\u54c1\u5206\u7c7b\uff1a" + uccCommodityTypePo.getCatalogId() + " \u4e0d\u5b58\u5728");
            return combRspBO;
        }
        UccSnycGovernSkuBO skuBO = new UccSnycGovernSkuBO();
        if (uccEMdmCatalogPO.getCatalogName().contains("\uff08\u81ea\u8425\uff09")) {
            log.info("\u6709\u81ea\u8425\uff0c\u66ff\u6362,{}", (Object)uccEMdmCatalogPO.getCatalogName());
            UccEMdmCatalogPO replacePO = this.uccEMdmCatalogMapper.queryCatalogByName(uccEMdmCatalogPO.getCatalogName().replace("\uff08\u81ea\u8425\uff09", ""), uccEMdmCatalogPO.getParentCatalogId());
            if (replacePO == null) {
                log.error("\u540c\u6b65\u6570\u636e\u5931\u8d25\u5546\u54c1\u5206\u7c7b\uff1a" + uccCommodityTypePo.getCatalogId() + " \u7684\u540c\u4e0a\u7ea7\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u64ae\u5408\u7c7b\u5546\u54c1\u7c7b\u76ee");
                combRspBO.setRespDesc("\u540c\u6b65\u6570\u636e\u5931\u8d25\u5546\u54c1\u5206\u7c7b\uff1a" + uccCommodityTypePo.getCatalogId() + " \u7684\u540c\u4e0a\u7ea7\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u64ae\u5408\u7c7b\u5546\u54c1\u7c7b\u76ee");
                return combRspBO;
            }
            skuBO.setCategoryCode(replacePO.getCatalogCode());
            skuBO.setCategoryName(replacePO.getCatalogName());
        } else {
            log.info("\u6ca1\u6709\u81ea\u8425\uff0c\u4e0d\u66ff\u6362,{}", (Object)uccEMdmCatalogPO.getCatalogName());
            skuBO.setCategoryCode(uccEMdmCatalogPO.getCatalogCode());
            skuBO.setCategoryName(uccEMdmCatalogPO.getCatalogName());
        }
        List<Long> skus = reqBO.getUccSkuPos().stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
        List commdIds = reqBO.getUccSkuPos().stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList());
        combRspBO.setSkus(skus);
        List skuPricePoList = this.uccSkuPriceMapper.batchQryPriBySkuIds(skus, null);
        Map<Object, Object> pricePoMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)skuPricePoList)) {
            pricePoMap = skuPricePoList.stream().collect(Collectors.toMap(UccSkuPricePo::getSkuId, Function.identity()));
        }
        List specPoList = this.uccSkuSpecMapper.qryBatchBySkus(skus);
        Map<Object, Object> specMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)specPoList)) {
            specMap = specPoList.stream().collect(Collectors.groupingBy(UccSkuSpecPo::getSkuId));
        }
        List picPos = this.uccSkuPicMapper.qeurySkuPicBySkuId(skus, null);
        Map<Object, Object> picMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)picPos)) {
            picMap = picPos.stream().collect(Collectors.groupingBy(UccSkuPicPo::getSkuId));
        }
        ArrayList<UccSnycGovernSkuInfoBO> syncCovernSkuList = new ArrayList<UccSnycGovernSkuInfoBO>();
        UccSnycGovernSkuInfoBO snycGovernSkuInfo = null;
        for (UccSkuPo skuEach : reqBO.getUccSkuPos()) {
            snycGovernSkuInfo = new UccSnycGovernSkuInfoBO();
            snycGovernSkuInfo.setSkuId(skuEach.getSkuId().toString());
            snycGovernSkuInfo.setExtSkuId(skuEach.getExtSkuId());
            snycGovernSkuInfo.setSkuName(skuEach.getSkuName());
            snycGovernSkuInfo.setSupplierShopId(skuEach.getSupplierShopId().toString());
            snycGovernSkuInfo.setShopName(skuEach.getShopName());
            snycGovernSkuInfo.setBrandId(skuEach.getBrandId().toString());
            snycGovernSkuInfo.setBrandName(skuEach.getBrandName());
            snycGovernSkuInfo.setSkuStatus(skuEach.getSkuStatus().toString());
            if (pricePoMap.containsKey(skuEach.getSkuId())) {
                snycGovernSkuInfo.setMarketPrice(((UccSkuPricePo)pricePoMap.get(skuEach.getSkuId())).getMarketPrice());
                snycGovernSkuInfo.setSalesPrice(((UccSkuPricePo)pricePoMap.get(skuEach.getSkuId())).getSalePrice());
                snycGovernSkuInfo.setPurchasePrice(((UccSkuPricePo)pricePoMap.get(skuEach.getSkuId())).getAgreementPrice());
            }
            snycGovernSkuInfo.setUpcCode(skuEach.getUpcCode());
            snycGovernSkuInfo.setMfgsku(skuEach.getMfgsku());
            if (specMap.containsKey(skuEach.getSkuId())) {
                List specPoListEach = (List)specMap.get(skuEach.getSkuId());
                List snycGovernSkuSpecBOS = JSONObject.parseArray((String)JSON.toJSONString((Object)specPoListEach), UccSnycGovernSkuSpecBO.class);
                snycGovernSkuInfo.setSpecs(snycGovernSkuSpecBOS);
            }
            if (picMap.containsKey(skuEach.getSkuId())) {
                List eachSkuPic = (List)picMap.get(skuEach.getSkuId());
                ArrayList<UccSnycGovernSkuImgBO> skuImages = new ArrayList<UccSnycGovernSkuImgBO>();
                UccSnycGovernSkuImgBO skuImgBO = null;
                for (UccSkuPicPo commPic : eachSkuPic) {
                    skuImgBO = new UccSnycGovernSkuImgBO();
                    skuImgBO.setSkuPicId(commPic.getSkuPicId().toString());
                    skuImgBO.setSkuPicUrl(commPic.getSkuPicUrl());
                    skuImgBO.setCommodityPicType(commPic.getCommodityPicType());
                    skuImgBO.setRemark(commPic.getRemark());
                    skuImages.add(skuImgBO);
                }
                snycGovernSkuInfo.setSkuImages(skuImages);
            } else {
                UccCommodityPicPo uccCommodityPicPo = new UccCommodityPicPo();
                uccCommodityPicPo.setCommodityId(skuEach.getCommodityId());
                uccCommodityPicPo.setSupplierShopId(skuEach.getSupplierShopId());
                List uccCommodityPicPos = this.uccCommodityPicMapper.queryCommdPic(uccCommodityPicPo);
                if (!CollectionUtils.isEmpty((Collection)uccCommodityPicPos)) {
                    ArrayList<UccSnycGovernSkuImgBO> skuImages = new ArrayList<UccSnycGovernSkuImgBO>();
                    UccSnycGovernSkuImgBO skuImgBO = null;
                    for (UccCommodityPicPo commPic : uccCommodityPicPos) {
                        skuImgBO = new UccSnycGovernSkuImgBO();
                        skuImgBO.setSkuPicId(commPic.getCommodityPicId().toString());
                        skuImgBO.setSkuPicUrl(commPic.getCommodityPicUrl());
                        skuImgBO.setCommodityPicType(commPic.getCommodityPicType());
                        skuImgBO.setRemark(commPic.getRemark());
                        skuImages.add(skuImgBO);
                    }
                    snycGovernSkuInfo.setSkuImages(skuImages);
                }
            }
            syncCovernSkuList.add(snycGovernSkuInfo);
        }
        skuBO.setSkuInfos(syncCovernSkuList);
        combRspBO.setSkuBO(skuBO);
        return combRspBO;
    }

    @Override
    public UccSnycGovernSkuCombRspBO syncGovernCommodityBind(UccSnycGovernSkuCombReqBO reqBO) {
        UccSnycGovernSkuCombRspBO combRspBO = new UccSnycGovernSkuCombRspBO();
        combRspBO.setRespCode("0000");
        if (CollectionUtils.isEmpty(reqBO.getUccSkuPos())) {
            return combRspBO;
        }
        UccCommodityTypePo uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(reqBO.getUccSkuPos().get(0).getCommodityTypeId());
        if (uccCommodityTypePo == null) {
            log.error("\u540c\u6b65\u6570\u636e\u5931\u8d25\u5546\u54c1\u7c7b\u578b\uff1a" + reqBO.getUccSkuPos().get(0).getCommodityTypeId() + " \u4e0d\u5b58\u5728");
            return combRspBO;
        }
        UccEMdmCatalogPO uccEMdmCatalogPO = this.uccEMdmCatalogMapper.queryByCatId(uccCommodityTypePo.getCatalogId());
        if (uccEMdmCatalogPO == null) {
            log.error("\u540c\u6b65\u6570\u636e\u5931\u8d25\u5546\u54c1\u5206\u7c7b\uff1a" + uccCommodityTypePo.getCatalogId() + " \u4e0d\u5b58\u5728");
            return combRspBO;
        }
        UccSnycGovernSkuBO skuBO = new UccSnycGovernSkuBO();
        if (uccEMdmCatalogPO.getCatalogName().contains("\uff08\u81ea\u8425\uff09")) {
            log.info("\u6709\u81ea\u8425\uff0c\u66ff\u6362,{}", (Object)uccEMdmCatalogPO.getCatalogName());
            UccEMdmCatalogPO replacePO = this.uccEMdmCatalogMapper.queryCatalogByName(uccEMdmCatalogPO.getCatalogName().replace("\uff08\u81ea\u8425\uff09", ""), uccEMdmCatalogPO.getParentCatalogId());
            if (replacePO == null) {
                log.error("\u540c\u6b65\u6570\u636e\u5931\u8d25\u5546\u54c1\u5206\u7c7b\uff1a" + uccCommodityTypePo.getCatalogId() + " \u7684\u540c\u4e0a\u7ea7\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u64ae\u5408\u7c7b\u5546\u54c1\u7c7b\u76ee");
                combRspBO.setRespDesc("\u540c\u6b65\u6570\u636e\u5931\u8d25\u5546\u54c1\u5206\u7c7b\uff1a" + uccCommodityTypePo.getCatalogId() + " \u7684\u540c\u4e0a\u7ea7\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u64ae\u5408\u7c7b\u5546\u54c1\u7c7b\u76ee");
                return combRspBO;
            }
            skuBO.setCategoryCode(replacePO.getCatalogCode());
            skuBO.setCategoryName(replacePO.getCatalogName());
        } else {
            log.info("\u6ca1\u6709\u81ea\u8425\uff0c\u4e0d\u66ff\u6362,{}", (Object)uccEMdmCatalogPO.getCatalogName());
            skuBO.setCategoryCode(uccEMdmCatalogPO.getCatalogCode());
            skuBO.setCategoryName(uccEMdmCatalogPO.getCatalogName());
        }
        List<Long> skus = reqBO.getUccSkuPos().stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
        List commdIds = reqBO.getUccSkuPos().stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList());
        try {
            for (UccSkuPo skuPo : reqBO.getUccSkuPos()) {
                if (!reqBO.getExpand6Map().containsKey(skuPo.getSkuId()) || reqBO.getExpand6Map().get(skuPo.getSkuId()).equals(skuPo.getStandardCommodityId())) continue;
                UccSkuPo updatePo = new UccSkuPo();
                updatePo.setStandardCommodityId(reqBO.getExpand6Map().get(skuPo.getSkuId()));
                updatePo.setSkuId(skuPo.getSkuId());
                this.uccSkuMapper.updateSku(updatePo);
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u6807\u51c6\u5546\u54c1\u7f16\u7801\uff1a" + e.getMessage());
            return combRspBO;
        }
        combRspBO.setSkus(skus);
        List skuPricePoList = this.uccSkuPriceMapper.batchQryPriBySkuIds(skus, null);
        Map<Object, Object> pricePoMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)skuPricePoList)) {
            pricePoMap = skuPricePoList.stream().collect(Collectors.toMap(UccSkuPricePo::getSkuId, Function.identity()));
        }
        List specPoList = this.uccSkuSpecMapper.qryBatchBySkus(skus);
        Map<Object, Object> specMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)specPoList)) {
            specMap = specPoList.stream().collect(Collectors.groupingBy(UccSkuSpecPo::getSkuId));
        }
        List picPos = this.uccSkuPicMapper.qeurySkuPicBySkuId(skus, null);
        Map<Object, Object> picMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)picPos)) {
            picMap = picPos.stream().collect(Collectors.groupingBy(UccSkuPicPo::getSkuId));
        }
        ArrayList<UccSnycGovernSkuInfoBO> syncCovernSkuList = new ArrayList<UccSnycGovernSkuInfoBO>();
        UccSnycGovernSkuInfoBO snycGovernSkuInfo = null;
        for (UccSkuPo skuEach : reqBO.getUccSkuPos()) {
            snycGovernSkuInfo = new UccSnycGovernSkuInfoBO();
            snycGovernSkuInfo.setSkuId(skuEach.getSkuId().toString());
            snycGovernSkuInfo.setExtSkuId(skuEach.getExtSkuId());
            snycGovernSkuInfo.setSkuName(skuEach.getSkuName());
            if (reqBO.getExpand6Map().containsKey(skuEach.getSkuId())) {
                snycGovernSkuInfo.setSpuId(reqBO.getExpand6Map().get(skuEach.getSkuId()));
            }
            snycGovernSkuInfo.setSupplierShopId(skuEach.getSupplierShopId().toString());
            snycGovernSkuInfo.setShopName(skuEach.getShopName());
            snycGovernSkuInfo.setBrandId(skuEach.getBrandId().toString());
            snycGovernSkuInfo.setBrandName(skuEach.getBrandName());
            snycGovernSkuInfo.setSkuStatus(skuEach.getSkuStatus().toString());
            if (pricePoMap.containsKey(skuEach.getSkuId())) {
                snycGovernSkuInfo.setMarketPrice(((UccSkuPricePo)pricePoMap.get(skuEach.getSkuId())).getMarketPrice());
                snycGovernSkuInfo.setSalesPrice(((UccSkuPricePo)pricePoMap.get(skuEach.getSkuId())).getSalePrice());
                snycGovernSkuInfo.setPurchasePrice(((UccSkuPricePo)pricePoMap.get(skuEach.getSkuId())).getAgreementPrice());
            }
            snycGovernSkuInfo.setUpcCode(skuEach.getUpcCode());
            snycGovernSkuInfo.setMfgsku(skuEach.getMfgsku());
            if (specMap.containsKey(skuEach.getSkuId())) {
                List specPoListEach = (List)specMap.get(skuEach.getSkuId());
                List snycGovernSkuSpecBOS = JSONObject.parseArray((String)JSON.toJSONString((Object)specPoListEach), UccSnycGovernSkuSpecBO.class);
                snycGovernSkuInfo.setSpecs(snycGovernSkuSpecBOS);
            }
            if (picMap.containsKey(skuEach.getSkuId())) {
                List eachSkuPic = (List)picMap.get(skuEach.getSkuId());
                ArrayList<UccSnycGovernSkuImgBO> skuImages = new ArrayList<UccSnycGovernSkuImgBO>();
                UccSnycGovernSkuImgBO skuImgBO = null;
                for (UccSkuPicPo commPic : eachSkuPic) {
                    skuImgBO = new UccSnycGovernSkuImgBO();
                    skuImgBO.setSkuPicId(commPic.getSkuPicId().toString());
                    skuImgBO.setSkuPicUrl(commPic.getSkuPicUrl());
                    skuImgBO.setCommodityPicType(commPic.getCommodityPicType());
                    skuImgBO.setRemark(commPic.getRemark());
                    skuImages.add(skuImgBO);
                }
                snycGovernSkuInfo.setSkuImages(skuImages);
            } else {
                UccCommodityPicPo uccCommodityPicPo = new UccCommodityPicPo();
                uccCommodityPicPo.setCommodityId(skuEach.getCommodityId());
                uccCommodityPicPo.setSupplierShopId(skuEach.getSupplierShopId());
                List uccCommodityPicPos = this.uccCommodityPicMapper.queryCommdPic(uccCommodityPicPo);
                if (!CollectionUtils.isEmpty((Collection)uccCommodityPicPos)) {
                    ArrayList<UccSnycGovernSkuImgBO> skuImages = new ArrayList<UccSnycGovernSkuImgBO>();
                    UccSnycGovernSkuImgBO skuImgBO = null;
                    for (UccCommodityPicPo commPic : uccCommodityPicPos) {
                        skuImgBO = new UccSnycGovernSkuImgBO();
                        skuImgBO.setSkuPicId(commPic.getCommodityPicId().toString());
                        skuImgBO.setSkuPicUrl(commPic.getCommodityPicUrl());
                        skuImgBO.setCommodityPicType(commPic.getCommodityPicType());
                        skuImgBO.setRemark(commPic.getRemark());
                        skuImages.add(skuImgBO);
                    }
                    snycGovernSkuInfo.setSkuImages(skuImages);
                }
            }
            syncCovernSkuList.add(snycGovernSkuInfo);
        }
        skuBO.setSkuInfos(syncCovernSkuList);
        combRspBO.setSkuBO(skuBO);
        return combRspBO;
    }
}

