/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.common.ability.api.UccNormSpuCountAbilityService;
import com.tydic.commodity.common.ability.bo.UccNormSpuCountAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccNormSpuCountAbilityRspBO;
import com.tydic.commodity.common.comb.bo.UccNormSpuCountCombReqBO;
import com.tydic.commodity.dao.UccNormSpuControlMapper;
import com.tydic.commodity.po.UccNormSpuControlPO;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccNormSpuCountAbilityService"})
public class UccNormSpuCountAbilityServiceImpl
implements UccNormSpuCountAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccNormSpuCountAbilityServiceImpl.class);
    @Autowired
    private UccNormSpuControlMapper uccNormSpuControlMapper;
    @Resource(name="uccNormSpuCountSyncProvider")
    private ProxyMessageProducer uccNormSpuCountSyncProvider;
    @Value(value="${UCC_NORM_SPU_COUNT_SYNC_TOPIC:UCC_NORM_SPU_COUNT_SYNC_TOPIC}")
    private String UCC_NORM_SPU_COUNT_SYNC_TOPIC;
    @Value(value="${UCC_NORM_SPU_COUNT_SYNC_TAG:*}")
    private String UCC_NORM_SPU_COUNT_SYNC_TAG;

    @PostMapping(value={"syncNormSpuCount"})
    public UccNormSpuCountAbilityRspBO syncNormSpuCount(@RequestBody UccNormSpuCountAbilityReqBO reqBO) {
        UccNormSpuCountAbilityRspBO rspBO = new UccNormSpuCountAbilityRspBO();
        rspBO.setRespCode("0000");
        UccNormSpuControlPO normSpuControlPO = new UccNormSpuControlPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)normSpuControlPO);
        normSpuControlPO.setStatus(Integer.valueOf(1));
        Page page = new Page(1, 1000);
        List list = this.uccNormSpuControlMapper.getListPage(normSpuControlPO, page);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return rspBO;
        }
        this.syncMq(list);
        Integer total = page.getTotalPages();
        for (int i = 2; i <= total; ++i) {
            page = new Page(i, 1000);
            list = this.uccNormSpuControlMapper.getListPage(normSpuControlPO, page);
            this.syncMq(list);
        }
        return rspBO;
    }

    private void syncMq(List<UccNormSpuControlPO> list) {
        UccNormSpuCountCombReqBO countCombReqBO = null;
        for (UccNormSpuControlPO each : list) {
            countCombReqBO = new UccNormSpuCountCombReqBO();
            countCombReqBO.setSysTenantId(each.getSysTenantId());
            countCombReqBO.setVCommodityId(each.getVCommodityId());
            this.uccNormSpuCountSyncProvider.send(new ProxyMessage(this.UCC_NORM_SPU_COUNT_SYNC_TOPIC, this.UCC_NORM_SPU_COUNT_SYNC_TAG, JSON.toJSONString((Object)countCombReqBO)));
        }
    }
}

